/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.util;

import java.util.Queue;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.util.QueueProcessingThread;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class Listener<Type> {
    private final String clientName;
    private @Nullable ListenerThread thread;

    public Listener(@NonNull Client client, @Nullable Consumer<Type> consumer) {
        this.clientName = Sanity.nullCheck(client, "Client").getName();
        this.thread = consumer == null ? null : new ListenerThread(this.clientName, consumer);
    }

    public void queue(@NonNull Type item) {
        if (this.thread != null) {
            this.thread.queue(item);
        }
    }

    public void removeConsumer() {
        this.shutdown();
        this.thread = null;
    }

    public void setConsumer(@NonNull Consumer<Type> consumer) {
        if (this.thread == null) {
            this.thread = new ListenerThread(this.clientName, consumer);
        } else {
            this.thread.consumer = consumer;
        }
    }

    public void shutdown() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public @NonNull String toString() {
        return new ToStringer(this).add("clientName", this.clientName).toString();
    }

    private final class ListenerThread
    extends QueueProcessingThread<Type> {
        private volatile Consumer<Type> consumer;

        private ListenerThread(@NonNull String clientName, Consumer<Type> consumer) {
            super("KICL Listener (" + clientName + ')');
            this.consumer = consumer;
        }

        @Override
        protected void processElement(@NonNull Type element) {
            try {
                this.consumer.accept(element);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        protected void cleanup(@NonNull Queue<Type> remainingQueue) {
            while (!remainingQueue.isEmpty()) {
                try {
                    this.consumer.accept(remainingQueue.poll());
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

