/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.command;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.command.ChannelCommand;
import org.kitteh.irc.client.library.element.User;
import org.kitteh.irc.client.library.feature.defaultmessage.DefaultMessageType;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class KickCommand
extends ChannelCommand<KickCommand> {
    private String target;
    private @Nullable String reason = this.getClient().getDefaultMessageMap().getDefault(DefaultMessageType.KICK).orElse(null);

    public KickCommand(@NonNull Client client, @NonNull String channel) {
        super(client, channel);
    }

    public @NonNull KickCommand target(@NonNull String target) {
        this.target = Sanity.safeMessageCheck(target, "Target");
        return this;
    }

    public @NonNull KickCommand target(@NonNull User target) {
        Sanity.nullCheck(target, "Target");
        Sanity.truthiness(target.getClient() == this.getClient(), "User comes from a different client");
        this.target(target.getNick());
        return this;
    }

    public @NonNull KickCommand reason(@Nullable String reason) {
        this.reason = reason == null ? null : Sanity.safeMessageCheck(reason, "Reason");
        return this;
    }

    @Override
    public void execute() {
        if (this.target == null) {
            throw new IllegalStateException("Target not defined");
        }
        this.sendCommandLine("KICK " + this.getChannel() + ' ' + this.target + (this.reason != null ? " :" + this.reason : ""));
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("target", this.target).add("reason", this.reason);
    }
}

