/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.command;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.command.Command;
import org.kitteh.irc.client.library.element.MessageReceiver;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class TagMessageCommand
extends Command<TagMessageCommand> {
    private String target;

    public TagMessageCommand(@NonNull Client client) {
        super(client);
    }

    public @NonNull TagMessageCommand target(@NonNull String target) {
        this.target = Sanity.safeMessageCheck(target, "Target");
        return this;
    }

    public @NonNull TagMessageCommand target(@NonNull MessageReceiver target) {
        this.target = Sanity.nullCheck(target, "Target").getMessagingName();
        return this;
    }

    @Override
    public void execute() {
        if (this.target == null) {
            throw new IllegalStateException("Target not defined");
        }
        this.sendCommandLine("TAGMSG " + this.target);
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("target", this.target);
    }
}

