/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.command;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.command.ChannelCommand;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class TopicCommand
extends ChannelCommand<TopicCommand> {
    private @Nullable String topic;

    public TopicCommand(@NonNull Client client, @NonNull String channel) {
        super(client, channel);
    }

    public @NonNull TopicCommand topic(@Nullable String topic) {
        this.topic = topic == null ? null : Sanity.safeMessageCheck(topic, "Topic");
        return this;
    }

    public @NonNull TopicCommand query() {
        this.topic = null;
        return this;
    }

    @Override
    public synchronized void execute() {
        this.sendCommandLine("TOPIC " + this.getChannel() + (this.topic == null ? "" : " :" + this.topic));
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("topic", this.topic);
    }
}

