/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.element.isupport;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportParameterValueRequired;
import org.kitteh.irc.client.library.element.ISupportParameter;

public class DefaultISupportMaxList
extends DefaultISupportParameterValueRequired
implements ISupportParameter.MaxList {
    private final Set<ISupportParameter.MaxList.LimitData> data;

    public DefaultISupportMaxList(@NonNull Client client, @NonNull String name, @Nullable String value) {
        super(client, name, value);
        HashSet<DefaultLimitData> limitData = new HashSet<DefaultLimitData>();
        for (String limit : value.split(",")) {
            String[] split = limit.split(":");
            HashSet<Character> modes = new HashSet<Character>();
            for (char c : split[0].toCharArray()) {
                modes.add(Character.valueOf(c));
            }
            limitData.add(new DefaultLimitData(modes, Integer.parseInt(split[1])));
        }
        this.data = Collections.unmodifiableSet(limitData);
    }

    @Override
    public @NonNull Set<ISupportParameter.MaxList.LimitData> getAllLimitData() {
        return this.data;
    }

    @Override
    public int getLimit(char c) {
        return this.data.stream().filter(d -> d.getModes().contains(Character.valueOf(c))).mapToInt(ISupportParameter.MaxList.LimitData::getLimit).findFirst().orElse(-1);
    }

    @Override
    public @NonNull Optional<ISupportParameter.MaxList.LimitData> getLimitData(char c) {
        return this.data.stream().filter(d -> d.getModes().contains(Character.valueOf(c))).findFirst();
    }

    public static class DefaultLimitData
    implements ISupportParameter.MaxList.LimitData {
        private final int limit;
        private final Set<Character> modes;

        public DefaultLimitData(@NonNull Set<Character> modes, int limit) {
            this.limit = limit;
            this.modes = Collections.unmodifiableSet(modes);
        }

        @Override
        public int getLimit() {
            return this.limit;
        }

        @Override
        public @NonNull Set<Character> getModes() {
            return this.modes;
        }
    }
}

