/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.element.mode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.element.mode.DefaultModeStatus;
import org.kitteh.irc.client.library.element.ClientLinked;
import org.kitteh.irc.client.library.element.mode.ChannelMode;
import org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import org.kitteh.irc.client.library.element.mode.Mode;
import org.kitteh.irc.client.library.element.mode.ModeStatus;
import org.kitteh.irc.client.library.element.mode.ModeStatusList;
import org.kitteh.irc.client.library.element.mode.UserMode;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class DefaultModeStatusList<ModeType extends Mode>
implements ModeStatusList<ModeType> {
    private final List<ModeStatus<ModeType>> statuses;

    public static @NonNull DefaultModeStatusList<ChannelMode> fromChannel(@NonNull Client client, @NonNull String string) {
        HashMap modes = new HashMap();
        client.getServerInfo().getChannelModes().forEach(mode -> modes.put(Character.valueOf(mode.getChar()), mode));
        client.getServerInfo().getChannelUserModes().forEach(mode -> {
            ChannelMode cfr_ignored_0 = modes.put(Character.valueOf(mode.getChar()), mode);
        });
        return DefaultModeStatusList.from(string, modes);
    }

    public static @NonNull DefaultModeStatusList<UserMode> fromUser(@NonNull Client client, @NonNull String string) {
        return DefaultModeStatusList.from(string, client.getServerInfo().getUserModes().stream().collect(Collectors.toMap(Mode::getChar, Function.identity())));
    }

    private static <ModeType extends Mode> @NonNull DefaultModeStatusList<ModeType> from(@NonNull String string, @NonNull Map<Character, ModeType> modes) {
        Sanity.safeMessageCheck(string, "String");
        ArrayList<ModeStatus<ModeType>> list = new ArrayList<ModeStatus<ModeType>>();
        String[] args = string.split(" ");
        int currentArg = -1;
        while (++currentArg < args.length) {
            String changes = args[currentArg];
            if (changes.charAt(0) != '+' && changes.charAt(0) != '-') {
                throw new IllegalArgumentException("Mode change does not start with + or -");
            }
            ModeStatus.Action action = null;
            block5: for (char modeChar : changes.toCharArray()) {
                switch (modeChar) {
                    case '+': {
                        action = ModeStatus.Action.ADD;
                        continue block5;
                    }
                    case '-': {
                        action = ModeStatus.Action.REMOVE;
                        continue block5;
                    }
                    default: {
                        Mode mode = (Mode)modes.get(Character.valueOf(modeChar));
                        if (mode == null) {
                            throw new IllegalArgumentException("Contains non-registered mode: " + modeChar);
                        }
                        String target = null;
                        if (mode instanceof ChannelMode && (mode instanceof ChannelUserMode || (action == ModeStatus.Action.ADD ? ((ChannelMode)mode).getType().isParameterRequiredOnSetting() : ((ChannelMode)mode).getType().isParameterRequiredOnRemoval()))) {
                            target = args[++currentArg];
                        }
                        list.add(target == null ? new DefaultModeStatus<Mode>(action, mode) : new DefaultModeStatus<Mode>(action, mode, target));
                    }
                }
            }
        }
        return DefaultModeStatusList.of(list);
    }

    public static <ModeType extends Mode> @NonNull DefaultModeStatusList<ModeType> of(ModeStatus<ModeType> ... statuses) {
        Sanity.nullCheck(statuses, "Statuses");
        Sanity.truthiness(statuses.length <= 1 || Arrays.stream(statuses).map(ClientLinked::getClient).distinct().count() == 1L, "Statuses must all be from one client");
        return new DefaultModeStatusList<ModeType>(Arrays.asList(statuses));
    }

    public static <ModeType extends Mode> @NonNull DefaultModeStatusList<ModeType> of(@NonNull Collection<ModeStatus<ModeType>> statuses) {
        Sanity.nullCheck(statuses, "Statuses");
        ArrayList<ModeStatus<ModeType>> list = new ArrayList<ModeStatus<ModeType>>(statuses);
        Sanity.truthiness(list.size() <= 1 || list.stream().map(ClientLinked::getClient).distinct().count() == 1L, "Statuses must all be from one client");
        return new DefaultModeStatusList<ModeType>(list);
    }

    private DefaultModeStatusList(List<ModeStatus<ModeType>> statuses) {
        this.statuses = statuses;
    }

    @Override
    public boolean contains(@NonNull ModeType mode) {
        Sanity.nullCheck(mode, "Mode");
        return this.statuses.stream().anyMatch(status -> status.getMode().equals(mode));
    }

    @Override
    public boolean containsMode(char mode) {
        return this.statuses.stream().anyMatch(status -> status.getMode().getChar() == mode);
    }

    @Override
    public @NonNull List<ModeStatus<ModeType>> getByMode(@NonNull ModeType mode) {
        Sanity.nullCheck(mode, "Mode");
        return Collections.unmodifiableList(this.statuses.stream().filter(status -> status.getMode().equals(mode)).collect(Collectors.toList()));
    }

    @Override
    public @NonNull List<ModeStatus<ModeType>> getByMode(char mode) {
        return Collections.unmodifiableList(this.statuses.stream().filter(status -> status.getMode().getChar() == mode).collect(Collectors.toList()));
    }

    @Override
    public @NonNull List<ModeStatus<ModeType>> getAll() {
        return Collections.unmodifiableList(this.statuses);
    }

    @Override
    public @NonNull String getAsString() {
        StringBuilder modes = new StringBuilder(this.statuses.size() * 2);
        StringBuilder parameters = new StringBuilder(100);
        ModeStatus.Action action = null;
        for (ModeStatus<ModeType> change : this.statuses) {
            if (action == null || action != change.getAction()) {
                action = change.getAction();
                modes.append(action.getChar());
            }
            modes.append(change.getMode().getChar());
            Optional<String> parameter = change.getParameter();
            parameter.ifPresent(s -> parameters.append(' ').append((String)s));
        }
        return modes.toString() + parameters;
    }

    public @NonNull String toString() {
        return new ToStringer(this).add("list", this.statuses).toString();
    }
}

