/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.element.mode.DefaultChannelMode;
import org.kitteh.irc.client.library.defaults.element.mode.DefaultChannelUserMode;
import org.kitteh.irc.client.library.defaults.element.mode.DefaultUserMode;
import org.kitteh.irc.client.library.element.ISupportParameter;
import org.kitteh.irc.client.library.element.mode.ChannelMode;
import org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import org.kitteh.irc.client.library.element.mode.Mode;
import org.kitteh.irc.client.library.element.mode.UserMode;
import org.kitteh.irc.client.library.feature.ServerInfo;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class DefaultServerInfo
implements ServerInfo.WithManagement {
    private final Client client;
    private final Map<String, ISupportParameter> iSupportParameterMap = new ConcurrentHashMap<String, ISupportParameter>();
    private final List<ChannelMode> defaultChannelModes;
    private final List<ChannelMode> customChannelModes = new CopyOnWriteArrayList<ChannelMode>();
    private final List<Character> defaultChannelPrefixes = Arrays.asList(Character.valueOf('#'), Character.valueOf('&'), Character.valueOf('!'), Character.valueOf('+'));
    private final List<ChannelUserMode> defaultChannelUserModes;
    private List<String> motd;
    private String address;
    private String version;
    private final List<UserMode> userModes = new CopyOnWriteArrayList<UserMode>();
    private final List<UserMode> customUserModes = new CopyOnWriteArrayList<UserMode>();
    private final Pattern channelPattern = Pattern.compile("([#!&+][^ ,\\07\\r\\n]+)");

    public DefaultServerInfo(@NonNull Client client) {
        this.client = client;
        ArrayList<DefaultChannelMode> defaultChannelModes = new ArrayList<DefaultChannelMode>(9);
        defaultChannelModes.add(new DefaultChannelMode(client, 't', ChannelMode.Type.D_PARAMETER_NEVER));
        defaultChannelModes.add(new DefaultChannelMode(client, 's', ChannelMode.Type.D_PARAMETER_NEVER));
        defaultChannelModes.add(new DefaultChannelMode(client, 'p', ChannelMode.Type.D_PARAMETER_NEVER));
        defaultChannelModes.add(new DefaultChannelMode(client, 'n', ChannelMode.Type.D_PARAMETER_NEVER));
        defaultChannelModes.add(new DefaultChannelMode(client, 'm', ChannelMode.Type.D_PARAMETER_NEVER));
        defaultChannelModes.add(new DefaultChannelMode(client, 'i', ChannelMode.Type.D_PARAMETER_NEVER));
        defaultChannelModes.add(new DefaultChannelMode(client, 'l', ChannelMode.Type.C_PARAMETER_ON_SET));
        defaultChannelModes.add(new DefaultChannelMode(client, 'k', ChannelMode.Type.B_PARAMETER_ALWAYS));
        defaultChannelModes.add(new DefaultChannelMode(client, 'b', ChannelMode.Type.A_MASK));
        this.defaultChannelModes = Collections.unmodifiableList(defaultChannelModes);
        ArrayList<DefaultChannelUserMode> defaultChannelUserModes = new ArrayList<DefaultChannelUserMode>(2);
        defaultChannelUserModes.add(new DefaultChannelUserMode(client, 'o', '@'));
        defaultChannelUserModes.add(new DefaultChannelUserMode(client, 'v', '+'));
        this.defaultChannelUserModes = Collections.unmodifiableList(defaultChannelUserModes);
        this.userModes.add(new DefaultUserMode(client, 'i'));
        this.userModes.add(new DefaultUserMode(client, 's'));
        this.userModes.add(new DefaultUserMode(client, 'w'));
        this.userModes.add(new DefaultUserMode(client, 'o'));
    }

    @Override
    public void addCustomChannelMode(@NonNull ChannelMode mode) {
        this.customChannelModes.add(Sanity.nullCheck(mode, "mode"));
    }

    @Override
    public void addCustomUserMode(@NonNull UserMode mode) {
        this.customUserModes.add(Sanity.nullCheck(mode, "mode"));
    }

    @Override
    public @NonNull Optional<String> getAddress() {
        return Optional.ofNullable(this.address);
    }

    @Override
    public void setAddress(@NonNull String serverAddress) {
        this.address = serverAddress;
    }

    @Override
    public @NonNull List<ChannelMode> getChannelModes() {
        Optional<ISupportParameter.ChanModes> optional = this.getISupportParameter("CHANMODES", ISupportParameter.ChanModes.class);
        ArrayList<ChannelMode> list = new ArrayList<ChannelMode>();
        List<ChannelMode> modes = optional.map(ISupportParameter.ChanModes::getModes).orElse(this.defaultChannelModes);
        Set customModeChars = this.customChannelModes.stream().map(Mode::getChar).collect(Collectors.toSet());
        modes.stream().filter(mode -> !customModeChars.contains(Character.valueOf(mode.getChar()))).forEach(list::add);
        list.addAll(this.customChannelModes);
        return list;
    }

    @Override
    public @NonNull List<Character> getChannelPrefixes() {
        Optional<ISupportParameter.ChanTypes> optional = this.getISupportParameter("CHANTYPES", ISupportParameter.ChanTypes.class);
        return new ArrayList<Character>((Collection)optional.map(ISupportParameter.ChanTypes::getTypes).orElse(this.defaultChannelPrefixes));
    }

    @Override
    public @NonNull List<ChannelUserMode> getChannelUserModes() {
        Optional<ISupportParameter.Prefix> optional = this.getISupportParameter("PREFIX", ISupportParameter.Prefix.class);
        return new ArrayList<ChannelUserMode>((Collection)optional.map(ISupportParameter.Prefix::getModes).orElse(this.defaultChannelUserModes));
    }

    @Override
    public @NonNull Optional<ISupportParameter> getISupportParameter(@NonNull String name) {
        Sanity.nullCheck(name, "Name");
        return Optional.ofNullable(this.iSupportParameterMap.get(name.toUpperCase()));
    }

    @Override
    public @NonNull Map<String, ISupportParameter> getISupportParameters() {
        return Collections.unmodifiableMap(new HashMap<String, ISupportParameter>(this.iSupportParameterMap));
    }

    @Override
    public void addISupportParameter(@NonNull ISupportParameter parameter) {
        this.iSupportParameterMap.put(parameter.getName().toUpperCase(), parameter);
    }

    @Override
    public @NonNull Optional<List<String>> getMotd() {
        return Optional.ofNullable(this.motd);
    }

    @Override
    public void setMotd(@NonNull List<String> motd) {
        this.motd = Collections.unmodifiableList(motd);
    }

    @Override
    public @NonNull Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    public void setVersion(@NonNull String version) {
        this.version = version;
    }

    @Override
    public boolean isValidChannel(@NonNull String name) {
        Sanity.nullCheck(name, "Channel name");
        int channelLengthLimit = this.getChannelLengthLimit();
        return name.length() > 1 && (channelLengthLimit < 0 || name.length() <= channelLengthLimit) && this.getChannelPrefixes().contains(Character.valueOf(name.charAt(0))) && this.channelPattern.matcher(name).matches();
    }

    @Override
    public @NonNull Optional<ChannelUserMode> getTargetedChannelInfo(@NonNull String name) {
        if (name.length() < 2) {
            return Optional.empty();
        }
        char first = name.charAt(0);
        String shorter = name.substring(1);
        if (!this.getChannelPrefixes().contains(Character.valueOf(first)) && this.isValidChannel(shorter)) {
            for (ChannelUserMode mode : this.getChannelUserModes()) {
                if (mode.getNickPrefix() != first) continue;
                return Optional.of(mode);
            }
        }
        return Optional.empty();
    }

    @Override
    public @NonNull List<UserMode> getUserModes() {
        ArrayList<UserMode> list = new ArrayList<UserMode>();
        Set customModeChars = this.customUserModes.stream().map(Mode::getChar).collect(Collectors.toSet());
        this.userModes.stream().filter(mode -> !customModeChars.contains(Character.valueOf(mode.getChar()))).forEach(list::add);
        list.addAll(this.customUserModes);
        return list;
    }

    @Override
    public void setUserModes(@NonNull List<UserMode> userModes) {
        this.userModes.clear();
        this.userModes.addAll(userModes);
    }

    public @NonNull String toString() {
        return new ToStringer(this).add("client", this.client).add("address", this.address).add("version", this.version).add("motd", this.motd).add("channelModes", this.getChannelModes()).add("channelPrefixes", this.getChannelPrefixes()).add("channelUserModes", this.getChannelUserModes()).add("userModes", this.userModes).add("iSupportParameters", this.iSupportParameterMap).toString();
    }
}

