/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.listener;

import java.util.Optional;
import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import org.kitteh.irc.client.library.element.User;
import org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import org.kitteh.irc.client.library.event.user.UserRealnameChangeEvent;
import org.kitteh.irc.client.library.feature.filter.CommandFilter;

public class DefaultSetNameListener
extends AbstractDefaultListenerBase {
    public DefaultSetNameListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @CommandFilter(value="SETNAME")
    @Handler(priority=0x7FFFFFFE)
    public void setname(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() != 1) {
            this.trackException(event, "Invalid number of parameters for SETNAME message");
            return;
        }
        if (!(event.getActor() instanceof User)) {
            this.trackException(event, "Invalid actor for SETNAME message");
            return;
        }
        User user = (User)event.getActor();
        Optional<User> optUser = this.getTracker().getTrackedUser(user.getNick());
        if (!optUser.isPresent()) {
            this.trackException(event, "Null old user for nick");
            return;
        }
        User oldUser = optUser.get();
        String newRealName = event.getParameters().get(0);
        this.getTracker().trackUserRealnameChange(user.getNick(), newRealName);
        this.fire(new UserRealnameChangeEvent(this.getClient(), event.getSource(), oldUser, this.getTracker().getTrackedUser(user.getNick()).get()));
    }
}

