/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.element;

import java.time.Instant;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface MessageTag {
    public @NonNull String getName();

    public @NonNull Optional<String> getValue();

    default public @NonNull Optional<String> getEscapedValue() {
        return this.getValue().map(s -> s.replace(";", "\\:").replace(" ", "\\s").replace("\\", "\\\\").replace("\r", "\\r").replace("\n", "\\n"));
    }

    default public boolean isClientOnly() {
        return !this.getName().isEmpty() && this.getName().charAt(0) == '+';
    }

    default public @NonNull String getAsString() {
        return this.getEscapedValue().map(s -> this.getName() + '=' + s).orElseGet(this::getName);
    }

    public static interface Typing
    extends MessageTag {
        public @NonNull State getState();

        public static enum State {
            ACTIVE,
            DONE,
            PAUSED;

        }
    }

    public static interface Time
    extends MessageTag {
        public @NonNull Instant getTime();
    }

    public static interface MsgId
    extends MessageTag {
        public @NonNull String getId();
    }

    public static interface Label
    extends MessageTag {
        public @NonNull String getLabel();
    }

    public static interface Bot
    extends MessageTag {
    }
}

