/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.element;

import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.element.MessageTag;
import org.kitteh.irc.client.library.util.Sanity;

public interface ServerMessage {
    public @NonNull String getMessage();

    public @NonNull List<MessageTag> getTags();

    default public Optional<MessageTag> getTag(@NonNull String name) {
        Sanity.nullCheck(name, "Name");
        return this.getTags().stream().filter(tag -> tag.getName().equals(name)).findAny();
    }

    default public <Tag extends MessageTag> @NonNull Optional<Tag> getTag(@NonNull String name, @NonNull Class<Tag> clazz) {
        Sanity.nullCheck(name, "Name");
        Sanity.nullCheck(clazz, "Class");
        return this.getTags().stream().filter(tag -> tag.getName().equals(name)).filter(clazz::isInstance).map(tag -> tag).findAny();
    }

    public static interface NumericCommandServerMessage
    extends ServerMessage {
        public int getCommand();
    }

    public static interface StringCommandServerMessage
    extends ServerMessage {
        public @NonNull String getCommand();
    }
}

