/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.element.mode;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.mode.Mode;

public interface ChannelMode
extends Mode {
    public @NonNull Type getType();

    public static @NonNull Optional<ChannelMode> get(@NonNull Client client, char mode) {
        return client.getServerInfo().getChannelModes().stream().filter(m -> m.getChar() == mode).findFirst();
    }

    public static enum Type {
        A_MASK(true, true),
        B_PARAMETER_ALWAYS(true, true),
        C_PARAMETER_ON_SET(true, false),
        D_PARAMETER_NEVER(false, false);

        private final boolean parameterRequiredOnRemoval;
        private final boolean parameterRequiredOnSetting;

        private Type(boolean parameterRequiredOnSetting, boolean parameterRequiredOnRemoval) {
            this.parameterRequiredOnRemoval = parameterRequiredOnRemoval;
            this.parameterRequiredOnSetting = parameterRequiredOnSetting;
        }

        public boolean isParameterRequiredOnRemoval() {
            return this.parameterRequiredOnRemoval;
        }

        public boolean isParameterRequiredOnSetting() {
            return this.parameterRequiredOnSetting;
        }
    }
}

