/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.connection;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.event.abstractbase.ClientEventBase;
import org.kitteh.irc.client.library.event.helper.ConnectionEvent;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public abstract class ClientConnectionEndedEvent
extends ClientEventBase
implements ConnectionEvent {
    public static final int DEFAULT_RECONNECTION_DELAY_MILLIS = 5000;
    private final boolean canReconnect;
    private final @Nullable Throwable cause;
    private int reconnectionDelayMillis = 5000;
    private boolean attemptReconnect;

    protected ClientConnectionEndedEvent(@NonNull Client client, boolean canReconnect, @Nullable Throwable cause) {
        super(client);
        this.canReconnect = canReconnect;
        this.attemptReconnect = canReconnect;
        this.cause = cause;
    }

    public @NonNull Optional<Throwable> getCause() {
        return Optional.ofNullable(this.cause);
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelayMillis;
    }

    public boolean canAttemptReconnect() {
        return this.canReconnect;
    }

    public boolean willAttemptReconnect() {
        return this.canReconnect && this.attemptReconnect;
    }

    public void setAttemptReconnect(boolean reconnecting) {
        this.attemptReconnect = reconnecting;
    }

    public void setReconnectionDelay(int millis) {
        Sanity.truthiness(millis > -1, "Delay cannot be negative");
        this.reconnectionDelayMillis = millis;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("canAttemptReconnect", this.canReconnect).add("willAttemptReconnect", this.attemptReconnect).add("reconnectionDelay", this.reconnectionDelayMillis).add("cause", this.cause);
    }
}

