/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.feature;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.element.CapabilityState;
import org.kitteh.irc.client.library.util.Resettable;
import org.kitteh.irc.client.library.util.RiskyBusiness;
import org.kitteh.irc.client.library.util.Sanity;

public interface CapabilityManager {
    public @NonNull List<CapabilityState> getCapabilities();

    default public @NonNull Optional<CapabilityState> getCapability(@NonNull String name) {
        Sanity.nullCheck(name, "Name");
        return this.getCapabilities().stream().filter(capabilityState -> capabilityState.getName().equals(name)).findFirst();
    }

    public @NonNull List<CapabilityState> getSupportedCapabilities();

    default public @NonNull Optional<CapabilityState> getSupportedCapability(@NonNull String name) {
        Sanity.nullCheck(name, "Name");
        return this.getSupportedCapabilities().stream().filter(capabilityState -> capabilityState.getName().equals(name)).findFirst();
    }

    public static interface WithManagement
    extends CapabilityManager,
    Resettable {
        public boolean isNegotiating();

        public void endNegotiation();

        public void updateCapabilities(@NonNull List<CapabilityState> var1);

        public void setCapabilities(@NonNull List<CapabilityState> var1);

        public void setSupportedCapabilities(@NonNull List<CapabilityState> var1);
    }

    public static final class Defaults {
        public static final String ACCOUNT_NOTIFY = "account-notify";
        public static final String ACCOUNT_TAG = "account-tag";
        public static final String AWAY_NOTIFY = "away-notify";
        public static final String BATCH = "batch";
        public static final transient String CAP_NOTIFY = "cap-notify";
        public static final transient String ECHO_MESSAGE = "echo-message";
        public static final String EXTENDED_JOIN = "extended-join";
        public static final String EXTENDED_MONITOR = "extended-monitor";
        public static final transient String INVITE_NOTIFY = "invite-notify";
        public static final String LABELED_RESPONSE = "labeled-response";
        public static final String MESSAGE_TAGS = "message-tags";
        public static final String MULTI_PREFIX = "multi-prefix";
        public static final String SERVER_TIME = "server-time";
        public static final String SETNAME = "setname";
        public static final String CHGHOST = "chghost";
        public static final transient String SASL = "sasl";
        public static final String USERHOST_IN_NAMES = "userhost-in-names";
        private static final List<String> DEFAULTS;
        private static final Supplier<List<String>> SUPPLIER;

        private Defaults() {
        }

        public static List<String> getDefaults() {
            return DEFAULTS;
        }

        private static String getStringForCapabilityField(@NonNull Field field) {
            return RiskyBusiness.assertSafe(f -> (String)f.get(null), field);
        }

        static {
            SUPPLIER = ArrayList::new;
            DEFAULTS = Collections.unmodifiableList(Arrays.stream(Defaults.class.getDeclaredFields()).filter(field -> Modifier.isPublic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers())).map(Defaults::getStringForCapabilityField).collect(Collectors.toCollection(SUPPLIER)));
        }
    }
}

