/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.feature;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.util.Sanity;

public enum CaseMapping {
    ASCII('Z'),
    RFC1459('^'),
    STRICT_RFC1459(']');

    private static final Map<String, CaseMapping> nameMap;
    private final char upperbound;

    public static @NonNull Optional<CaseMapping> getByName(@Nullable String name) {
        return name == null ? Optional.empty() : Optional.ofNullable(nameMap.get(name.toUpperCase()));
    }

    private CaseMapping(char upperbound) {
        this.upperbound = upperbound;
    }

    public boolean areEqualIgnoringCase(@NonNull String one, @NonNull String two) {
        return this.toLowerCase(one).equals(this.toLowerCase(two));
    }

    public @NonNull String toLowerCase(@NonNull String input) {
        Sanity.nullCheck(input, "Input");
        char[] arr = input.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char c = arr[i];
            if (c < 'A' || c > this.upperbound) continue;
            int n = i;
            arr[n] = (char)(arr[n] + 32);
        }
        return new String(arr);
    }

    static {
        nameMap = new HashMap<String, CaseMapping>();
        for (CaseMapping caseMapping : CaseMapping.values()) {
            nameMap.put(caseMapping.name().replace('_', '-'), caseMapping);
        }
    }
}

