/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.feature.filter;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import net.engio.mbassy.listener.Filter;
import net.engio.mbassy.listener.IMessageFilter;
import net.engio.mbassy.subscription.SubscriptionContext;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.element.Actor;
import org.kitteh.irc.client.library.element.User;
import org.kitteh.irc.client.library.event.helper.ActorEvent;
import org.kitteh.irc.client.library.feature.filter.FilterProcessor;

@Filter(value=Processor.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface EchoMessage {

    public static class Processor
    implements FilterProcessor<ActorEvent<? extends Actor>, EchoMessage>,
    IMessageFilter<ActorEvent<? extends Actor>> {
        public boolean accepts(@NonNull ActorEvent<? extends Actor> event, @NonNull EchoMessage[] annotations) {
            Optional<User> client = event.getClient().getUser();
            return client.isPresent() && client.get().equals(event.getActor());
        }

        public boolean accepts(ActorEvent<? extends Actor> event, SubscriptionContext context) {
            return this.accepts(event, (EchoMessage[])context.getHandler().getMethod().getAnnotationsByType(EchoMessage.class));
        }
    }
}

