/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CtcpUtil {
    private static final char CTCP_DELIMITER = '\u0001';
    private static final char CTCP_MQUOTE = '\u0016';
    private static final Pattern CTCP_ESCAPABLE_CHAR = Pattern.compile("[\n\r\u0000\u0001\u0016\\\\]");
    private static final Pattern CTCP_ESCAPED_CHAR = Pattern.compile("([\u0016\\\\])(.)");

    private CtcpUtil() {
    }

    public static @NonNull String fromCtcp(@NonNull String message) {
        int secondDelimiter = message.indexOf(1, 1);
        String ctcpContent = message.substring(1, secondDelimiter == -1 ? message.length() : secondDelimiter);
        StringBuilder builder = new StringBuilder(ctcpContent.length());
        int currentIndex = 0;
        Matcher matcher = CTCP_ESCAPED_CHAR.matcher(ctcpContent);
        while (matcher.find()) {
            if (matcher.start() > currentIndex) {
                builder.append(ctcpContent, currentIndex, matcher.start());
            }
            block4 : switch (matcher.group(1)) {
                case "\u0016": {
                    switch (matcher.group(2)) {
                        case "n": {
                            builder.append('\n');
                            break block4;
                        }
                        case "r": {
                            builder.append('\r');
                            break block4;
                        }
                        case "0": {
                            builder.append('\u0000');
                            break block4;
                        }
                    }
                    builder.append(matcher.group(2));
                    break;
                }
                case "\\": {
                    if ("a".equals(matcher.group(2))) {
                        builder.append('\u0001');
                        break;
                    }
                    builder.append(matcher.group(2));
                }
            }
            currentIndex = matcher.end();
        }
        if (currentIndex < ctcpContent.length()) {
            builder.append(ctcpContent.substring(currentIndex));
        }
        return builder.toString();
    }

    public static boolean isCtcp(@NonNull String message) {
        return !message.isEmpty() && message.charAt(0) == '\u0001';
    }

    public static @NonNull String toCtcp(@NonNull String message) {
        StringBuilder builder = new StringBuilder(message.length());
        builder.append('\u0001');
        int currentIndex = 0;
        Matcher matcher = CTCP_ESCAPABLE_CHAR.matcher(message);
        while (matcher.find()) {
            if (matcher.start() > currentIndex) {
                builder.append(message, currentIndex, matcher.start());
            }
            switch (matcher.group()) {
                case "\n": {
                    builder.append('\u0016').append('n');
                    break;
                }
                case "\r": {
                    builder.append('\u0016').append('r');
                    break;
                }
                case "\u0000": {
                    builder.append('\u0016').append('0');
                    break;
                }
                case "\u0016": {
                    builder.append('\u0016').append('\u0016');
                    break;
                }
                case "\u0001": {
                    builder.append("\\a");
                    break;
                }
                case "\\": {
                    builder.append("\\\\");
                    break;
                }
            }
            currentIndex = matcher.end();
        }
        if (currentIndex < message.length()) {
            builder.append(message.substring(currentIndex));
        }
        builder.append('\u0001');
        return builder.toString();
    }
}

