/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.util;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.util.Sanity;

@FunctionalInterface
public interface Cutter {
    public @NonNull List<String> split(@NonNull String var1, @NonNegative int var2);

    public static class DefaultWordCutter
    implements Cutter {
        @Override
        public @NonNull List<String> split(@NonNull String message, @NonNegative int size) {
            Sanity.nullCheck(message, "Message");
            Sanity.truthiness(size > 0, "Size must be positive");
            ArrayList<String> list = new ArrayList<String>();
            if (this.encodedLength(message) <= size) {
                list.add(message);
                return list;
            }
            StringBuilder builder = new StringBuilder(size);
            for (String word : message.split(" ")) {
                int builderLen = this.encodedLength(builder);
                if (builderLen + this.encodedLength(word) + (builderLen == 0 ? 0 : 1) > size) {
                    if (word.length() > size && builderLen + 1 < size) {
                        if (builderLen > 0) {
                            builder.append(' ');
                            ++builderLen;
                        }
                        int cut = size - builderLen;
                        builder.append(word, 0, cut);
                        word = word.substring(cut);
                    }
                    list.add(builder.toString().trim());
                    builder.setLength(0);
                    while (this.encodedLength(word) > size) {
                        list.add(word.substring(0, size));
                        word = word.substring(size);
                    }
                }
                if (this.encodedLength(builder) > 0) {
                    builder.append(' ');
                }
                builder.append(word);
            }
            if (this.encodedLength(builder) > 0) {
                list.add(builder.toString().trim());
            }
            return list;
        }

        private int encodedLength(CharSequence sequence) {
            int i;
            int utf16Length;
            int utf8Length = utf16Length = sequence.length();
            for (i = 0; i < utf16Length && sequence.charAt(i) < '\u0080'; ++i) {
            }
            while (i < utf16Length) {
                char c = sequence.charAt(i);
                if (c < '\u0800') {
                    utf8Length += 127 - c >>> 31;
                } else {
                    utf8Length += this.encodedLengthGeneral(sequence, i);
                    break;
                }
                ++i;
            }
            return utf8Length;
        }

        private int encodedLengthGeneral(CharSequence sequence, int start) {
            int utf16Length = sequence.length();
            int utf8Length = 0;
            for (int i = start; i < utf16Length; ++i) {
                char c = sequence.charAt(i);
                if (c < '\u0800') {
                    utf8Length += 127 - c >>> 31;
                    continue;
                }
                utf8Length += 2;
                if (!Character.isSurrogate(c)) continue;
                ++i;
            }
            return utf8Length;
        }
    }
}

