/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.util;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.value.qual.IntRange;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class HostWithPort {
    public static final int PORT_MIN = 0;
    public static final int PORT_MAX = 65535;
    private final String host;
    private final int port;

    public static @NonNull HostWithPort of(@NonNull String host, @IntRange(from=0L, to=65535L) int port) {
        Sanity.nullCheck(host, "Host");
        Sanity.truthiness(port >= 0 && port <= 65535, port + " is not acceptable port number");
        return new HostWithPort(host, port);
    }

    private HostWithPort(@NonNull String host, @IntRange(from=0L, to=65535L) int port) {
        this.host = host;
        this.port = port;
    }

    public @NonNull String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public @NonNull HostWithPort withHost(@NonNull String host) {
        return HostWithPort.of(host, this.port);
    }

    public @NonNull HostWithPort withPort(@IntRange(from=0L, to=65535L) int port) {
        return HostWithPort.of(this.host, port);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HostWithPort that = (HostWithPort)other;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return new ToStringer(this).add("host", this.host).add("port", this.port).toString();
    }
}

