/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.util;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.ClientLinked;
import org.kitteh.irc.client.library.util.Format;
import org.kitteh.irc.client.library.util.Sanity;

public final class StringUtil {
    private static final Format[] DEFAULT_RAINBOW = new Format[]{Format.RED, Format.BROWN, Format.OLIVE, Format.YELLOW, Format.DARK_GREEN, Format.GREEN, Format.TEAL, Format.BLUE, Format.MAGENTA, Format.PURPLE};

    private StringUtil() {
    }

    public static @NonNull String combineSplit(@NonNull String[] split, int start, int length, @NonNull String delimiter) {
        Sanity.nullCheck(split, "Cannot combine a null array");
        Sanity.nullCheck(delimiter, "Delimiter");
        Sanity.truthiness(start >= 0, "Negative array indexes are not valid");
        Sanity.truthiness(length > 0, "Cannot combine less than one element of an array");
        StringBuilder builder = new StringBuilder((5 + delimiter.length()) * length);
        for (int x = start; x < split.length && x < start + length; ++x) {
            builder.append(split[x]).append(delimiter);
        }
        builder.setLength(builder.length() - delimiter.length());
        return builder.toString();
    }

    public static @NonNull String combineSplit(@NonNull String[] split, int start) {
        Sanity.nullCheck(split, "Cannot combine a null array");
        return StringUtil.combineSplit(split, start, split.length - start, " ");
    }

    public static @NonNull String makeRainbow(@NonNull String message) {
        return StringUtil.makeRainbow(message, DEFAULT_RAINBOW);
    }

    public static @NonNull String makeRainbow(@NonNull String message, @NonNull Format[] colorOrder) {
        Sanity.safeMessageCheck(message);
        Sanity.nullCheck(colorOrder, "Color order");
        for (Format format : colorOrder) {
            if (format.isColor()) continue;
            throw new IllegalArgumentException("Color order must contain only colors");
        }
        StringBuilder builder = new StringBuilder(message.length() * 3);
        int count = 0;
        for (char c : message.toCharArray()) {
            if (c != ' ' && c != '\t') {
                builder.append(colorOrder[count++ % colorOrder.length].toString());
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static @NonNull String toLowerCase(@NonNull ClientLinked linked, @NonNull String input) {
        Sanity.nullCheck(linked, "ClientLinked");
        return StringUtil.toLowerCase(linked.getClient(), input);
    }

    public static @NonNull String toLowerCase(@NonNull Client client, @NonNull String input) {
        Sanity.nullCheck(client, "Client");
        Sanity.nullCheck(input, "Input");
        return client.getServerInfo().getCaseMapping().toLowerCase(input);
    }

    public static @NonNull String filterPassword(@NonNull String password) {
        Sanity.nullCheck(password, "Password");
        return password.replaceAll(".", "*");
    }
}

