/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.feature.sts.StsPolicy;
import org.kitteh.irc.client.library.feature.sts.StsPropertiesStorageManager;
import org.kitteh.irc.client.library.feature.sts.StsStorageManager;
import org.kitteh.irc.client.library.util.Sanity;

public final class StsUtil {
    public static final String DEFAULT_FILENAME = ".kicl_sts.properties";

    private StsUtil() {
    }

    public static @NonNull StsStorageManager getDefaultStorageManager() {
        return StsUtil.getDefaultStorageManager(Paths.get(System.getProperty("user.home"), DEFAULT_FILENAME));
    }

    public static @NonNull StsStorageManager getDefaultStorageManager(@NonNull Path stsFile) {
        return new StsPropertiesStorageManager(stsFile);
    }

    public static @NonNull StsPolicy getStsPolicyFromString(@NonNull String delimiter, @NonNull String str) {
        Sanity.nullCheck(delimiter, "Need a valid delimiter.");
        Sanity.nullCheck(str, "Need a valid string to parse.");
        String[] components = str.split(delimiter);
        HashMap<String, String> options = new HashMap<String, String>();
        HashSet<String> flags = new HashSet<String>();
        for (String component : components) {
            if (!component.contains("=")) {
                flags.add(component);
                continue;
            }
            String[] innerComponents = component.split("=");
            options.put(innerComponents[0], innerComponents[1]);
        }
        return new StsPolicy(options, flags);
    }
}

