/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.agent.Agent;
import org.kiwiproject.consul.model.agent.Config;
import org.kiwiproject.consul.model.agent.DebugConfig;
import org.kiwiproject.consul.model.agent.Member;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Agent", generator="Immutables")
public final class ImmutableAgent
extends Agent {
    private final Config config;
    private final @org.checkerframework.checker.nullness.qual.Nullable DebugConfig debugConfig;
    private final Member member;
    private final ImmutableMap<String, String> meta;

    private ImmutableAgent(Config config, @org.checkerframework.checker.nullness.qual.Nullable DebugConfig debugConfig, Member member, ImmutableMap<String, String> meta) {
        this.config = config;
        this.debugConfig = debugConfig;
        this.member = member;
        this.meta = meta;
    }

    @Override
    @JsonProperty(value="Config")
    public Config getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="DebugConfig")
    public @org.checkerframework.checker.nullness.qual.Nullable DebugConfig getDebugConfig() {
        return this.debugConfig;
    }

    @Override
    @JsonProperty(value="Member")
    public Member getMember() {
        return this.member;
    }

    @JsonProperty(value="Meta")
    public ImmutableMap<String, String> getMeta() {
        return this.meta;
    }

    public final ImmutableAgent withConfig(Config value) {
        if (this.config == value) {
            return this;
        }
        Config newValue = Objects.requireNonNull(value, "config");
        return new ImmutableAgent(newValue, this.debugConfig, this.member, this.meta);
    }

    public final ImmutableAgent withDebugConfig(@org.checkerframework.checker.nullness.qual.Nullable DebugConfig value) {
        if (this.debugConfig == value) {
            return this;
        }
        return new ImmutableAgent(this.config, value, this.member, this.meta);
    }

    public final ImmutableAgent withMember(Member value) {
        if (this.member == value) {
            return this;
        }
        Member newValue = Objects.requireNonNull(value, "member");
        return new ImmutableAgent(this.config, this.debugConfig, newValue, this.meta);
    }

    public final ImmutableAgent withMeta(Map<String, ? extends String> entries) {
        if (this.meta == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableAgent(this.config, this.debugConfig, this.member, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAgent && this.equalTo(0, (ImmutableAgent)another);
    }

    private boolean equalTo(int synthetic, ImmutableAgent another) {
        return this.config.equals(another.config) && Objects.equals(this.debugConfig, another.debugConfig) && this.member.equals(another.member) && this.meta.equals(another.meta);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + Objects.hashCode(this.debugConfig);
        h += (h << 5) + this.member.hashCode();
        h += (h << 5) + this.meta.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Agent").omitNullValues().add("config", (Object)this.config).add("debugConfig", (Object)this.debugConfig).add("member", (Object)this.member).add("meta", this.meta).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAgent fromJson(Json json) {
        Builder builder = ImmutableAgent.builder();
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.debugConfig != null) {
            builder.debugConfig(json.debugConfig);
        }
        if (json.member != null) {
            builder.member(json.member);
        }
        if (json.meta != null) {
            builder.putAllMeta(json.meta);
        }
        return builder.build();
    }

    public static ImmutableAgent copyOf(Agent instance) {
        if (instance instanceof ImmutableAgent) {
            return (ImmutableAgent)instance;
        }
        return ImmutableAgent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Agent", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CONFIG = 1L;
        private static final long INIT_BIT_MEMBER = 2L;
        private long initBits = 3L;
        @Nullable
        private Config config;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable DebugConfig debugConfig;
        @Nullable
        private Member member;
        private ImmutableMap.Builder<String, String> meta = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Agent instance) {
            Objects.requireNonNull(instance, "instance");
            this.config(instance.getConfig());
            @org.checkerframework.checker.nullness.qual.Nullable DebugConfig debugConfigValue = instance.getDebugConfig();
            if (debugConfigValue != null) {
                this.debugConfig(debugConfigValue);
            }
            this.member(instance.getMember());
            this.putAllMeta(instance.getMeta());
            return this;
        }

        @JsonProperty(value="Config")
        @CanIgnoreReturnValue
        public final Builder config(Config config) {
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="DebugConfig")
        @CanIgnoreReturnValue
        public final Builder debugConfig(@org.checkerframework.checker.nullness.qual.Nullable DebugConfig debugConfig) {
            this.debugConfig = debugConfig;
            return this;
        }

        @JsonProperty(value="Member")
        @CanIgnoreReturnValue
        public final Builder member(Member member) {
            this.member = Objects.requireNonNull(member, "member");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMeta(String key, String value) {
            this.meta.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMeta(Map.Entry<String, ? extends String> entry) {
            this.meta.put(entry);
            return this;
        }

        @JsonProperty(value="Meta")
        @CanIgnoreReturnValue
        public final Builder meta(Map<String, ? extends String> entries) {
            this.meta = ImmutableMap.builder();
            return this.putAllMeta(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMeta(Map<String, ? extends String> entries) {
            this.meta.putAll(entries);
            return this;
        }

        public ImmutableAgent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAgent(this.config, this.debugConfig, this.member, (ImmutableMap<String, String>)this.meta.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("member");
            }
            return "Cannot build Agent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Agent", generator="Immutables")
    static final class Json
    extends Agent {
        @Nullable
        Config config;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable DebugConfig debugConfig;
        @Nullable
        Member member;
        @Nullable
        Map<String, String> meta = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="Config")
        public void setConfig(Config config) {
            this.config = config;
        }

        @JsonProperty(value="DebugConfig")
        public void setDebugConfig(@org.checkerframework.checker.nullness.qual.Nullable DebugConfig debugConfig) {
            this.debugConfig = debugConfig;
        }

        @JsonProperty(value="Member")
        public void setMember(Member member) {
            this.member = member;
        }

        @JsonProperty(value="Meta")
        public void setMeta(Map<String, String> meta) {
            this.meta = meta;
        }

        @Override
        public Config getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable DebugConfig getDebugConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Member getMember() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getMeta() {
            throw new UnsupportedOperationException();
        }
    }
}

