package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Role.RoleNodeIdentity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRoleNodeIdentity.builder()}.
 */
@Generated(from = "Role.RoleNodeIdentity", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableRoleNodeIdentity extends Role.RoleNodeIdentity {
  private final String name;
  private final String datacenter;

  private ImmutableRoleNodeIdentity(String name, String datacenter) {
    this.name = name;
    this.datacenter = datacenter;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("NodeName")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @JsonProperty("Datacenter")
  @Override
  public String datacenter() {
    return datacenter;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Role.RoleNodeIdentity#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRoleNodeIdentity withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableRoleNodeIdentity(newValue, this.datacenter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Role.RoleNodeIdentity#datacenter() datacenter} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datacenter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRoleNodeIdentity withDatacenter(String value) {
    String newValue = Objects.requireNonNull(value, "datacenter");
    if (this.datacenter.equals(newValue)) return this;
    return new ImmutableRoleNodeIdentity(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRoleNodeIdentity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRoleNodeIdentity
        && equalTo(0, (ImmutableRoleNodeIdentity) another);
  }

  private boolean equalTo(int synthetic, ImmutableRoleNodeIdentity another) {
    return name.equals(another.name)
        && datacenter.equals(another.datacenter);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code datacenter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + datacenter.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RoleNodeIdentity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RoleNodeIdentity")
        .omitNullValues()
        .add("name", name)
        .add("datacenter", datacenter)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Role.RoleNodeIdentity", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Role.RoleNodeIdentity {
    @Nullable String name;
    @Nullable String datacenter;
    @JsonProperty("NodeName")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("Datacenter")
    public void setDatacenter(String datacenter) {
      this.datacenter = datacenter;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public String datacenter() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRoleNodeIdentity fromJson(Json json) {
    ImmutableRoleNodeIdentity.Builder builder = ImmutableRoleNodeIdentity.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.datacenter != null) {
      builder.datacenter(json.datacenter);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Role.RoleNodeIdentity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RoleNodeIdentity instance
   */
  public static ImmutableRoleNodeIdentity copyOf(Role.RoleNodeIdentity instance) {
    if (instance instanceof ImmutableRoleNodeIdentity) {
      return (ImmutableRoleNodeIdentity) instance;
    }
    return ImmutableRoleNodeIdentity.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRoleNodeIdentity ImmutableRoleNodeIdentity}.
   * <pre>
   * ImmutableRoleNodeIdentity.builder()
   *    .name(String) // required {@link Role.RoleNodeIdentity#name() name}
   *    .datacenter(String) // required {@link Role.RoleNodeIdentity#datacenter() datacenter}
   *    .build();
   * </pre>
   * @return A new ImmutableRoleNodeIdentity builder
   */
  public static ImmutableRoleNodeIdentity.Builder builder() {
    return new ImmutableRoleNodeIdentity.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRoleNodeIdentity ImmutableRoleNodeIdentity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Role.RoleNodeIdentity", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_DATACENTER = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String datacenter;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RoleNodeIdentity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Role.RoleNodeIdentity instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      datacenter(instance.datacenter());
      return this;
    }

    /**
     * Initializes the value for the {@link Role.RoleNodeIdentity#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("NodeName")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Role.RoleNodeIdentity#datacenter() datacenter} attribute.
     * @param datacenter The value for datacenter 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Datacenter")
    public final Builder datacenter(String datacenter) {
      this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
      initBits &= ~INIT_BIT_DATACENTER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRoleNodeIdentity ImmutableRoleNodeIdentity}.
     * @return An immutable instance of RoleNodeIdentity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRoleNodeIdentity build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRoleNodeIdentity(name, datacenter);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DATACENTER) != 0) attributes.add("datacenter");
      return "Cannot build RoleNodeIdentity, some of required attributes are not set " + attributes;
    }
  }
}
