package org.kiwiproject.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TaggedAddresses}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTaggedAddresses.builder()}.
 */
@Generated(from = "TaggedAddresses", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableTaggedAddresses extends TaggedAddresses {
  private final String wan;
  private final @Nullable String lan;

  private ImmutableTaggedAddresses(String wan, @Nullable String lan) {
    this.wan = wan;
    this.lan = lan;
  }

  /**
   * @return The value of the {@code wan} attribute
   */
  @JsonProperty("wan")
  @Override
  public String getWan() {
    return wan;
  }

  /**
   * @return The value of the {@code lan} attribute
   */
  @JsonProperty("lan")
  @Override
  public Optional<String> getLan() {
    return Optional.ofNullable(lan);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TaggedAddresses#getWan() wan} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for wan
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTaggedAddresses withWan(String value) {
    String newValue = Objects.requireNonNull(value, "wan");
    if (this.wan.equals(newValue)) return this;
    return new ImmutableTaggedAddresses(newValue, this.lan);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TaggedAddresses#getLan() lan} attribute.
   * @param value The value for lan
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTaggedAddresses withLan(String value) {
    String newValue = Objects.requireNonNull(value, "lan");
    if (Objects.equals(this.lan, newValue)) return this;
    return new ImmutableTaggedAddresses(this.wan, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TaggedAddresses#getLan() lan} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for lan
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTaggedAddresses withLan(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.lan, value)) return this;
    return new ImmutableTaggedAddresses(this.wan, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTaggedAddresses} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTaggedAddresses
        && equalTo(0, (ImmutableTaggedAddresses) another);
  }

  private boolean equalTo(int synthetic, ImmutableTaggedAddresses another) {
    return wan.equals(another.wan)
        && Objects.equals(lan, another.lan);
  }

  /**
   * Computes a hash code from attributes: {@code wan}, {@code lan}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + wan.hashCode();
    h += (h << 5) + Objects.hashCode(lan);
    return h;
  }

  /**
   * Prints the immutable value {@code TaggedAddresses} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TaggedAddresses")
        .omitNullValues()
        .add("wan", wan)
        .add("lan", lan)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TaggedAddresses", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends TaggedAddresses {
    @Nullable String wan;
    @Nullable Optional<String> lan = Optional.empty();
    @JsonProperty("wan")
    public void setWan(String wan) {
      this.wan = wan;
    }
    @JsonProperty("lan")
    public void setLan(Optional<String> lan) {
      this.lan = lan;
    }
    @Override
    public String getWan() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getLan() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTaggedAddresses fromJson(Json json) {
    ImmutableTaggedAddresses.Builder builder = ImmutableTaggedAddresses.builder();
    if (json.wan != null) {
      builder.wan(json.wan);
    }
    if (json.lan != null) {
      builder.lan(json.lan);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TaggedAddresses} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TaggedAddresses instance
   */
  public static ImmutableTaggedAddresses copyOf(TaggedAddresses instance) {
    if (instance instanceof ImmutableTaggedAddresses) {
      return (ImmutableTaggedAddresses) instance;
    }
    return ImmutableTaggedAddresses.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTaggedAddresses ImmutableTaggedAddresses}.
   * <pre>
   * ImmutableTaggedAddresses.builder()
   *    .wan(String) // required {@link TaggedAddresses#getWan() wan}
   *    .lan(String) // optional {@link TaggedAddresses#getLan() lan}
   *    .build();
   * </pre>
   * @return A new ImmutableTaggedAddresses builder
   */
  public static ImmutableTaggedAddresses.Builder builder() {
    return new ImmutableTaggedAddresses.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTaggedAddresses ImmutableTaggedAddresses}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TaggedAddresses", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_WAN = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String wan;
    private @Nullable String lan;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TaggedAddresses} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TaggedAddresses instance) {
      Objects.requireNonNull(instance, "instance");
      wan(instance.getWan());
      Optional<String> lanOptional = instance.getLan();
      if (lanOptional.isPresent()) {
        lan(lanOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TaggedAddresses#getWan() wan} attribute.
     * @param wan The value for wan 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("wan")
    public final Builder wan(String wan) {
      this.wan = Objects.requireNonNull(wan, "wan");
      initBits &= ~INIT_BIT_WAN;
      return this;
    }

    /**
     * Initializes the optional value {@link TaggedAddresses#getLan() lan} to lan.
     * @param lan The value for lan
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder lan(String lan) {
      this.lan = Objects.requireNonNull(lan, "lan");
      return this;
    }

    /**
     * Initializes the optional value {@link TaggedAddresses#getLan() lan} to lan.
     * @param lan The value for lan
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("lan")
    public final Builder lan(Optional<String> lan) {
      this.lan = lan.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTaggedAddresses ImmutableTaggedAddresses}.
     * @return An immutable instance of TaggedAddresses
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTaggedAddresses build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTaggedAddresses(wan, lan);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WAN) != 0) attributes.add("wan");
      return "Cannot build TaggedAddresses, some of required attributes are not set " + attributes;
    }
  }
}
