package org.kiwiproject.consul.model.query;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DnsQuery}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDnsQuery.builder()}.
 */
@Generated(from = "DnsQuery", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableDnsQuery extends DnsQuery {
  private final String ttl;

  private ImmutableDnsQuery(String ttl) {
    this.ttl = ttl;
  }

  /**
   * @return The value of the {@code ttl} attribute
   */
  @JsonProperty("TTL")
  @Override
  public String getTtl() {
    return ttl;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DnsQuery#getTtl() ttl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ttl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDnsQuery withTtl(String value) {
    String newValue = Objects.requireNonNull(value, "ttl");
    if (this.ttl.equals(newValue)) return this;
    return new ImmutableDnsQuery(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDnsQuery} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDnsQuery
        && equalTo(0, (ImmutableDnsQuery) another);
  }

  private boolean equalTo(int synthetic, ImmutableDnsQuery another) {
    return ttl.equals(another.ttl);
  }

  /**
   * Computes a hash code from attributes: {@code ttl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + ttl.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DnsQuery} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DnsQuery")
        .omitNullValues()
        .add("ttl", ttl)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DnsQuery", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends DnsQuery {
    @Nullable String ttl;
    @JsonProperty("TTL")
    public void setTtl(String ttl) {
      this.ttl = ttl;
    }
    @Override
    public String getTtl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDnsQuery fromJson(Json json) {
    ImmutableDnsQuery.Builder builder = ImmutableDnsQuery.builder();
    if (json.ttl != null) {
      builder.ttl(json.ttl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DnsQuery} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DnsQuery instance
   */
  public static ImmutableDnsQuery copyOf(DnsQuery instance) {
    if (instance instanceof ImmutableDnsQuery) {
      return (ImmutableDnsQuery) instance;
    }
    return ImmutableDnsQuery.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDnsQuery ImmutableDnsQuery}.
   * <pre>
   * ImmutableDnsQuery.builder()
   *    .ttl(String) // required {@link DnsQuery#getTtl() ttl}
   *    .build();
   * </pre>
   * @return A new ImmutableDnsQuery builder
   */
  public static ImmutableDnsQuery.Builder builder() {
    return new ImmutableDnsQuery.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDnsQuery ImmutableDnsQuery}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DnsQuery", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TTL = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String ttl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DnsQuery} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DnsQuery instance) {
      Objects.requireNonNull(instance, "instance");
      ttl(instance.getTtl());
      return this;
    }

    /**
     * Initializes the value for the {@link DnsQuery#getTtl() ttl} attribute.
     * @param ttl The value for ttl 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("TTL")
    public final Builder ttl(String ttl) {
      this.ttl = Objects.requireNonNull(ttl, "ttl");
      initBits &= ~INIT_BIT_TTL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDnsQuery ImmutableDnsQuery}.
     * @return An immutable instance of DnsQuery
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDnsQuery build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDnsQuery(ttl);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TTL) != 0) attributes.add("ttl");
      return "Cannot build DnsQuery, some of required attributes are not set " + attributes;
    }
  }
}
