/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.kiwiproject.consul.model.agent.ImmutableCheck;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(as=ImmutableCheck.class)
@JsonDeserialize(as=ImmutableCheck.class)
@Value.Immutable
@Value.Style(jakarta=true)
public abstract class Check {
    @JsonProperty(value="ID")
    public abstract String getId();

    @JsonProperty(value="Name")
    public abstract String getName();

    @JsonProperty(value="Notes")
    public abstract Optional<String> getNotes();

    @JsonProperty(value="Output")
    public abstract Optional<String> getOutput();

    @JsonProperty(value="Args")
    public abstract Optional<List<String>> getArgs();

    @JsonProperty(value="Interval")
    public abstract Optional<String> getInterval();

    @JsonProperty(value="TTL")
    public abstract Optional<String> getTtl();

    @JsonProperty(value="HTTP")
    public abstract Optional<String> getHttp();

    @JsonProperty(value="TCP")
    public abstract Optional<String> getTcp();

    @JsonProperty(value="GRPC")
    public abstract Optional<String> getGrpc();

    @JsonProperty(value="GRPCUseTLS")
    public abstract Optional<Boolean> getGrpcUseTls();

    @JsonProperty(value="ServiceID")
    public abstract Optional<String> getServiceId();

    @JsonProperty(value="ServiceTags")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public abstract List<String> getServiceTags();

    @JsonProperty(value="DeregisterCriticalServiceAfter")
    public abstract Optional<String> getDeregisterCriticalServiceAfter();

    @Value.Check
    protected void validate() {
        Preconditions.checkState((this.getHttp().isPresent() || this.getTtl().isPresent() || this.getArgs().isPresent() || this.getTcp().isPresent() || this.getGrpc().isPresent() ? 1 : 0) != 0, (Object)"Check must specify either http, tcp, ttl, grpc or args");
        if (this.getHttp().isPresent() || this.getArgs().isPresent() || this.getTcp().isPresent() || this.getGrpc().isPresent()) {
            Preconditions.checkState((boolean)this.getInterval().isPresent(), (Object)"Interval must be set if check type is http, tcp, grpc or args");
        }
    }
}

