/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.option.ConsistencyMode;
import org.kiwiproject.consul.option.ParamAdder;
import org.kiwiproject.consul.option.QueryOptions;

@Generated(from="QueryOptions", generator="Immutables")
public final class ImmutableQueryOptions
extends QueryOptions {
    private final ImmutableList<String> toQueryParameters;
    @Nullable
    private final String wait;
    @Nullable
    private final String token;
    @Nullable
    private final String hash;
    @Nullable
    private final BigInteger index;
    @Nullable
    private final String near;
    @Nullable
    private final String datacenter;
    @Nullable
    private final String filter;
    @Nullable
    private final String namespace;
    @Nullable
    private final Boolean wan;
    @Nullable
    private final String segment;
    @Nullable
    private final String note;
    @Nullable
    private final Boolean enable;
    @Nullable
    private final String reason;
    private final ImmutableList<String> nodeMeta;
    private final ImmutableList<String> tag;
    private final ConsistencyMode consistencyMode;
    private final transient boolean isBlocking;
    private final transient boolean hasToken;
    private final transient List<String> nodeMetaQuery;
    private final transient List<String> tagsQuery;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableQueryOptions(Builder builder) {
        this.toQueryParameters = builder.toQueryParameters.build();
        this.wait = builder.wait;
        this.token = builder.token;
        this.hash = builder.hash;
        this.index = builder.index;
        this.near = builder.near;
        this.datacenter = builder.datacenter;
        this.filter = builder.filter;
        this.namespace = builder.namespace;
        this.wan = builder.wan;
        this.segment = builder.segment;
        this.note = builder.note;
        this.enable = builder.enable;
        this.reason = builder.reason;
        this.nodeMeta = builder.nodeMeta.build();
        this.tag = builder.tag.build();
        if (builder.consistencyMode != null) {
            this.initShim.consistencyMode(builder.consistencyMode);
        }
        this.consistencyMode = this.initShim.getConsistencyMode();
        this.isBlocking = this.initShim.isBlocking();
        this.hasToken = this.initShim.hasToken();
        this.nodeMetaQuery = this.initShim.getNodeMetaQuery();
        this.tagsQuery = this.initShim.getTagsQuery();
        this.initShim = null;
    }

    private ImmutableQueryOptions(ImmutableList<String> toQueryParameters, @Nullable String wait, @Nullable String token, @Nullable String hash, @Nullable BigInteger index, @Nullable String near, @Nullable String datacenter, @Nullable String filter, @Nullable String namespace, @Nullable Boolean wan, @Nullable String segment, @Nullable String note, @Nullable Boolean enable, @Nullable String reason, ImmutableList<String> nodeMeta, ImmutableList<String> tag, ConsistencyMode consistencyMode) {
        this.toQueryParameters = toQueryParameters;
        this.wait = wait;
        this.token = token;
        this.hash = hash;
        this.index = index;
        this.near = near;
        this.datacenter = datacenter;
        this.filter = filter;
        this.namespace = namespace;
        this.wan = wan;
        this.segment = segment;
        this.note = note;
        this.enable = enable;
        this.reason = reason;
        this.nodeMeta = nodeMeta;
        this.tag = tag;
        this.initShim.consistencyMode(consistencyMode);
        this.consistencyMode = this.initShim.getConsistencyMode();
        this.isBlocking = this.initShim.isBlocking();
        this.hasToken = this.initShim.hasToken();
        this.nodeMetaQuery = this.initShim.getNodeMetaQuery();
        this.tagsQuery = this.initShim.getTagsQuery();
        this.initShim = null;
    }

    public ImmutableList<String> toQueryParameters() {
        return this.toQueryParameters;
    }

    @Override
    public Optional<String> getWait() {
        return Optional.ofNullable(this.wait);
    }

    @Override
    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    @Override
    public Optional<String> getHash() {
        return Optional.ofNullable(this.hash);
    }

    @Override
    public Optional<BigInteger> getIndex() {
        return Optional.ofNullable(this.index);
    }

    @Override
    public Optional<String> getNear() {
        return Optional.ofNullable(this.near);
    }

    @Override
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    public Optional<String> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    @Override
    public Optional<String> getNamespace() {
        return Optional.ofNullable(this.namespace);
    }

    @Override
    public Optional<Boolean> getWan() {
        return Optional.ofNullable(this.wan);
    }

    @Override
    public Optional<String> getSegment() {
        return Optional.ofNullable(this.segment);
    }

    @Override
    public Optional<String> getNote() {
        return Optional.ofNullable(this.note);
    }

    @Override
    public Optional<Boolean> getEnable() {
        return Optional.ofNullable(this.enable);
    }

    @Override
    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason);
    }

    public ImmutableList<String> getNodeMeta() {
        return this.nodeMeta;
    }

    public ImmutableList<String> getTag() {
        return this.tag;
    }

    @Override
    public ConsistencyMode getConsistencyMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getConsistencyMode() : this.consistencyMode;
    }

    @Override
    public boolean isBlocking() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isBlocking() : this.isBlocking;
    }

    @Override
    public boolean hasToken() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasToken() : this.hasToken;
    }

    @Override
    public List<String> getNodeMetaQuery() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getNodeMetaQuery() : this.nodeMetaQuery;
    }

    @Override
    public List<String> getTagsQuery() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTagsQuery() : this.tagsQuery;
    }

    public final ImmutableQueryOptions withToQueryParameters(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions((ImmutableList<String>)newValue, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withToQueryParameters(Iterable<String> elements) {
        if (this.toQueryParameters == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions((ImmutableList<String>)newValue, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withWait(String value) {
        String newValue = Objects.requireNonNull(value, "wait");
        if (Objects.equals(this.wait, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, newValue, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withWait(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.wait, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, value, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (Objects.equals(this.token, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, newValue, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withToken(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, value, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (Objects.equals(this.hash, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, newValue, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withHash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, value, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "index");
        if (Objects.equals(this.index, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, newValue, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withIndex(Optional<? extends BigInteger> optional) {
        BigInteger value = optional.orElse(null);
        if (Objects.equals(this.index, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, value, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNear(String value) {
        String newValue = Objects.requireNonNull(value, "near");
        if (Objects.equals(this.near, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, newValue, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNear(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.near, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, value, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, newValue, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, value, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withFilter(String value) {
        String newValue = Objects.requireNonNull(value, "filter");
        if (Objects.equals(this.filter, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, newValue, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withFilter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.filter, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, value, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNamespace(String value) {
        String newValue = Objects.requireNonNull(value, "namespace");
        if (Objects.equals(this.namespace, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, newValue, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNamespace(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.namespace, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, value, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withWan(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.wan, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, newValue, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withWan(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.wan, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, value, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withSegment(String value) {
        String newValue = Objects.requireNonNull(value, "segment");
        if (Objects.equals(this.segment, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, newValue, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withSegment(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.segment, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, value, this.note, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNote(String value) {
        String newValue = Objects.requireNonNull(value, "note");
        if (Objects.equals(this.note, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, newValue, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNote(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.note, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, value, this.enable, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withEnable(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.enable, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, newValue, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withEnable(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.enable, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, value, this.reason, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withReason(String value) {
        String newValue = Objects.requireNonNull(value, "reason");
        if (Objects.equals(this.reason, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, newValue, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withReason(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, value, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNodeMeta(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, (ImmutableList<String>)newValue, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNodeMeta(Iterable<String> elements) {
        if (this.nodeMeta == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, (ImmutableList<String>)newValue, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withTag(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, (ImmutableList<String>)newValue, this.consistencyMode));
    }

    public final ImmutableQueryOptions withTag(Iterable<String> elements) {
        if (this.tag == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, (ImmutableList<String>)newValue, this.consistencyMode));
    }

    public final ImmutableQueryOptions withConsistencyMode(ConsistencyMode value) {
        if (this.consistencyMode == value) {
            return this;
        }
        ConsistencyMode newValue = Objects.requireNonNull(value, "consistencyMode");
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.toQueryParameters, this.wait, this.token, this.hash, this.index, this.near, this.datacenter, this.filter, this.namespace, this.wan, this.segment, this.note, this.enable, this.reason, this.nodeMeta, this.tag, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryOptions && this.equalTo(0, (ImmutableQueryOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableQueryOptions another) {
        return this.toQueryParameters.equals(another.toQueryParameters) && Objects.equals(this.wait, another.wait) && Objects.equals(this.token, another.token) && Objects.equals(this.hash, another.hash) && Objects.equals(this.index, another.index) && Objects.equals(this.near, another.near) && Objects.equals(this.datacenter, another.datacenter) && Objects.equals(this.filter, another.filter) && Objects.equals(this.namespace, another.namespace) && Objects.equals(this.wan, another.wan) && Objects.equals(this.segment, another.segment) && Objects.equals(this.note, another.note) && Objects.equals(this.enable, another.enable) && Objects.equals(this.reason, another.reason) && this.nodeMeta.equals(another.nodeMeta) && this.tag.equals(another.tag) && this.consistencyMode.equals(another.consistencyMode) && this.isBlocking == another.isBlocking && this.hasToken == another.hasToken && this.nodeMetaQuery.equals(another.nodeMetaQuery) && this.tagsQuery.equals(another.tagsQuery);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.toQueryParameters.hashCode();
        h += (h << 5) + Objects.hashCode(this.wait);
        h += (h << 5) + Objects.hashCode(this.token);
        h += (h << 5) + Objects.hashCode(this.hash);
        h += (h << 5) + Objects.hashCode(this.index);
        h += (h << 5) + Objects.hashCode(this.near);
        h += (h << 5) + Objects.hashCode(this.datacenter);
        h += (h << 5) + Objects.hashCode(this.filter);
        h += (h << 5) + Objects.hashCode(this.namespace);
        h += (h << 5) + Objects.hashCode(this.wan);
        h += (h << 5) + Objects.hashCode(this.segment);
        h += (h << 5) + Objects.hashCode(this.note);
        h += (h << 5) + Objects.hashCode(this.enable);
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.nodeMeta.hashCode();
        h += (h << 5) + this.tag.hashCode();
        h += (h << 5) + this.consistencyMode.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isBlocking);
        h += (h << 5) + Booleans.hashCode((boolean)this.hasToken);
        h += (h << 5) + this.nodeMetaQuery.hashCode();
        h += (h << 5) + this.tagsQuery.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"QueryOptions").omitNullValues().add("toQueryParameters", this.toQueryParameters).add("wait", (Object)this.wait).add("token", (Object)this.token).add("hash", (Object)this.hash).add("index", (Object)this.index).add("near", (Object)this.near).add("datacenter", (Object)this.datacenter).add("filter", (Object)this.filter).add("namespace", (Object)this.namespace).add("wan", (Object)this.wan).add("segment", (Object)this.segment).add("note", (Object)this.note).add("enable", (Object)this.enable).add("reason", (Object)this.reason).add("nodeMeta", this.nodeMeta).add("tag", this.tag).add("consistencyMode", (Object)this.consistencyMode).add("isBlocking", this.isBlocking).add("hasToken", this.hasToken).add("nodeMetaQuery", this.nodeMetaQuery).add("tagsQuery", this.tagsQuery).toString();
    }

    private static ImmutableQueryOptions validate(ImmutableQueryOptions instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableQueryOptions copyOf(QueryOptions instance) {
        if (instance instanceof ImmutableQueryOptions) {
            return (ImmutableQueryOptions)instance;
        }
        return ImmutableQueryOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QueryOptions", generator="Immutables")
    private final class InitShim {
        private byte consistencyModeBuildStage = 0;
        private ConsistencyMode consistencyMode;
        private byte isBlockingBuildStage = 0;
        private boolean isBlocking;
        private byte hasTokenBuildStage = 0;
        private boolean hasToken;
        private byte nodeMetaQueryBuildStage = 0;
        private List<String> nodeMetaQuery;
        private byte tagsQueryBuildStage = 0;
        private List<String> tagsQuery;

        private InitShim() {
        }

        ConsistencyMode getConsistencyMode() {
            if (this.consistencyModeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.consistencyModeBuildStage == 0) {
                this.consistencyModeBuildStage = (byte)-1;
                this.consistencyMode = Objects.requireNonNull(ImmutableQueryOptions.super.getConsistencyMode(), "consistencyMode");
                this.consistencyModeBuildStage = 1;
            }
            return this.consistencyMode;
        }

        void consistencyMode(ConsistencyMode consistencyMode) {
            this.consistencyMode = consistencyMode;
            this.consistencyModeBuildStage = 1;
        }

        boolean isBlocking() {
            if (this.isBlockingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isBlockingBuildStage == 0) {
                this.isBlockingBuildStage = (byte)-1;
                this.isBlocking = ImmutableQueryOptions.super.isBlocking();
                this.isBlockingBuildStage = 1;
            }
            return this.isBlocking;
        }

        boolean hasToken() {
            if (this.hasTokenBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTokenBuildStage == 0) {
                this.hasTokenBuildStage = (byte)-1;
                this.hasToken = ImmutableQueryOptions.super.hasToken();
                this.hasTokenBuildStage = 1;
            }
            return this.hasToken;
        }

        List<String> getNodeMetaQuery() {
            if (this.nodeMetaQueryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeMetaQueryBuildStage == 0) {
                this.nodeMetaQueryBuildStage = (byte)-1;
                this.nodeMetaQuery = Objects.requireNonNull(ImmutableQueryOptions.super.getNodeMetaQuery(), "nodeMetaQuery");
                this.nodeMetaQueryBuildStage = 1;
            }
            return this.nodeMetaQuery;
        }

        List<String> getTagsQuery() {
            if (this.tagsQueryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tagsQueryBuildStage == 0) {
                this.tagsQueryBuildStage = (byte)-1;
                this.tagsQuery = Objects.requireNonNull(ImmutableQueryOptions.super.getTagsQuery(), "tagsQuery");
                this.tagsQueryBuildStage = 1;
            }
            return this.tagsQuery;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.consistencyModeBuildStage == -1) {
                attributes.add("consistencyMode");
            }
            if (this.isBlockingBuildStage == -1) {
                attributes.add("isBlocking");
            }
            if (this.hasTokenBuildStage == -1) {
                attributes.add("hasToken");
            }
            if (this.nodeMetaQueryBuildStage == -1) {
                attributes.add("nodeMetaQuery");
            }
            if (this.tagsQueryBuildStage == -1) {
                attributes.add("tagsQuery");
            }
            return "Cannot build QueryOptions, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="QueryOptions", generator="Immutables")
    public static final class Builder {
        private ImmutableList.Builder<String> toQueryParameters = ImmutableList.builder();
        @Nullable
        private String wait;
        @Nullable
        private String token;
        @Nullable
        private String hash;
        @Nullable
        private BigInteger index;
        @Nullable
        private String near;
        @Nullable
        private String datacenter;
        @Nullable
        private String filter;
        @Nullable
        private String namespace;
        @Nullable
        private Boolean wan;
        @Nullable
        private String segment;
        @Nullable
        private String note;
        @Nullable
        private Boolean enable;
        @Nullable
        private String reason;
        private ImmutableList.Builder<String> nodeMeta = ImmutableList.builder();
        private ImmutableList.Builder<String> tag = ImmutableList.builder();
        @Nullable
        private ConsistencyMode consistencyMode;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ParamAdder instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(QueryOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ParamAdder instance;
            if (object instanceof ParamAdder) {
                instance = (ParamAdder)object;
                this.addAllToQueryParameters(instance.toQueryParameters());
            }
            if (object instanceof QueryOptions) {
                Optional<String> nearOptional;
                Optional<String> namespaceOptional;
                Optional<Boolean> enableOptional;
                Optional<String> filterOptional;
                Optional<String> datacenterOptional;
                Optional<BigInteger> indexOptional;
                Optional<Boolean> wanOptional;
                Optional<String> waitOptional;
                Optional<String> reasonOptional;
                instance = (QueryOptions)object;
                Optional<String> noteOptional = ((QueryOptions)instance).getNote();
                if (noteOptional.isPresent()) {
                    this.note(noteOptional);
                }
                if ((reasonOptional = ((QueryOptions)instance).getReason()).isPresent()) {
                    this.reason(reasonOptional);
                }
                if ((waitOptional = ((QueryOptions)instance).getWait()).isPresent()) {
                    this.wait(waitOptional);
                }
                if ((wanOptional = ((QueryOptions)instance).getWan()).isPresent()) {
                    this.wan(wanOptional);
                }
                if ((indexOptional = ((QueryOptions)instance).getIndex()).isPresent()) {
                    this.index(indexOptional);
                }
                if ((datacenterOptional = ((QueryOptions)instance).getDatacenter()).isPresent()) {
                    this.datacenter(datacenterOptional);
                }
                this.addAllNodeMeta(((QueryOptions)instance).getNodeMeta());
                Optional<String> tokenOptional = ((QueryOptions)instance).getToken();
                if (tokenOptional.isPresent()) {
                    this.token(tokenOptional);
                }
                if ((filterOptional = ((QueryOptions)instance).getFilter()).isPresent()) {
                    this.filter(filterOptional);
                }
                if ((enableOptional = ((QueryOptions)instance).getEnable()).isPresent()) {
                    this.enable(enableOptional);
                }
                this.consistencyMode(((QueryOptions)instance).getConsistencyMode());
                Optional<String> segmentOptional = ((QueryOptions)instance).getSegment();
                if (segmentOptional.isPresent()) {
                    this.segment(segmentOptional);
                }
                if ((namespaceOptional = ((QueryOptions)instance).getNamespace()).isPresent()) {
                    this.namespace(namespaceOptional);
                }
                if ((nearOptional = ((QueryOptions)instance).getNear()).isPresent()) {
                    this.near(nearOptional);
                }
                this.addAllTag(((QueryOptions)instance).getTag());
                Optional<String> hashOptional = ((QueryOptions)instance).getHash();
                if (hashOptional.isPresent()) {
                    this.hash(hashOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String element) {
            this.toQueryParameters.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String ... elements) {
            this.toQueryParameters.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toQueryParameters(Iterable<String> elements) {
            this.toQueryParameters = ImmutableList.builder();
            return this.addAllToQueryParameters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllToQueryParameters(Iterable<String> elements) {
            this.toQueryParameters.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wait(String wait) {
            this.wait = Objects.requireNonNull(wait, "wait");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wait(Optional<String> wait) {
            this.wait = wait.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(Optional<String> token) {
            this.token = token.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(Optional<String> hash) {
            this.hash = hash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder index(BigInteger index) {
            this.index = Objects.requireNonNull(index, "index");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder index(Optional<? extends BigInteger> index) {
            this.index = index.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder near(String near) {
            this.near = Objects.requireNonNull(near, "near");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder near(Optional<String> near) {
            this.near = near.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filter(String filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filter(Optional<String> filter) {
            this.filter = filter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(String namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(Optional<String> namespace) {
            this.namespace = namespace.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wan(boolean wan) {
            this.wan = wan;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wan(Optional<Boolean> wan) {
            this.wan = wan.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder segment(String segment) {
            this.segment = Objects.requireNonNull(segment, "segment");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder segment(Optional<String> segment) {
            this.segment = segment.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder note(String note) {
            this.note = Objects.requireNonNull(note, "note");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder note(Optional<String> note) {
            this.note = note.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enable(boolean enable) {
            this.enable = enable;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enable(Optional<Boolean> enable) {
            this.enable = enable.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(String reason) {
            this.reason = Objects.requireNonNull(reason, "reason");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(Optional<String> reason) {
            this.reason = reason.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodeMeta(String element) {
            this.nodeMeta.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodeMeta(String ... elements) {
            this.nodeMeta.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nodeMeta(Iterable<String> elements) {
            this.nodeMeta = ImmutableList.builder();
            return this.addAllNodeMeta(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNodeMeta(Iterable<String> elements) {
            this.nodeMeta.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTag(String element) {
            this.tag.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTag(String ... elements) {
            this.tag.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tag(Iterable<String> elements) {
            this.tag = ImmutableList.builder();
            return this.addAllTag(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTag(Iterable<String> elements) {
            this.tag.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder consistencyMode(ConsistencyMode consistencyMode) {
            this.consistencyMode = Objects.requireNonNull(consistencyMode, "consistencyMode");
            return this;
        }

        public ImmutableQueryOptions build() {
            return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this));
        }
    }
}

