package org.kiwiproject.consul.cache;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ServiceHealthKey}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableServiceHealthKey.builder()}.
 */
@Generated(from = "ServiceHealthKey", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableServiceHealthKey extends ServiceHealthKey {
  private final String serviceId;
  private final String host;
  private final Integer port;

  private ImmutableServiceHealthKey(String serviceId, String host, Integer port) {
    this.serviceId = serviceId;
    this.host = host;
    this.port = port;
  }

  /**
   * @return The value of the {@code serviceId} attribute
   */
  @Override
  public String getServiceId() {
    return serviceId;
  }

  /**
   * @return The value of the {@code host} attribute
   */
  @Override
  public String getHost() {
    return host;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @Override
  public Integer getPort() {
    return port;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceHealthKey#getServiceId() serviceId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serviceId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceHealthKey withServiceId(String value) {
    String newValue = Objects.requireNonNull(value, "serviceId");
    if (this.serviceId.equals(newValue)) return this;
    return new ImmutableServiceHealthKey(newValue, this.host, this.port);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceHealthKey#getHost() host} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for host
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceHealthKey withHost(String value) {
    String newValue = Objects.requireNonNull(value, "host");
    if (this.host.equals(newValue)) return this;
    return new ImmutableServiceHealthKey(this.serviceId, newValue, this.port);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceHealthKey#getPort() port} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceHealthKey withPort(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "port");
    if (this.port.equals(newValue)) return this;
    return new ImmutableServiceHealthKey(this.serviceId, this.host, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableServiceHealthKey} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableServiceHealthKey
        && equalTo(0, (ImmutableServiceHealthKey) another);
  }

  private boolean equalTo(int synthetic, ImmutableServiceHealthKey another) {
    return serviceId.equals(another.serviceId)
        && host.equals(another.host)
        && port.equals(another.port);
  }

  /**
   * Computes a hash code from attributes: {@code serviceId}, {@code host}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + serviceId.hashCode();
    h += (h << 5) + host.hashCode();
    h += (h << 5) + port.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceHealthKey} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ServiceHealthKey")
        .omitNullValues()
        .add("serviceId", serviceId)
        .add("host", host)
        .add("port", port)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ServiceHealthKey} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ServiceHealthKey instance
   */
  public static ImmutableServiceHealthKey copyOf(ServiceHealthKey instance) {
    if (instance instanceof ImmutableServiceHealthKey) {
      return (ImmutableServiceHealthKey) instance;
    }
    return ImmutableServiceHealthKey.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableServiceHealthKey ImmutableServiceHealthKey}.
   * <pre>
   * ImmutableServiceHealthKey.builder()
   *    .serviceId(String) // required {@link ServiceHealthKey#getServiceId() serviceId}
   *    .host(String) // required {@link ServiceHealthKey#getHost() host}
   *    .port(Integer) // required {@link ServiceHealthKey#getPort() port}
   *    .build();
   * </pre>
   * @return A new ImmutableServiceHealthKey builder
   */
  public static ImmutableServiceHealthKey.Builder builder() {
    return new ImmutableServiceHealthKey.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableServiceHealthKey ImmutableServiceHealthKey}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ServiceHealthKey", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_ID = 0x1L;
    private static final long INIT_BIT_HOST = 0x2L;
    private static final long INIT_BIT_PORT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String serviceId;
    private @Nullable String host;
    private @Nullable Integer port;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceHealthKey} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ServiceHealthKey instance) {
      Objects.requireNonNull(instance, "instance");
      this.serviceId(instance.getServiceId());
      this.host(instance.getHost());
      this.port(instance.getPort());
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceHealthKey#getServiceId() serviceId} attribute.
     * @param serviceId The value for serviceId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serviceId(String serviceId) {
      this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
      initBits &= ~INIT_BIT_SERVICE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceHealthKey#getHost() host} attribute.
     * @param host The value for host 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder host(String host) {
      this.host = Objects.requireNonNull(host, "host");
      initBits &= ~INIT_BIT_HOST;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceHealthKey#getPort() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder port(Integer port) {
      this.port = Objects.requireNonNull(port, "port");
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableServiceHealthKey ImmutableServiceHealthKey}.
     * @return An immutable instance of ServiceHealthKey
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableServiceHealthKey build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableServiceHealthKey(serviceId, host, port);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_ID) != 0) attributes.add("serviceId");
      if ((initBits & INIT_BIT_HOST) != 0) attributes.add("host");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      return "Cannot build ServiceHealthKey, some of required attributes are not set " + attributes;
    }
  }
}
