package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RoleListResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRoleListResponse.builder()}.
 */
@Generated(from = "RoleListResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableRoleListResponse extends RoleListResponse {
  private final String id;
  private final String name;
  private final String description;
  private final ImmutableList<Role.RolePolicyLink> policies;
  private final ImmutableList<Role.RoleServiceIdentity> serviceIdentities;
  private final ImmutableList<Role.RoleNodeIdentity> nodeIdentities;
  private final BigInteger createIndex;
  private final BigInteger modifyIndex;
  private final String hash;

  private ImmutableRoleListResponse(
      String id,
      String name,
      String description,
      ImmutableList<Role.RolePolicyLink> policies,
      ImmutableList<Role.RoleServiceIdentity> serviceIdentities,
      ImmutableList<Role.RoleNodeIdentity> nodeIdentities,
      BigInteger createIndex,
      BigInteger modifyIndex,
      String hash) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.policies = policies;
    this.serviceIdentities = serviceIdentities;
    this.nodeIdentities = nodeIdentities;
    this.createIndex = createIndex;
    this.modifyIndex = modifyIndex;
    this.hash = hash;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("Description")
  @Override
  public String description() {
    return description;
  }

  /**
   * @return The value of the {@code policies} attribute
   */
  @JsonProperty("Policies")
  @Override
  public ImmutableList<Role.RolePolicyLink> policies() {
    return policies;
  }

  /**
   * @return The value of the {@code serviceIdentities} attribute
   */
  @JsonProperty("ServiceIdentities")
  @Override
  public ImmutableList<Role.RoleServiceIdentity> serviceIdentities() {
    return serviceIdentities;
  }

  /**
   * @return The value of the {@code nodeIdentities} attribute
   */
  @JsonProperty("NodeIdentities")
  @Override
  public ImmutableList<Role.RoleNodeIdentity> nodeIdentities() {
    return nodeIdentities;
  }

  /**
   * @return The value of the {@code createIndex} attribute
   */
  @JsonProperty("CreateIndex")
  @Override
  public BigInteger createIndex() {
    return createIndex;
  }

  /**
   * @return The value of the {@code modifyIndex} attribute
   */
  @JsonProperty("ModifyIndex")
  @Override
  public BigInteger modifyIndex() {
    return modifyIndex;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("Hash")
  @Override
  public String hash() {
    return hash;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RoleListResponse#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRoleListResponse withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableRoleListResponse(
        newValue,
        this.name,
        this.description,
        this.policies,
        this.serviceIdentities,
        this.nodeIdentities,
        this.createIndex,
        this.modifyIndex,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RoleListResponse#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRoleListResponse withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableRoleListResponse(
        this.id,
        newValue,
        this.description,
        this.policies,
        this.serviceIdentities,
        this.nodeIdentities,
        this.createIndex,
        this.modifyIndex,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RoleListResponse#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRoleListResponse withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableRoleListResponse(
        this.id,
        this.name,
        newValue,
        this.policies,
        this.serviceIdentities,
        this.nodeIdentities,
        this.createIndex,
        this.modifyIndex,
        this.hash);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RoleListResponse#policies() policies}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleListResponse withPolicies(Role.RolePolicyLink... elements) {
    ImmutableList<Role.RolePolicyLink> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRoleListResponse(
        this.id,
        this.name,
        this.description,
        newValue,
        this.serviceIdentities,
        this.nodeIdentities,
        this.createIndex,
        this.modifyIndex,
        this.hash);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RoleListResponse#policies() policies}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of policies elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleListResponse withPolicies(Iterable<? extends Role.RolePolicyLink> elements) {
    if (this.policies == elements) return this;
    ImmutableList<Role.RolePolicyLink> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRoleListResponse(
        this.id,
        this.name,
        this.description,
        newValue,
        this.serviceIdentities,
        this.nodeIdentities,
        this.createIndex,
        this.modifyIndex,
        this.hash);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RoleListResponse#serviceIdentities() serviceIdentities}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleListResponse withServiceIdentities(Role.RoleServiceIdentity... elements) {
    ImmutableList<Role.RoleServiceIdentity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRoleListResponse(
        this.id,
        this.name,
        this.description,
        this.policies,
        newValue,
        this.nodeIdentities,
        this.createIndex,
        this.modifyIndex,
        this.hash);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RoleListResponse#serviceIdentities() serviceIdentities}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of serviceIdentities elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleListResponse withServiceIdentities(Iterable<? extends Role.RoleServiceIdentity> elements) {
    if (this.serviceIdentities == elements) return this;
    ImmutableList<Role.RoleServiceIdentity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRoleListResponse(
        this.id,
        this.name,
        this.description,
        this.policies,
        newValue,
        this.nodeIdentities,
        this.createIndex,
        this.modifyIndex,
        this.hash);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RoleListResponse#nodeIdentities() nodeIdentities}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleListResponse withNodeIdentities(Role.RoleNodeIdentity... elements) {
    ImmutableList<Role.RoleNodeIdentity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRoleListResponse(
        this.id,
        this.name,
        this.description,
        this.policies,
        this.serviceIdentities,
        newValue,
        this.createIndex,
        this.modifyIndex,
        this.hash);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RoleListResponse#nodeIdentities() nodeIdentities}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nodeIdentities elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleListResponse withNodeIdentities(Iterable<? extends Role.RoleNodeIdentity> elements) {
    if (this.nodeIdentities == elements) return this;
    ImmutableList<Role.RoleNodeIdentity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRoleListResponse(
        this.id,
        this.name,
        this.description,
        this.policies,
        this.serviceIdentities,
        newValue,
        this.createIndex,
        this.modifyIndex,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RoleListResponse#createIndex() createIndex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRoleListResponse withCreateIndex(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "createIndex");
    if (this.createIndex.equals(newValue)) return this;
    return new ImmutableRoleListResponse(
        this.id,
        this.name,
        this.description,
        this.policies,
        this.serviceIdentities,
        this.nodeIdentities,
        newValue,
        this.modifyIndex,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RoleListResponse#modifyIndex() modifyIndex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modifyIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRoleListResponse withModifyIndex(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "modifyIndex");
    if (this.modifyIndex.equals(newValue)) return this;
    return new ImmutableRoleListResponse(
        this.id,
        this.name,
        this.description,
        this.policies,
        this.serviceIdentities,
        this.nodeIdentities,
        this.createIndex,
        newValue,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RoleListResponse#hash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRoleListResponse withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutableRoleListResponse(
        this.id,
        this.name,
        this.description,
        this.policies,
        this.serviceIdentities,
        this.nodeIdentities,
        this.createIndex,
        this.modifyIndex,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRoleListResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRoleListResponse
        && equalTo(0, (ImmutableRoleListResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableRoleListResponse another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && description.equals(another.description)
        && policies.equals(another.policies)
        && serviceIdentities.equals(another.serviceIdentities)
        && nodeIdentities.equals(another.nodeIdentities)
        && createIndex.equals(another.createIndex)
        && modifyIndex.equals(another.modifyIndex)
        && hash.equals(another.hash);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code description}, {@code policies}, {@code serviceIdentities}, {@code nodeIdentities}, {@code createIndex}, {@code modifyIndex}, {@code hash}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + policies.hashCode();
    h += (h << 5) + serviceIdentities.hashCode();
    h += (h << 5) + nodeIdentities.hashCode();
    h += (h << 5) + createIndex.hashCode();
    h += (h << 5) + modifyIndex.hashCode();
    h += (h << 5) + hash.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RoleListResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RoleListResponse")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("description", description)
        .add("policies", policies)
        .add("serviceIdentities", serviceIdentities)
        .add("nodeIdentities", nodeIdentities)
        .add("createIndex", createIndex)
        .add("modifyIndex", modifyIndex)
        .add("hash", hash)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RoleListResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends RoleListResponse {
    @Nullable String id;
    @Nullable String name;
    @Nullable String description;
    @Nullable List<Role.RolePolicyLink> policies = ImmutableList.of();
    @Nullable List<Role.RoleServiceIdentity> serviceIdentities = ImmutableList.of();
    @Nullable List<Role.RoleNodeIdentity> nodeIdentities = ImmutableList.of();
    @Nullable BigInteger createIndex;
    @Nullable BigInteger modifyIndex;
    @Nullable String hash;
    @JsonProperty("ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("Description")
    public void setDescription(String description) {
      this.description = description;
    }
    @JsonProperty("Policies")
    public void setPolicies(List<Role.RolePolicyLink> policies) {
      this.policies = policies;
    }
    @JsonProperty("ServiceIdentities")
    public void setServiceIdentities(List<Role.RoleServiceIdentity> serviceIdentities) {
      this.serviceIdentities = serviceIdentities;
    }
    @JsonProperty("NodeIdentities")
    public void setNodeIdentities(List<Role.RoleNodeIdentity> nodeIdentities) {
      this.nodeIdentities = nodeIdentities;
    }
    @JsonProperty("CreateIndex")
    public void setCreateIndex(BigInteger createIndex) {
      this.createIndex = createIndex;
    }
    @JsonProperty("ModifyIndex")
    public void setModifyIndex(BigInteger modifyIndex) {
      this.modifyIndex = modifyIndex;
    }
    @JsonProperty("Hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @Override
    public String id() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public String description() { throw new UnsupportedOperationException(); }
    @Override
    public List<Role.RolePolicyLink> policies() { throw new UnsupportedOperationException(); }
    @Override
    public List<Role.RoleServiceIdentity> serviceIdentities() { throw new UnsupportedOperationException(); }
    @Override
    public List<Role.RoleNodeIdentity> nodeIdentities() { throw new UnsupportedOperationException(); }
    @Override
    public BigInteger createIndex() { throw new UnsupportedOperationException(); }
    @Override
    public BigInteger modifyIndex() { throw new UnsupportedOperationException(); }
    @Override
    public String hash() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRoleListResponse fromJson(Json json) {
    ImmutableRoleListResponse.Builder builder = ImmutableRoleListResponse.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.policies != null) {
      builder.addAllPolicies(json.policies);
    }
    if (json.serviceIdentities != null) {
      builder.addAllServiceIdentities(json.serviceIdentities);
    }
    if (json.nodeIdentities != null) {
      builder.addAllNodeIdentities(json.nodeIdentities);
    }
    if (json.createIndex != null) {
      builder.createIndex(json.createIndex);
    }
    if (json.modifyIndex != null) {
      builder.modifyIndex(json.modifyIndex);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RoleListResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RoleListResponse instance
   */
  public static ImmutableRoleListResponse copyOf(RoleListResponse instance) {
    if (instance instanceof ImmutableRoleListResponse) {
      return (ImmutableRoleListResponse) instance;
    }
    return ImmutableRoleListResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRoleListResponse ImmutableRoleListResponse}.
   * <pre>
   * ImmutableRoleListResponse.builder()
   *    .id(String) // required {@link RoleListResponse#id() id}
   *    .name(String) // required {@link RoleListResponse#name() name}
   *    .description(String) // required {@link RoleListResponse#description() description}
   *    .addPolicies|addAllPolicies(org.kiwiproject.consul.model.acl.Role.RolePolicyLink) // {@link RoleListResponse#policies() policies} elements
   *    .addServiceIdentities|addAllServiceIdentities(org.kiwiproject.consul.model.acl.Role.RoleServiceIdentity) // {@link RoleListResponse#serviceIdentities() serviceIdentities} elements
   *    .addNodeIdentities|addAllNodeIdentities(org.kiwiproject.consul.model.acl.Role.RoleNodeIdentity) // {@link RoleListResponse#nodeIdentities() nodeIdentities} elements
   *    .createIndex(java.math.BigInteger) // required {@link RoleListResponse#createIndex() createIndex}
   *    .modifyIndex(java.math.BigInteger) // required {@link RoleListResponse#modifyIndex() modifyIndex}
   *    .hash(String) // required {@link RoleListResponse#hash() hash}
   *    .build();
   * </pre>
   * @return A new ImmutableRoleListResponse builder
   */
  public static ImmutableRoleListResponse.Builder builder() {
    return new ImmutableRoleListResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRoleListResponse ImmutableRoleListResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RoleListResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_DESCRIPTION = 0x4L;
    private static final long INIT_BIT_CREATE_INDEX = 0x8L;
    private static final long INIT_BIT_MODIFY_INDEX = 0x10L;
    private static final long INIT_BIT_HASH = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String description;
    private ImmutableList.Builder<Role.RolePolicyLink> policies = ImmutableList.builder();
    private ImmutableList.Builder<Role.RoleServiceIdentity> serviceIdentities = ImmutableList.builder();
    private ImmutableList.Builder<Role.RoleNodeIdentity> nodeIdentities = ImmutableList.builder();
    private @Nullable BigInteger createIndex;
    private @Nullable BigInteger modifyIndex;
    private @Nullable String hash;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.kiwiproject.consul.model.acl.BaseRoleResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseRoleResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.kiwiproject.consul.model.acl.RoleListResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RoleListResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof BaseRoleResponse) {
        BaseRoleResponse instance = (BaseRoleResponse) object;
        addAllNodeIdentities(instance.nodeIdentities());
        this.modifyIndex(instance.modifyIndex());
        addAllServiceIdentities(instance.serviceIdentities());
        addAllPolicies(instance.policies());
        this.name(instance.name());
        this.description(instance.description());
        this.id(instance.id());
        this.createIndex(instance.createIndex());
        this.hash(instance.hash());
      }
    }

    /**
     * Initializes the value for the {@link RoleListResponse#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RoleListResponse#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link RoleListResponse#description() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Adds one element to {@link RoleListResponse#policies() policies} list.
     * @param element A policies element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPolicies(Role.RolePolicyLink element) {
      this.policies.add(element);
      return this;
    }

    /**
     * Adds elements to {@link RoleListResponse#policies() policies} list.
     * @param elements An array of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPolicies(Role.RolePolicyLink... elements) {
      this.policies.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link RoleListResponse#policies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Policies")
    public final Builder policies(Iterable<? extends Role.RolePolicyLink> elements) {
      this.policies = ImmutableList.builder();
      return addAllPolicies(elements);
    }

    /**
     * Adds elements to {@link RoleListResponse#policies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPolicies(Iterable<? extends Role.RolePolicyLink> elements) {
      this.policies.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link RoleListResponse#serviceIdentities() serviceIdentities} list.
     * @param element A serviceIdentities element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addServiceIdentities(Role.RoleServiceIdentity element) {
      this.serviceIdentities.add(element);
      return this;
    }

    /**
     * Adds elements to {@link RoleListResponse#serviceIdentities() serviceIdentities} list.
     * @param elements An array of serviceIdentities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addServiceIdentities(Role.RoleServiceIdentity... elements) {
      this.serviceIdentities.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link RoleListResponse#serviceIdentities() serviceIdentities} list.
     * @param elements An iterable of serviceIdentities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceIdentities")
    public final Builder serviceIdentities(Iterable<? extends Role.RoleServiceIdentity> elements) {
      this.serviceIdentities = ImmutableList.builder();
      return addAllServiceIdentities(elements);
    }

    /**
     * Adds elements to {@link RoleListResponse#serviceIdentities() serviceIdentities} list.
     * @param elements An iterable of serviceIdentities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllServiceIdentities(Iterable<? extends Role.RoleServiceIdentity> elements) {
      this.serviceIdentities.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link RoleListResponse#nodeIdentities() nodeIdentities} list.
     * @param element A nodeIdentities element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNodeIdentities(Role.RoleNodeIdentity element) {
      this.nodeIdentities.add(element);
      return this;
    }

    /**
     * Adds elements to {@link RoleListResponse#nodeIdentities() nodeIdentities} list.
     * @param elements An array of nodeIdentities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNodeIdentities(Role.RoleNodeIdentity... elements) {
      this.nodeIdentities.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link RoleListResponse#nodeIdentities() nodeIdentities} list.
     * @param elements An iterable of nodeIdentities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("NodeIdentities")
    public final Builder nodeIdentities(Iterable<? extends Role.RoleNodeIdentity> elements) {
      this.nodeIdentities = ImmutableList.builder();
      return addAllNodeIdentities(elements);
    }

    /**
     * Adds elements to {@link RoleListResponse#nodeIdentities() nodeIdentities} list.
     * @param elements An iterable of nodeIdentities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNodeIdentities(Iterable<? extends Role.RoleNodeIdentity> elements) {
      this.nodeIdentities.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link RoleListResponse#createIndex() createIndex} attribute.
     * @param createIndex The value for createIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("CreateIndex")
    public final Builder createIndex(BigInteger createIndex) {
      this.createIndex = Objects.requireNonNull(createIndex, "createIndex");
      initBits &= ~INIT_BIT_CREATE_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link RoleListResponse#modifyIndex() modifyIndex} attribute.
     * @param modifyIndex The value for modifyIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ModifyIndex")
    public final Builder modifyIndex(BigInteger modifyIndex) {
      this.modifyIndex = Objects.requireNonNull(modifyIndex, "modifyIndex");
      initBits &= ~INIT_BIT_MODIFY_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link RoleListResponse#hash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRoleListResponse ImmutableRoleListResponse}.
     * @return An immutable instance of RoleListResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRoleListResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRoleListResponse(
          id,
          name,
          description,
          policies.build(),
          serviceIdentities.build(),
          nodeIdentities.build(),
          createIndex,
          modifyIndex,
          hash);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_CREATE_INDEX) != 0) attributes.add("createIndex");
      if ((initBits & INIT_BIT_MODIFY_INDEX) != 0) attributes.add("modifyIndex");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      return "Cannot build RoleListResponse, some of required attributes are not set " + attributes;
    }
  }
}
