package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TokenResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTokenResponse.builder()}.
 */
@Generated(from = "TokenResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableTokenResponse extends TokenResponse {
  private final String accessorId;
  private final String description;
  private final ImmutableList<Token.PolicyLink> policies;
  private final BigInteger createIndex;
  private final BigInteger modifyIndex;
  private final boolean local;
  private final Date createTime;
  private final String hash;
  private final String secretId;

  private ImmutableTokenResponse(
      String accessorId,
      String description,
      ImmutableList<Token.PolicyLink> policies,
      BigInteger createIndex,
      BigInteger modifyIndex,
      boolean local,
      Date createTime,
      String hash,
      String secretId) {
    this.accessorId = accessorId;
    this.description = description;
    this.policies = policies;
    this.createIndex = createIndex;
    this.modifyIndex = modifyIndex;
    this.local = local;
    this.createTime = createTime;
    this.hash = hash;
    this.secretId = secretId;
  }

  /**
   * @return The value of the {@code accessorId} attribute
   */
  @JsonProperty("AccessorID")
  @Override
  public String accessorId() {
    return accessorId;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("Description")
  @Override
  public String description() {
    return description;
  }

  /**
   * @return The value of the {@code policies} attribute
   */
  @JsonProperty("Policies")
  @Override
  public ImmutableList<Token.PolicyLink> policies() {
    return policies;
  }

  /**
   * @return The value of the {@code createIndex} attribute
   */
  @JsonProperty("CreateIndex")
  @Override
  public BigInteger createIndex() {
    return createIndex;
  }

  /**
   * @return The value of the {@code modifyIndex} attribute
   */
  @JsonProperty("ModifyIndex")
  @Override
  public BigInteger modifyIndex() {
    return modifyIndex;
  }

  /**
   * @return The value of the {@code local} attribute
   */
  @JsonProperty("Local")
  @Override
  public boolean local() {
    return local;
  }

  /**
   * @return The value of the {@code createTime} attribute
   */
  @JsonProperty("CreateTime")
  @Override
  public Date createTime() {
    return createTime;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("Hash")
  @Override
  public String hash() {
    return hash;
  }

  /**
   * @return The value of the {@code secretId} attribute
   */
  @JsonProperty("SecretID")
  @Override
  public String secretId() {
    return secretId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenResponse#accessorId() accessorId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for accessorId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenResponse withAccessorId(String value) {
    String newValue = Objects.requireNonNull(value, "accessorId");
    if (this.accessorId.equals(newValue)) return this;
    return new ImmutableTokenResponse(
        newValue,
        this.description,
        this.policies,
        this.createIndex,
        this.modifyIndex,
        this.local,
        this.createTime,
        this.hash,
        this.secretId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenResponse#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenResponse withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableTokenResponse(
        this.accessorId,
        newValue,
        this.policies,
        this.createIndex,
        this.modifyIndex,
        this.local,
        this.createTime,
        this.hash,
        this.secretId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TokenResponse#policies() policies}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTokenResponse withPolicies(Token.PolicyLink... elements) {
    ImmutableList<Token.PolicyLink> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTokenResponse(
        this.accessorId,
        this.description,
        newValue,
        this.createIndex,
        this.modifyIndex,
        this.local,
        this.createTime,
        this.hash,
        this.secretId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TokenResponse#policies() policies}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of policies elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTokenResponse withPolicies(Iterable<? extends Token.PolicyLink> elements) {
    if (this.policies == elements) return this;
    ImmutableList<Token.PolicyLink> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTokenResponse(
        this.accessorId,
        this.description,
        newValue,
        this.createIndex,
        this.modifyIndex,
        this.local,
        this.createTime,
        this.hash,
        this.secretId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenResponse#createIndex() createIndex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenResponse withCreateIndex(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "createIndex");
    if (this.createIndex.equals(newValue)) return this;
    return new ImmutableTokenResponse(
        this.accessorId,
        this.description,
        this.policies,
        newValue,
        this.modifyIndex,
        this.local,
        this.createTime,
        this.hash,
        this.secretId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenResponse#modifyIndex() modifyIndex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modifyIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenResponse withModifyIndex(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "modifyIndex");
    if (this.modifyIndex.equals(newValue)) return this;
    return new ImmutableTokenResponse(
        this.accessorId,
        this.description,
        this.policies,
        this.createIndex,
        newValue,
        this.local,
        this.createTime,
        this.hash,
        this.secretId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenResponse#local() local} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for local
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenResponse withLocal(boolean value) {
    if (this.local == value) return this;
    return new ImmutableTokenResponse(
        this.accessorId,
        this.description,
        this.policies,
        this.createIndex,
        this.modifyIndex,
        value,
        this.createTime,
        this.hash,
        this.secretId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenResponse#createTime() createTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenResponse withCreateTime(Date value) {
    if (this.createTime == value) return this;
    Date newValue = Objects.requireNonNull(value, "createTime");
    return new ImmutableTokenResponse(
        this.accessorId,
        this.description,
        this.policies,
        this.createIndex,
        this.modifyIndex,
        this.local,
        newValue,
        this.hash,
        this.secretId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenResponse#hash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenResponse withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutableTokenResponse(
        this.accessorId,
        this.description,
        this.policies,
        this.createIndex,
        this.modifyIndex,
        this.local,
        this.createTime,
        newValue,
        this.secretId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenResponse#secretId() secretId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for secretId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenResponse withSecretId(String value) {
    String newValue = Objects.requireNonNull(value, "secretId");
    if (this.secretId.equals(newValue)) return this;
    return new ImmutableTokenResponse(
        this.accessorId,
        this.description,
        this.policies,
        this.createIndex,
        this.modifyIndex,
        this.local,
        this.createTime,
        this.hash,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTokenResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTokenResponse
        && equalTo(0, (ImmutableTokenResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableTokenResponse another) {
    return accessorId.equals(another.accessorId)
        && description.equals(another.description)
        && policies.equals(another.policies)
        && createIndex.equals(another.createIndex)
        && modifyIndex.equals(another.modifyIndex)
        && local == another.local
        && createTime.equals(another.createTime)
        && hash.equals(another.hash)
        && secretId.equals(another.secretId);
  }

  /**
   * Computes a hash code from attributes: {@code accessorId}, {@code description}, {@code policies}, {@code createIndex}, {@code modifyIndex}, {@code local}, {@code createTime}, {@code hash}, {@code secretId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + accessorId.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + policies.hashCode();
    h += (h << 5) + createIndex.hashCode();
    h += (h << 5) + modifyIndex.hashCode();
    h += (h << 5) + Booleans.hashCode(local);
    h += (h << 5) + createTime.hashCode();
    h += (h << 5) + hash.hashCode();
    h += (h << 5) + secretId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TokenResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TokenResponse")
        .omitNullValues()
        .add("accessorId", accessorId)
        .add("description", description)
        .add("policies", policies)
        .add("createIndex", createIndex)
        .add("modifyIndex", modifyIndex)
        .add("local", local)
        .add("createTime", createTime)
        .add("hash", hash)
        .add("secretId", secretId)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TokenResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends TokenResponse {
    @Nullable String accessorId;
    @Nullable String description;
    @Nullable List<Token.PolicyLink> policies = ImmutableList.of();
    @Nullable BigInteger createIndex;
    @Nullable BigInteger modifyIndex;
    boolean local;
    boolean localIsSet;
    @Nullable Date createTime;
    @Nullable String hash;
    @Nullable String secretId;
    @JsonProperty("AccessorID")
    public void setAccessorId(String accessorId) {
      this.accessorId = accessorId;
    }
    @JsonProperty("Description")
    public void setDescription(String description) {
      this.description = description;
    }
    @JsonProperty("Policies")
    public void setPolicies(List<Token.PolicyLink> policies) {
      this.policies = policies;
    }
    @JsonProperty("CreateIndex")
    public void setCreateIndex(BigInteger createIndex) {
      this.createIndex = createIndex;
    }
    @JsonProperty("ModifyIndex")
    public void setModifyIndex(BigInteger modifyIndex) {
      this.modifyIndex = modifyIndex;
    }
    @JsonProperty("Local")
    public void setLocal(boolean local) {
      this.local = local;
      this.localIsSet = true;
    }
    @JsonProperty("CreateTime")
    public void setCreateTime(Date createTime) {
      this.createTime = createTime;
    }
    @JsonProperty("Hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @JsonProperty("SecretID")
    public void setSecretId(String secretId) {
      this.secretId = secretId;
    }
    @Override
    public String accessorId() { throw new UnsupportedOperationException(); }
    @Override
    public String description() { throw new UnsupportedOperationException(); }
    @Override
    public List<Token.PolicyLink> policies() { throw new UnsupportedOperationException(); }
    @Override
    public BigInteger createIndex() { throw new UnsupportedOperationException(); }
    @Override
    public BigInteger modifyIndex() { throw new UnsupportedOperationException(); }
    @Override
    public boolean local() { throw new UnsupportedOperationException(); }
    @Override
    public Date createTime() { throw new UnsupportedOperationException(); }
    @Override
    public String hash() { throw new UnsupportedOperationException(); }
    @Override
    public String secretId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTokenResponse fromJson(Json json) {
    ImmutableTokenResponse.Builder builder = ImmutableTokenResponse.builder();
    if (json.accessorId != null) {
      builder.accessorId(json.accessorId);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.policies != null) {
      builder.addAllPolicies(json.policies);
    }
    if (json.createIndex != null) {
      builder.createIndex(json.createIndex);
    }
    if (json.modifyIndex != null) {
      builder.modifyIndex(json.modifyIndex);
    }
    if (json.localIsSet) {
      builder.local(json.local);
    }
    if (json.createTime != null) {
      builder.createTime(json.createTime);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.secretId != null) {
      builder.secretId(json.secretId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TokenResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TokenResponse instance
   */
  public static ImmutableTokenResponse copyOf(TokenResponse instance) {
    if (instance instanceof ImmutableTokenResponse) {
      return (ImmutableTokenResponse) instance;
    }
    return ImmutableTokenResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTokenResponse ImmutableTokenResponse}.
   * <pre>
   * ImmutableTokenResponse.builder()
   *    .accessorId(String) // required {@link TokenResponse#accessorId() accessorId}
   *    .description(String) // required {@link TokenResponse#description() description}
   *    .addPolicies|addAllPolicies(org.kiwiproject.consul.model.acl.Token.PolicyLink) // {@link TokenResponse#policies() policies} elements
   *    .createIndex(java.math.BigInteger) // required {@link TokenResponse#createIndex() createIndex}
   *    .modifyIndex(java.math.BigInteger) // required {@link TokenResponse#modifyIndex() modifyIndex}
   *    .local(boolean) // required {@link TokenResponse#local() local}
   *    .createTime(Date) // required {@link TokenResponse#createTime() createTime}
   *    .hash(String) // required {@link TokenResponse#hash() hash}
   *    .secretId(String) // required {@link TokenResponse#secretId() secretId}
   *    .build();
   * </pre>
   * @return A new ImmutableTokenResponse builder
   */
  public static ImmutableTokenResponse.Builder builder() {
    return new ImmutableTokenResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTokenResponse ImmutableTokenResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TokenResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ACCESSOR_ID = 0x1L;
    private static final long INIT_BIT_DESCRIPTION = 0x2L;
    private static final long INIT_BIT_CREATE_INDEX = 0x4L;
    private static final long INIT_BIT_MODIFY_INDEX = 0x8L;
    private static final long INIT_BIT_LOCAL = 0x10L;
    private static final long INIT_BIT_CREATE_TIME = 0x20L;
    private static final long INIT_BIT_HASH = 0x40L;
    private static final long INIT_BIT_SECRET_ID = 0x80L;
    private long initBits = 0xffL;

    private @Nullable String accessorId;
    private @Nullable String description;
    private ImmutableList.Builder<Token.PolicyLink> policies = ImmutableList.builder();
    private @Nullable BigInteger createIndex;
    private @Nullable BigInteger modifyIndex;
    private boolean local;
    private @Nullable Date createTime;
    private @Nullable String hash;
    private @Nullable String secretId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.kiwiproject.consul.model.acl.TokenResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TokenResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.kiwiproject.consul.model.acl.BaseTokenResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseTokenResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof TokenResponse) {
        TokenResponse instance = (TokenResponse) object;
        this.secretId(instance.secretId());
      }
      if (object instanceof BaseTokenResponse) {
        BaseTokenResponse instance = (BaseTokenResponse) object;
        this.modifyIndex(instance.modifyIndex());
        this.createTime(instance.createTime());
        addAllPolicies(instance.policies());
        this.accessorId(instance.accessorId());
        this.description(instance.description());
        this.createIndex(instance.createIndex());
        this.local(instance.local());
        this.hash(instance.hash());
      }
    }

    /**
     * Initializes the value for the {@link TokenResponse#accessorId() accessorId} attribute.
     * @param accessorId The value for accessorId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("AccessorID")
    public final Builder accessorId(String accessorId) {
      this.accessorId = Objects.requireNonNull(accessorId, "accessorId");
      initBits &= ~INIT_BIT_ACCESSOR_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link TokenResponse#description() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Adds one element to {@link TokenResponse#policies() policies} list.
     * @param element A policies element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPolicies(Token.PolicyLink element) {
      this.policies.add(element);
      return this;
    }

    /**
     * Adds elements to {@link TokenResponse#policies() policies} list.
     * @param elements An array of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPolicies(Token.PolicyLink... elements) {
      this.policies.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TokenResponse#policies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Policies")
    public final Builder policies(Iterable<? extends Token.PolicyLink> elements) {
      this.policies = ImmutableList.builder();
      return addAllPolicies(elements);
    }

    /**
     * Adds elements to {@link TokenResponse#policies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPolicies(Iterable<? extends Token.PolicyLink> elements) {
      this.policies.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link TokenResponse#createIndex() createIndex} attribute.
     * @param createIndex The value for createIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("CreateIndex")
    public final Builder createIndex(BigInteger createIndex) {
      this.createIndex = Objects.requireNonNull(createIndex, "createIndex");
      initBits &= ~INIT_BIT_CREATE_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link TokenResponse#modifyIndex() modifyIndex} attribute.
     * @param modifyIndex The value for modifyIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ModifyIndex")
    public final Builder modifyIndex(BigInteger modifyIndex) {
      this.modifyIndex = Objects.requireNonNull(modifyIndex, "modifyIndex");
      initBits &= ~INIT_BIT_MODIFY_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link TokenResponse#local() local} attribute.
     * @param local The value for local 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Local")
    public final Builder local(boolean local) {
      this.local = local;
      initBits &= ~INIT_BIT_LOCAL;
      return this;
    }

    /**
     * Initializes the value for the {@link TokenResponse#createTime() createTime} attribute.
     * @param createTime The value for createTime 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("CreateTime")
    public final Builder createTime(Date createTime) {
      this.createTime = Objects.requireNonNull(createTime, "createTime");
      initBits &= ~INIT_BIT_CREATE_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link TokenResponse#hash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link TokenResponse#secretId() secretId} attribute.
     * @param secretId The value for secretId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("SecretID")
    public final Builder secretId(String secretId) {
      this.secretId = Objects.requireNonNull(secretId, "secretId");
      initBits &= ~INIT_BIT_SECRET_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTokenResponse ImmutableTokenResponse}.
     * @return An immutable instance of TokenResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTokenResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTokenResponse(
          accessorId,
          description,
          policies.build(),
          createIndex,
          modifyIndex,
          local,
          createTime,
          hash,
          secretId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ACCESSOR_ID) != 0) attributes.add("accessorId");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_CREATE_INDEX) != 0) attributes.add("createIndex");
      if ((initBits & INIT_BIT_MODIFY_INDEX) != 0) attributes.add("modifyIndex");
      if ((initBits & INIT_BIT_LOCAL) != 0) attributes.add("local");
      if ((initBits & INIT_BIT_CREATE_TIME) != 0) attributes.add("createTime");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      if ((initBits & INIT_BIT_SECRET_ID) != 0) attributes.add("secretId");
      return "Cannot build TokenResponse, some of required attributes are not set " + attributes;
    }
  }
}
