package org.kiwiproject.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Agent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAgent.builder()}.
 */
@Generated(from = "Agent", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableAgent extends Agent {
  private final Config config;
  private final org.kiwiproject.consul.model.agent.@Nullable DebugConfig debugConfig;
  private final Member member;
  private final ImmutableMap<String, String> meta;

  private ImmutableAgent(
      Config config,
      org.kiwiproject.consul.model.agent.@Nullable DebugConfig debugConfig,
      Member member,
      ImmutableMap<String, String> meta) {
    this.config = config;
    this.debugConfig = debugConfig;
    this.member = member;
    this.meta = meta;
  }

  /**
   * @return The value of the {@code config} attribute
   */
  @JsonProperty("Config")
  @Override
  public Config getConfig() {
    return config;
  }

  /**
   * @return The value of the {@code debugConfig} attribute
   */
  @JsonProperty("DebugConfig")
  @Override
  public org.kiwiproject.consul.model.agent.@Nullable DebugConfig getDebugConfig() {
    return debugConfig;
  }

  /**
   * @return The value of the {@code member} attribute
   */
  @JsonProperty("Member")
  @Override
  public Member getMember() {
    return member;
  }

  /**
   * @return The value of the {@code meta} attribute
   */
  @JsonProperty("Meta")
  @Override
  public ImmutableMap<String, String> getMeta() {
    return meta;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Agent#getConfig() config} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for config
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAgent withConfig(Config value) {
    if (this.config == value) return this;
    Config newValue = Objects.requireNonNull(value, "config");
    return new ImmutableAgent(newValue, this.debugConfig, this.member, this.meta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Agent#getDebugConfig() debugConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for debugConfig (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAgent withDebugConfig(org.kiwiproject.consul.model.agent.@Nullable DebugConfig value) {
    if (this.debugConfig == value) return this;
    return new ImmutableAgent(this.config, value, this.member, this.meta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Agent#getMember() member} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for member
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAgent withMember(Member value) {
    if (this.member == value) return this;
    Member newValue = Objects.requireNonNull(value, "member");
    return new ImmutableAgent(this.config, this.debugConfig, newValue, this.meta);
  }

  /**
   * Copy the current immutable object by replacing the {@link Agent#getMeta() meta} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the meta map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAgent withMeta(Map<String, ? extends String> entries) {
    if (this.meta == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableAgent(this.config, this.debugConfig, this.member, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAgent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@jakarta.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAgent
        && equalTo(0, (ImmutableAgent) another);
  }

  private boolean equalTo(int synthetic, ImmutableAgent another) {
    return config.equals(another.config)
        && Objects.equals(debugConfig, another.debugConfig)
        && member.equals(another.member)
        && meta.equals(another.meta);
  }

  /**
   * Computes a hash code from attributes: {@code config}, {@code debugConfig}, {@code member}, {@code meta}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + config.hashCode();
    h += (h << 5) + Objects.hashCode(debugConfig);
    h += (h << 5) + member.hashCode();
    h += (h << 5) + meta.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Agent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Agent")
        .omitNullValues()
        .add("config", config)
        .add("debugConfig", debugConfig)
        .add("member", member)
        .add("meta", meta)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Agent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Agent {
    @jakarta.annotation.Nullable Config config;
    @jakarta.annotation.Nullable org.kiwiproject.consul.model.agent.@Nullable DebugConfig debugConfig;
    @jakarta.annotation.Nullable Member member;
    @jakarta.annotation.Nullable Map<String, String> meta = ImmutableMap.of();
    @JsonProperty("Config")
    public void setConfig(Config config) {
      this.config = config;
    }
    @JsonProperty("DebugConfig")
    public void setDebugConfig(org.kiwiproject.consul.model.agent.@Nullable DebugConfig debugConfig) {
      this.debugConfig = debugConfig;
    }
    @JsonProperty("Member")
    public void setMember(Member member) {
      this.member = member;
    }
    @JsonProperty("Meta")
    public void setMeta(Map<String, String> meta) {
      this.meta = meta;
    }
    @Override
    public Config getConfig() { throw new UnsupportedOperationException(); }
    @Override
    public org.kiwiproject.consul.model.agent.@Nullable DebugConfig getDebugConfig() { throw new UnsupportedOperationException(); }
    @Override
    public Member getMember() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getMeta() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAgent fromJson(Json json) {
    ImmutableAgent.Builder builder = ImmutableAgent.builder();
    if (json.config != null) {
      builder.config(json.config);
    }
    if (json.debugConfig != null) {
      builder.debugConfig(json.debugConfig);
    }
    if (json.member != null) {
      builder.member(json.member);
    }
    if (json.meta != null) {
      builder.putAllMeta(json.meta);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Agent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Agent instance
   */
  public static ImmutableAgent copyOf(Agent instance) {
    if (instance instanceof ImmutableAgent) {
      return (ImmutableAgent) instance;
    }
    return ImmutableAgent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAgent ImmutableAgent}.
   * <pre>
   * ImmutableAgent.builder()
   *    .config(org.kiwiproject.consul.model.agent.Config) // required {@link Agent#getConfig() config}
   *    .debugConfig(org.kiwiproject.consul.model.agent.@org.checkerframework.checker.nullness.qual.Nullable DebugConfig | null) // nullable {@link Agent#getDebugConfig() debugConfig}
   *    .member(org.kiwiproject.consul.model.agent.Member) // required {@link Agent#getMember() member}
   *    .putMeta|putAllMeta(String =&gt; String) // {@link Agent#getMeta() meta} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableAgent builder
   */
  public static ImmutableAgent.Builder builder() {
    return new ImmutableAgent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAgent ImmutableAgent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Agent", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONFIG = 0x1L;
    private static final long INIT_BIT_MEMBER = 0x2L;
    private long initBits = 0x3L;

    private @jakarta.annotation.Nullable Config config;
    private @jakarta.annotation.Nullable org.kiwiproject.consul.model.agent.@Nullable DebugConfig debugConfig;
    private @jakarta.annotation.Nullable Member member;
    private ImmutableMap.Builder<String, String> meta = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Agent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Agent instance) {
      Objects.requireNonNull(instance, "instance");
      this.config(instance.getConfig());
      org.kiwiproject.consul.model.agent.@Nullable DebugConfig debugConfigValue = instance.getDebugConfig();
      if (debugConfigValue != null) {
        debugConfig(debugConfigValue);
      }
      this.member(instance.getMember());
      putAllMeta(instance.getMeta());
      return this;
    }

    /**
     * Initializes the value for the {@link Agent#getConfig() config} attribute.
     * @param config The value for config 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Config")
    public final Builder config(Config config) {
      this.config = Objects.requireNonNull(config, "config");
      initBits &= ~INIT_BIT_CONFIG;
      return this;
    }

    /**
     * Initializes the value for the {@link Agent#getDebugConfig() debugConfig} attribute.
     * @param debugConfig The value for debugConfig (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DebugConfig")
    public final Builder debugConfig(org.kiwiproject.consul.model.agent.@Nullable DebugConfig debugConfig) {
      this.debugConfig = debugConfig;
      return this;
    }

    /**
     * Initializes the value for the {@link Agent#getMember() member} attribute.
     * @param member The value for member 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Member")
    public final Builder member(Member member) {
      this.member = Objects.requireNonNull(member, "member");
      initBits &= ~INIT_BIT_MEMBER;
      return this;
    }

    /**
     * Put one entry to the {@link Agent#getMeta() meta} map.
     * @param key The key in the meta map
     * @param value The associated value in the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMeta(String key, String value) {
      this.meta.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Agent#getMeta() meta} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMeta(Map.Entry<String, ? extends String> entry) {
      this.meta.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Agent#getMeta() meta} map. Nulls are not permitted
     * @param entries The entries that will be added to the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Meta")
    public final Builder meta(Map<String, ? extends String> entries) {
      this.meta = ImmutableMap.builder();
      return putAllMeta(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Agent#getMeta() meta} map. Nulls are not permitted
     * @param entries The entries that will be added to the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMeta(Map<String, ? extends String> entries) {
      this.meta.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableAgent ImmutableAgent}.
     * @return An immutable instance of Agent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAgent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAgent(config, debugConfig, member, meta.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONFIG) != 0) attributes.add("config");
      if ((initBits & INIT_BIT_MEMBER) != 0) attributes.add("member");
      return "Cannot build Agent, some of required attributes are not set " + attributes;
    }
  }
}
