package org.kiwiproject.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Member}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMember.builder()}.
 */
@Generated(from = "Member", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableMember extends Member {
  private final String name;
  private final String address;
  private final int port;
  private final ImmutableMap<String, String> tags;
  private final int status;
  private final int protocolMin;
  private final int protocolMax;
  private final int protocolCur;
  private final int delegateMin;
  private final int delegateMax;
  private final int delegateCur;

  private ImmutableMember(
      String name,
      String address,
      int port,
      ImmutableMap<String, String> tags,
      int status,
      int protocolMin,
      int protocolMax,
      int protocolCur,
      int delegateMin,
      int delegateMax,
      int delegateCur) {
    this.name = name;
    this.address = address;
    this.port = port;
    this.tags = tags;
    this.status = status;
    this.protocolMin = protocolMin;
    this.protocolMax = protocolMax;
    this.protocolCur = protocolCur;
    this.delegateMin = delegateMin;
    this.delegateMax = delegateMax;
    this.delegateCur = delegateCur;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code address} attribute
   */
  @JsonProperty("Addr")
  @Override
  public String getAddress() {
    return address;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @JsonProperty("Port")
  @Override
  public int getPort() {
    return port;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty("Tags")
  @JsonDeserialize(as = ImmutableMap.class, keyAs = String.class, contentAs = String.class)
  @Override
  public ImmutableMap<String, String> getTags() {
    return tags;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("Status")
  @Override
  public int getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code protocolMin} attribute
   */
  @JsonProperty("ProtocolMin")
  @Override
  public int getProtocolMin() {
    return protocolMin;
  }

  /**
   * @return The value of the {@code protocolMax} attribute
   */
  @JsonProperty("ProtocolMax")
  @Override
  public int getProtocolMax() {
    return protocolMax;
  }

  /**
   * @return The value of the {@code protocolCur} attribute
   */
  @JsonProperty("ProtocolCur")
  @Override
  public int getProtocolCur() {
    return protocolCur;
  }

  /**
   * @return The value of the {@code delegateMin} attribute
   */
  @JsonProperty("DelegateMin")
  @Override
  public int getDelegateMin() {
    return delegateMin;
  }

  /**
   * @return The value of the {@code delegateMax} attribute
   */
  @JsonProperty("DelegateMax")
  @Override
  public int getDelegateMax() {
    return delegateMax;
  }

  /**
   * @return The value of the {@code delegateCur} attribute
   */
  @JsonProperty("DelegateCur")
  @Override
  public int getDelegateCur() {
    return delegateCur;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableMember(
        newValue,
        this.address,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#getAddress() address} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for address
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withAddress(String value) {
    String newValue = Objects.requireNonNull(value, "address");
    if (this.address.equals(newValue)) return this;
    return new ImmutableMember(
        this.name,
        newValue,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#getPort() port} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withPort(int value) {
    if (this.port == value) return this;
    return new ImmutableMember(
        this.name,
        this.address,
        value,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }

  /**
   * Copy the current immutable object by replacing the {@link Member#getTags() tags} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the tags map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMember withTags(Map<String, ? extends String> entries) {
    if (this.tags == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        newValue,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withStatus(int value) {
    if (this.status == value) return this;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        value,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#getProtocolMin() protocolMin} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for protocolMin
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withProtocolMin(int value) {
    if (this.protocolMin == value) return this;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        this.status,
        value,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#getProtocolMax() protocolMax} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for protocolMax
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withProtocolMax(int value) {
    if (this.protocolMax == value) return this;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        value,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#getProtocolCur() protocolCur} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for protocolCur
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withProtocolCur(int value) {
    if (this.protocolCur == value) return this;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        value,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#getDelegateMin() delegateMin} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegateMin
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withDelegateMin(int value) {
    if (this.delegateMin == value) return this;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        value,
        this.delegateMax,
        this.delegateCur);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#getDelegateMax() delegateMax} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegateMax
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withDelegateMax(int value) {
    if (this.delegateMax == value) return this;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        value,
        this.delegateCur);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#getDelegateCur() delegateCur} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegateCur
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withDelegateCur(int value) {
    if (this.delegateCur == value) return this;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMember} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMember
        && equalTo(0, (ImmutableMember) another);
  }

  private boolean equalTo(int synthetic, ImmutableMember another) {
    return name.equals(another.name)
        && address.equals(another.address)
        && port == another.port
        && tags.equals(another.tags)
        && status == another.status
        && protocolMin == another.protocolMin
        && protocolMax == another.protocolMax
        && protocolCur == another.protocolCur
        && delegateMin == another.delegateMin
        && delegateMax == another.delegateMax
        && delegateCur == another.delegateCur;
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code address}, {@code port}, {@code tags}, {@code status}, {@code protocolMin}, {@code protocolMax}, {@code protocolCur}, {@code delegateMin}, {@code delegateMax}, {@code delegateCur}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + address.hashCode();
    h += (h << 5) + port;
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + status;
    h += (h << 5) + protocolMin;
    h += (h << 5) + protocolMax;
    h += (h << 5) + protocolCur;
    h += (h << 5) + delegateMin;
    h += (h << 5) + delegateMax;
    h += (h << 5) + delegateCur;
    return h;
  }

  /**
   * Prints the immutable value {@code Member} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Member")
        .omitNullValues()
        .add("name", name)
        .add("address", address)
        .add("port", port)
        .add("tags", tags)
        .add("status", status)
        .add("protocolMin", protocolMin)
        .add("protocolMax", protocolMax)
        .add("protocolCur", protocolCur)
        .add("delegateMin", delegateMin)
        .add("delegateMax", delegateMax)
        .add("delegateCur", delegateCur)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Member", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Member {
    @Nullable String name;
    @Nullable String address;
    int port;
    boolean portIsSet;
    @Nullable Map<String, String> tags = ImmutableMap.of();
    int status;
    boolean statusIsSet;
    int protocolMin;
    boolean protocolMinIsSet;
    int protocolMax;
    boolean protocolMaxIsSet;
    int protocolCur;
    boolean protocolCurIsSet;
    int delegateMin;
    boolean delegateMinIsSet;
    int delegateMax;
    boolean delegateMaxIsSet;
    int delegateCur;
    boolean delegateCurIsSet;
    @JsonProperty("Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("Addr")
    public void setAddress(String address) {
      this.address = address;
    }
    @JsonProperty("Port")
    public void setPort(int port) {
      this.port = port;
      this.portIsSet = true;
    }
    @JsonProperty("Tags")
    @JsonDeserialize(as = ImmutableMap.class, keyAs = String.class, contentAs = String.class)
    public void setTags(Map<String, String> tags) {
      this.tags = tags;
    }
    @JsonProperty("Status")
    public void setStatus(int status) {
      this.status = status;
      this.statusIsSet = true;
    }
    @JsonProperty("ProtocolMin")
    public void setProtocolMin(int protocolMin) {
      this.protocolMin = protocolMin;
      this.protocolMinIsSet = true;
    }
    @JsonProperty("ProtocolMax")
    public void setProtocolMax(int protocolMax) {
      this.protocolMax = protocolMax;
      this.protocolMaxIsSet = true;
    }
    @JsonProperty("ProtocolCur")
    public void setProtocolCur(int protocolCur) {
      this.protocolCur = protocolCur;
      this.protocolCurIsSet = true;
    }
    @JsonProperty("DelegateMin")
    public void setDelegateMin(int delegateMin) {
      this.delegateMin = delegateMin;
      this.delegateMinIsSet = true;
    }
    @JsonProperty("DelegateMax")
    public void setDelegateMax(int delegateMax) {
      this.delegateMax = delegateMax;
      this.delegateMaxIsSet = true;
    }
    @JsonProperty("DelegateCur")
    public void setDelegateCur(int delegateCur) {
      this.delegateCur = delegateCur;
      this.delegateCurIsSet = true;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getAddress() { throw new UnsupportedOperationException(); }
    @Override
    public int getPort() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public int getStatus() { throw new UnsupportedOperationException(); }
    @Override
    public int getProtocolMin() { throw new UnsupportedOperationException(); }
    @Override
    public int getProtocolMax() { throw new UnsupportedOperationException(); }
    @Override
    public int getProtocolCur() { throw new UnsupportedOperationException(); }
    @Override
    public int getDelegateMin() { throw new UnsupportedOperationException(); }
    @Override
    public int getDelegateMax() { throw new UnsupportedOperationException(); }
    @Override
    public int getDelegateCur() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMember fromJson(Json json) {
    ImmutableMember.Builder builder = ImmutableMember.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.address != null) {
      builder.address(json.address);
    }
    if (json.portIsSet) {
      builder.port(json.port);
    }
    if (json.tags != null) {
      builder.putAllTags(json.tags);
    }
    if (json.statusIsSet) {
      builder.status(json.status);
    }
    if (json.protocolMinIsSet) {
      builder.protocolMin(json.protocolMin);
    }
    if (json.protocolMaxIsSet) {
      builder.protocolMax(json.protocolMax);
    }
    if (json.protocolCurIsSet) {
      builder.protocolCur(json.protocolCur);
    }
    if (json.delegateMinIsSet) {
      builder.delegateMin(json.delegateMin);
    }
    if (json.delegateMaxIsSet) {
      builder.delegateMax(json.delegateMax);
    }
    if (json.delegateCurIsSet) {
      builder.delegateCur(json.delegateCur);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Member} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Member instance
   */
  public static ImmutableMember copyOf(Member instance) {
    if (instance instanceof ImmutableMember) {
      return (ImmutableMember) instance;
    }
    return ImmutableMember.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMember ImmutableMember}.
   * <pre>
   * ImmutableMember.builder()
   *    .name(String) // required {@link Member#getName() name}
   *    .address(String) // required {@link Member#getAddress() address}
   *    .port(int) // required {@link Member#getPort() port}
   *    .putTags|putAllTags(String =&gt; String) // {@link Member#getTags() tags} mappings
   *    .status(int) // required {@link Member#getStatus() status}
   *    .protocolMin(int) // required {@link Member#getProtocolMin() protocolMin}
   *    .protocolMax(int) // required {@link Member#getProtocolMax() protocolMax}
   *    .protocolCur(int) // required {@link Member#getProtocolCur() protocolCur}
   *    .delegateMin(int) // required {@link Member#getDelegateMin() delegateMin}
   *    .delegateMax(int) // required {@link Member#getDelegateMax() delegateMax}
   *    .delegateCur(int) // required {@link Member#getDelegateCur() delegateCur}
   *    .build();
   * </pre>
   * @return A new ImmutableMember builder
   */
  public static ImmutableMember.Builder builder() {
    return new ImmutableMember.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMember ImmutableMember}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Member", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_ADDRESS = 0x2L;
    private static final long INIT_BIT_PORT = 0x4L;
    private static final long INIT_BIT_STATUS = 0x8L;
    private static final long INIT_BIT_PROTOCOL_MIN = 0x10L;
    private static final long INIT_BIT_PROTOCOL_MAX = 0x20L;
    private static final long INIT_BIT_PROTOCOL_CUR = 0x40L;
    private static final long INIT_BIT_DELEGATE_MIN = 0x80L;
    private static final long INIT_BIT_DELEGATE_MAX = 0x100L;
    private static final long INIT_BIT_DELEGATE_CUR = 0x200L;
    private long initBits = 0x3ffL;

    private @Nullable String name;
    private @Nullable String address;
    private int port;
    private ImmutableMap.Builder<String, String> tags = ImmutableMap.builder();
    private int status;
    private int protocolMin;
    private int protocolMax;
    private int protocolCur;
    private int delegateMin;
    private int delegateMax;
    private int delegateCur;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Member} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Member instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.address(instance.getAddress());
      this.port(instance.getPort());
      putAllTags(instance.getTags());
      this.status(instance.getStatus());
      this.protocolMin(instance.getProtocolMin());
      this.protocolMax(instance.getProtocolMax());
      this.protocolCur(instance.getProtocolCur());
      this.delegateMin(instance.getDelegateMin());
      this.delegateMax(instance.getDelegateMax());
      this.delegateCur(instance.getDelegateCur());
      return this;
    }

    /**
     * Initializes the value for the {@link Member#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#getAddress() address} attribute.
     * @param address The value for address 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Addr")
    public final Builder address(String address) {
      this.address = Objects.requireNonNull(address, "address");
      initBits &= ~INIT_BIT_ADDRESS;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#getPort() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Port")
    public final Builder port(int port) {
      this.port = port;
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Put one entry to the {@link Member#getTags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTags(String key, String value) {
      this.tags.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Member#getTags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTags(Map.Entry<String, ? extends String> entry) {
      this.tags.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Member#getTags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Tags")
    @JsonDeserialize(as = ImmutableMap.class, keyAs = String.class, contentAs = String.class)
    public final Builder tags(Map<String, ? extends String> entries) {
      this.tags = ImmutableMap.builder();
      return putAllTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Member#getTags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllTags(Map<String, ? extends String> entries) {
      this.tags.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link Member#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Status")
    public final Builder status(int status) {
      this.status = status;
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#getProtocolMin() protocolMin} attribute.
     * @param protocolMin The value for protocolMin 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ProtocolMin")
    public final Builder protocolMin(int protocolMin) {
      this.protocolMin = protocolMin;
      initBits &= ~INIT_BIT_PROTOCOL_MIN;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#getProtocolMax() protocolMax} attribute.
     * @param protocolMax The value for protocolMax 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ProtocolMax")
    public final Builder protocolMax(int protocolMax) {
      this.protocolMax = protocolMax;
      initBits &= ~INIT_BIT_PROTOCOL_MAX;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#getProtocolCur() protocolCur} attribute.
     * @param protocolCur The value for protocolCur 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ProtocolCur")
    public final Builder protocolCur(int protocolCur) {
      this.protocolCur = protocolCur;
      initBits &= ~INIT_BIT_PROTOCOL_CUR;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#getDelegateMin() delegateMin} attribute.
     * @param delegateMin The value for delegateMin 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DelegateMin")
    public final Builder delegateMin(int delegateMin) {
      this.delegateMin = delegateMin;
      initBits &= ~INIT_BIT_DELEGATE_MIN;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#getDelegateMax() delegateMax} attribute.
     * @param delegateMax The value for delegateMax 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DelegateMax")
    public final Builder delegateMax(int delegateMax) {
      this.delegateMax = delegateMax;
      initBits &= ~INIT_BIT_DELEGATE_MAX;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#getDelegateCur() delegateCur} attribute.
     * @param delegateCur The value for delegateCur 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DelegateCur")
    public final Builder delegateCur(int delegateCur) {
      this.delegateCur = delegateCur;
      initBits &= ~INIT_BIT_DELEGATE_CUR;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMember ImmutableMember}.
     * @return An immutable instance of Member
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMember build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMember(
          name,
          address,
          port,
          tags.build(),
          status,
          protocolMin,
          protocolMax,
          protocolCur,
          delegateMin,
          delegateMax,
          delegateCur);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ADDRESS) != 0) attributes.add("address");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      if ((initBits & INIT_BIT_PROTOCOL_MIN) != 0) attributes.add("protocolMin");
      if ((initBits & INIT_BIT_PROTOCOL_MAX) != 0) attributes.add("protocolMax");
      if ((initBits & INIT_BIT_PROTOCOL_CUR) != 0) attributes.add("protocolCur");
      if ((initBits & INIT_BIT_DELEGATE_MIN) != 0) attributes.add("delegateMin");
      if ((initBits & INIT_BIT_DELEGATE_MAX) != 0) attributes.add("delegateMax");
      if ((initBits & INIT_BIT_DELEGATE_CUR) != 0) attributes.add("delegateCur");
      return "Cannot build Member, some of required attributes are not set " + attributes;
    }
  }
}
