package org.kiwiproject.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ServiceProxyUpstream}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableServiceProxyUpstream.builder()}.
 */
@Generated(from = "ServiceProxyUpstream", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableServiceProxyUpstream
    extends ServiceProxyUpstream {
  private final String destinationType;
  private final String destinationName;
  private final int localBindPort;

  private ImmutableServiceProxyUpstream(String destinationType, String destinationName, int localBindPort) {
    this.destinationType = destinationType;
    this.destinationName = destinationName;
    this.localBindPort = localBindPort;
  }

  /**
   * @return The value of the {@code destinationType} attribute
   */
  @JsonProperty("DestinationType")
  @Override
  public String getDestinationType() {
    return destinationType;
  }

  /**
   * @return The value of the {@code destinationName} attribute
   */
  @JsonProperty("DestinationName")
  @Override
  public String getDestinationName() {
    return destinationName;
  }

  /**
   * @return The value of the {@code localBindPort} attribute
   */
  @JsonProperty("LocalBindPort")
  @Override
  public int getLocalBindPort() {
    return localBindPort;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceProxyUpstream#getDestinationType() destinationType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destinationType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceProxyUpstream withDestinationType(String value) {
    String newValue = Objects.requireNonNull(value, "destinationType");
    if (this.destinationType.equals(newValue)) return this;
    return new ImmutableServiceProxyUpstream(newValue, this.destinationName, this.localBindPort);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceProxyUpstream#getDestinationName() destinationName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destinationName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceProxyUpstream withDestinationName(String value) {
    String newValue = Objects.requireNonNull(value, "destinationName");
    if (this.destinationName.equals(newValue)) return this;
    return new ImmutableServiceProxyUpstream(this.destinationType, newValue, this.localBindPort);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceProxyUpstream#getLocalBindPort() localBindPort} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for localBindPort
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceProxyUpstream withLocalBindPort(int value) {
    if (this.localBindPort == value) return this;
    return new ImmutableServiceProxyUpstream(this.destinationType, this.destinationName, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableServiceProxyUpstream} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableServiceProxyUpstream
        && equalTo(0, (ImmutableServiceProxyUpstream) another);
  }

  private boolean equalTo(int synthetic, ImmutableServiceProxyUpstream another) {
    return destinationType.equals(another.destinationType)
        && destinationName.equals(another.destinationName)
        && localBindPort == another.localBindPort;
  }

  /**
   * Computes a hash code from attributes: {@code destinationType}, {@code destinationName}, {@code localBindPort}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destinationType.hashCode();
    h += (h << 5) + destinationName.hashCode();
    h += (h << 5) + localBindPort;
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceProxyUpstream} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ServiceProxyUpstream")
        .omitNullValues()
        .add("destinationType", destinationType)
        .add("destinationName", destinationName)
        .add("localBindPort", localBindPort)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ServiceProxyUpstream", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends ServiceProxyUpstream {
    @Nullable String destinationType;
    @Nullable String destinationName;
    int localBindPort;
    boolean localBindPortIsSet;
    @JsonProperty("DestinationType")
    public void setDestinationType(String destinationType) {
      this.destinationType = destinationType;
    }
    @JsonProperty("DestinationName")
    public void setDestinationName(String destinationName) {
      this.destinationName = destinationName;
    }
    @JsonProperty("LocalBindPort")
    public void setLocalBindPort(int localBindPort) {
      this.localBindPort = localBindPort;
      this.localBindPortIsSet = true;
    }
    @Override
    public String getDestinationType() { throw new UnsupportedOperationException(); }
    @Override
    public String getDestinationName() { throw new UnsupportedOperationException(); }
    @Override
    public int getLocalBindPort() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableServiceProxyUpstream fromJson(Json json) {
    ImmutableServiceProxyUpstream.Builder builder = ImmutableServiceProxyUpstream.builder();
    if (json.destinationType != null) {
      builder.destinationType(json.destinationType);
    }
    if (json.destinationName != null) {
      builder.destinationName(json.destinationName);
    }
    if (json.localBindPortIsSet) {
      builder.localBindPort(json.localBindPort);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ServiceProxyUpstream} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ServiceProxyUpstream instance
   */
  public static ImmutableServiceProxyUpstream copyOf(ServiceProxyUpstream instance) {
    if (instance instanceof ImmutableServiceProxyUpstream) {
      return (ImmutableServiceProxyUpstream) instance;
    }
    return ImmutableServiceProxyUpstream.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableServiceProxyUpstream ImmutableServiceProxyUpstream}.
   * <pre>
   * ImmutableServiceProxyUpstream.builder()
   *    .destinationType(String) // required {@link ServiceProxyUpstream#getDestinationType() destinationType}
   *    .destinationName(String) // required {@link ServiceProxyUpstream#getDestinationName() destinationName}
   *    .localBindPort(int) // required {@link ServiceProxyUpstream#getLocalBindPort() localBindPort}
   *    .build();
   * </pre>
   * @return A new ImmutableServiceProxyUpstream builder
   */
  public static ImmutableServiceProxyUpstream.Builder builder() {
    return new ImmutableServiceProxyUpstream.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableServiceProxyUpstream ImmutableServiceProxyUpstream}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ServiceProxyUpstream", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DESTINATION_TYPE = 0x1L;
    private static final long INIT_BIT_DESTINATION_NAME = 0x2L;
    private static final long INIT_BIT_LOCAL_BIND_PORT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String destinationType;
    private @Nullable String destinationName;
    private int localBindPort;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceProxyUpstream} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ServiceProxyUpstream instance) {
      Objects.requireNonNull(instance, "instance");
      this.destinationType(instance.getDestinationType());
      this.destinationName(instance.getDestinationName());
      this.localBindPort(instance.getLocalBindPort());
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceProxyUpstream#getDestinationType() destinationType} attribute.
     * @param destinationType The value for destinationType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DestinationType")
    public final Builder destinationType(String destinationType) {
      this.destinationType = Objects.requireNonNull(destinationType, "destinationType");
      initBits &= ~INIT_BIT_DESTINATION_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceProxyUpstream#getDestinationName() destinationName} attribute.
     * @param destinationName The value for destinationName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DestinationName")
    public final Builder destinationName(String destinationName) {
      this.destinationName = Objects.requireNonNull(destinationName, "destinationName");
      initBits &= ~INIT_BIT_DESTINATION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceProxyUpstream#getLocalBindPort() localBindPort} attribute.
     * @param localBindPort The value for localBindPort 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("LocalBindPort")
    public final Builder localBindPort(int localBindPort) {
      this.localBindPort = localBindPort;
      initBits &= ~INIT_BIT_LOCAL_BIND_PORT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableServiceProxyUpstream ImmutableServiceProxyUpstream}.
     * @return An immutable instance of ServiceProxyUpstream
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableServiceProxyUpstream build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableServiceProxyUpstream(destinationType, destinationName, localBindPort);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DESTINATION_TYPE) != 0) attributes.add("destinationType");
      if ((initBits & INIT_BIT_DESTINATION_NAME) != 0) attributes.add("destinationName");
      if ((initBits & INIT_BIT_LOCAL_BIND_PORT) != 0) attributes.add("localBindPort");
      return "Cannot build ServiceProxyUpstream, some of required attributes are not set " + attributes;
    }
  }
}
