package org.kiwiproject.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CatalogService}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCatalogService.builder()}.
 */
@Generated(from = "CatalogService", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableCatalogService extends CatalogService {
  private final String node;
  private final String address;
  private final @Nullable String datacenter;
  private final String serviceName;
  private final String serviceId;
  private final String serviceAddress;
  private final @Nullable Boolean serviceEnableTagOverride;
  private final int servicePort;
  private final ImmutableList<String> serviceTags;
  private final ImmutableMap<String, String> serviceMeta;
  private final @Nullable ServiceWeights serviceWeights;
  private final ImmutableMap<String, String> nodeMeta;

  private ImmutableCatalogService(
      String node,
      String address,
      @Nullable String datacenter,
      String serviceName,
      String serviceId,
      String serviceAddress,
      @Nullable Boolean serviceEnableTagOverride,
      int servicePort,
      ImmutableList<String> serviceTags,
      ImmutableMap<String, String> serviceMeta,
      @Nullable ServiceWeights serviceWeights,
      ImmutableMap<String, String> nodeMeta) {
    this.node = node;
    this.address = address;
    this.datacenter = datacenter;
    this.serviceName = serviceName;
    this.serviceId = serviceId;
    this.serviceAddress = serviceAddress;
    this.serviceEnableTagOverride = serviceEnableTagOverride;
    this.servicePort = servicePort;
    this.serviceTags = serviceTags;
    this.serviceMeta = serviceMeta;
    this.serviceWeights = serviceWeights;
    this.nodeMeta = nodeMeta;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public String getNode() {
    return node;
  }

  /**
   * @return The value of the {@code address} attribute
   */
  @JsonProperty("Address")
  @Override
  public String getAddress() {
    return address;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @JsonProperty("Datacenter")
  @Override
  public Optional<String> getDatacenter() {
    return Optional.ofNullable(datacenter);
  }

  /**
   * @return The value of the {@code serviceName} attribute
   */
  @JsonProperty("ServiceName")
  @Override
  public String getServiceName() {
    return serviceName;
  }

  /**
   * @return The value of the {@code serviceId} attribute
   */
  @JsonProperty("ServiceID")
  @Override
  public String getServiceId() {
    return serviceId;
  }

  /**
   * @return The value of the {@code serviceAddress} attribute
   */
  @JsonProperty("ServiceAddress")
  @Override
  public String getServiceAddress() {
    return serviceAddress;
  }

  /**
   * @return The value of the {@code serviceEnableTagOverride} attribute
   */
  @JsonProperty("ServiceEnableTagOverride")
  @Override
  public Optional<Boolean> getServiceEnableTagOverride() {
    return Optional.ofNullable(serviceEnableTagOverride);
  }

  /**
   * @return The value of the {@code servicePort} attribute
   */
  @JsonProperty("ServicePort")
  @Override
  public int getServicePort() {
    return servicePort;
  }

  /**
   * @return The value of the {@code serviceTags} attribute
   */
  @JsonProperty("ServiceTags")
  @Override
  public ImmutableList<String> getServiceTags() {
    return serviceTags;
  }

  /**
   * @return The value of the {@code serviceMeta} attribute
   */
  @JsonProperty("ServiceMeta")
  @Override
  public ImmutableMap<String, String> getServiceMeta() {
    return serviceMeta;
  }

  /**
   * @return The value of the {@code serviceWeights} attribute
   */
  @JsonProperty("ServiceWeights")
  @Override
  public Optional<ServiceWeights> getServiceWeights() {
    return Optional.ofNullable(serviceWeights);
  }

  /**
   * @return The value of the {@code nodeMeta} attribute
   */
  @JsonProperty("NodeMeta")
  @Override
  public ImmutableMap<String, String> getNodeMeta() {
    return nodeMeta;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogService#getNode() node} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withNode(String value) {
    String newValue = Objects.requireNonNull(value, "node");
    if (this.node.equals(newValue)) return this;
    return new ImmutableCatalogService(
        newValue,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogService#getAddress() address} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for address
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withAddress(String value) {
    String newValue = Objects.requireNonNull(value, "address");
    if (this.address.equals(newValue)) return this;
    return new ImmutableCatalogService(
        this.node,
        newValue,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogService#getDatacenter() datacenter} attribute.
   * @param value The value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withDatacenter(String value) {
    String newValue = Objects.requireNonNull(value, "datacenter");
    if (Objects.equals(this.datacenter, newValue)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        newValue,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogService#getDatacenter() datacenter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withDatacenter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.datacenter, value)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        value,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogService#getServiceName() serviceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serviceName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withServiceName(String value) {
    String newValue = Objects.requireNonNull(value, "serviceName");
    if (this.serviceName.equals(newValue)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        newValue,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogService#getServiceId() serviceId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serviceId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withServiceId(String value) {
    String newValue = Objects.requireNonNull(value, "serviceId");
    if (this.serviceId.equals(newValue)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        newValue,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogService#getServiceAddress() serviceAddress} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serviceAddress
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withServiceAddress(String value) {
    String newValue = Objects.requireNonNull(value, "serviceAddress");
    if (this.serviceAddress.equals(newValue)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        newValue,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogService#getServiceEnableTagOverride() serviceEnableTagOverride} attribute.
   * @param value The value for serviceEnableTagOverride
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceEnableTagOverride(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.serviceEnableTagOverride, newValue)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        newValue,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogService#getServiceEnableTagOverride() serviceEnableTagOverride} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceEnableTagOverride
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceEnableTagOverride(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.serviceEnableTagOverride, value)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        value,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogService#getServicePort() servicePort} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for servicePort
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withServicePort(int value) {
    if (this.servicePort == value) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        value,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CatalogService#getServiceTags() serviceTags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceTags(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        newValue,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CatalogService#getServiceTags() serviceTags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of serviceTags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceTags(Iterable<String> elements) {
    if (this.serviceTags == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        newValue,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by replacing the {@link CatalogService#getServiceMeta() serviceMeta} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the serviceMeta map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceMeta(Map<String, ? extends String> entries) {
    if (this.serviceMeta == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        newValue,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogService#getServiceWeights() serviceWeights} attribute.
   * @param value The value for serviceWeights
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceWeights(ServiceWeights value) {
    ServiceWeights newValue = Objects.requireNonNull(value, "serviceWeights");
    if (this.serviceWeights == newValue) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        newValue,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogService#getServiceWeights() serviceWeights} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceWeights
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCatalogService withServiceWeights(Optional<? extends ServiceWeights> optional) {
    @Nullable ServiceWeights value = optional.orElse(null);
    if (this.serviceWeights == value) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        value,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by replacing the {@link CatalogService#getNodeMeta() nodeMeta} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the nodeMeta map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withNodeMeta(Map<String, ? extends String> entries) {
    if (this.nodeMeta == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCatalogService} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCatalogService
        && equalTo(0, (ImmutableCatalogService) another);
  }

  private boolean equalTo(int synthetic, ImmutableCatalogService another) {
    return node.equals(another.node)
        && address.equals(another.address)
        && Objects.equals(datacenter, another.datacenter)
        && serviceName.equals(another.serviceName)
        && serviceId.equals(another.serviceId)
        && serviceAddress.equals(another.serviceAddress)
        && Objects.equals(serviceEnableTagOverride, another.serviceEnableTagOverride)
        && servicePort == another.servicePort
        && serviceTags.equals(another.serviceTags)
        && serviceMeta.equals(another.serviceMeta)
        && Objects.equals(serviceWeights, another.serviceWeights)
        && nodeMeta.equals(another.nodeMeta);
  }

  /**
   * Computes a hash code from attributes: {@code node}, {@code address}, {@code datacenter}, {@code serviceName}, {@code serviceId}, {@code serviceAddress}, {@code serviceEnableTagOverride}, {@code servicePort}, {@code serviceTags}, {@code serviceMeta}, {@code serviceWeights}, {@code nodeMeta}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + node.hashCode();
    h += (h << 5) + address.hashCode();
    h += (h << 5) + Objects.hashCode(datacenter);
    h += (h << 5) + serviceName.hashCode();
    h += (h << 5) + serviceId.hashCode();
    h += (h << 5) + serviceAddress.hashCode();
    h += (h << 5) + Objects.hashCode(serviceEnableTagOverride);
    h += (h << 5) + servicePort;
    h += (h << 5) + serviceTags.hashCode();
    h += (h << 5) + serviceMeta.hashCode();
    h += (h << 5) + Objects.hashCode(serviceWeights);
    h += (h << 5) + nodeMeta.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CatalogService} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CatalogService")
        .omitNullValues()
        .add("node", node)
        .add("address", address)
        .add("datacenter", datacenter)
        .add("serviceName", serviceName)
        .add("serviceId", serviceId)
        .add("serviceAddress", serviceAddress)
        .add("serviceEnableTagOverride", serviceEnableTagOverride)
        .add("servicePort", servicePort)
        .add("serviceTags", serviceTags)
        .add("serviceMeta", serviceMeta)
        .add("serviceWeights", serviceWeights)
        .add("nodeMeta", nodeMeta)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CatalogService", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends CatalogService {
    @Nullable String node;
    @Nullable String address;
    @Nullable Optional<String> datacenter = Optional.empty();
    @Nullable String serviceName;
    @Nullable String serviceId;
    @Nullable String serviceAddress;
    @Nullable Optional<Boolean> serviceEnableTagOverride = Optional.empty();
    int servicePort;
    boolean servicePortIsSet;
    @Nullable List<String> serviceTags = ImmutableList.of();
    @Nullable Map<String, String> serviceMeta = ImmutableMap.of();
    @Nullable Optional<ServiceWeights> serviceWeights = Optional.empty();
    @Nullable Map<String, String> nodeMeta = ImmutableMap.of();
    @JsonProperty("Node")
    public void setNode(String node) {
      this.node = node;
    }
    @JsonProperty("Address")
    public void setAddress(String address) {
      this.address = address;
    }
    @JsonProperty("Datacenter")
    public void setDatacenter(Optional<String> datacenter) {
      this.datacenter = datacenter;
    }
    @JsonProperty("ServiceName")
    public void setServiceName(String serviceName) {
      this.serviceName = serviceName;
    }
    @JsonProperty("ServiceID")
    public void setServiceId(String serviceId) {
      this.serviceId = serviceId;
    }
    @JsonProperty("ServiceAddress")
    public void setServiceAddress(String serviceAddress) {
      this.serviceAddress = serviceAddress;
    }
    @JsonProperty("ServiceEnableTagOverride")
    public void setServiceEnableTagOverride(Optional<Boolean> serviceEnableTagOverride) {
      this.serviceEnableTagOverride = serviceEnableTagOverride;
    }
    @JsonProperty("ServicePort")
    public void setServicePort(int servicePort) {
      this.servicePort = servicePort;
      this.servicePortIsSet = true;
    }
    @JsonProperty("ServiceTags")
    public void setServiceTags(List<String> serviceTags) {
      this.serviceTags = serviceTags;
    }
    @JsonProperty("ServiceMeta")
    public void setServiceMeta(Map<String, String> serviceMeta) {
      this.serviceMeta = serviceMeta;
    }
    @JsonProperty("ServiceWeights")
    public void setServiceWeights(Optional<ServiceWeights> serviceWeights) {
      this.serviceWeights = serviceWeights;
    }
    @JsonProperty("NodeMeta")
    public void setNodeMeta(Map<String, String> nodeMeta) {
      this.nodeMeta = nodeMeta;
    }
    @Override
    public String getNode() { throw new UnsupportedOperationException(); }
    @Override
    public String getAddress() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getDatacenter() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceName() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceAddress() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getServiceEnableTagOverride() { throw new UnsupportedOperationException(); }
    @Override
    public int getServicePort() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getServiceTags() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getServiceMeta() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ServiceWeights> getServiceWeights() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getNodeMeta() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCatalogService fromJson(Json json) {
    ImmutableCatalogService.Builder builder = ImmutableCatalogService.builder();
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.address != null) {
      builder.address(json.address);
    }
    if (json.datacenter != null) {
      builder.datacenter(json.datacenter);
    }
    if (json.serviceName != null) {
      builder.serviceName(json.serviceName);
    }
    if (json.serviceId != null) {
      builder.serviceId(json.serviceId);
    }
    if (json.serviceAddress != null) {
      builder.serviceAddress(json.serviceAddress);
    }
    if (json.serviceEnableTagOverride != null) {
      builder.serviceEnableTagOverride(json.serviceEnableTagOverride);
    }
    if (json.servicePortIsSet) {
      builder.servicePort(json.servicePort);
    }
    if (json.serviceTags != null) {
      builder.addAllServiceTags(json.serviceTags);
    }
    if (json.serviceMeta != null) {
      builder.putAllServiceMeta(json.serviceMeta);
    }
    if (json.serviceWeights != null) {
      builder.serviceWeights(json.serviceWeights);
    }
    if (json.nodeMeta != null) {
      builder.putAllNodeMeta(json.nodeMeta);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CatalogService} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CatalogService instance
   */
  public static ImmutableCatalogService copyOf(CatalogService instance) {
    if (instance instanceof ImmutableCatalogService) {
      return (ImmutableCatalogService) instance;
    }
    return ImmutableCatalogService.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCatalogService ImmutableCatalogService}.
   * <pre>
   * ImmutableCatalogService.builder()
   *    .node(String) // required {@link CatalogService#getNode() node}
   *    .address(String) // required {@link CatalogService#getAddress() address}
   *    .datacenter(String) // optional {@link CatalogService#getDatacenter() datacenter}
   *    .serviceName(String) // required {@link CatalogService#getServiceName() serviceName}
   *    .serviceId(String) // required {@link CatalogService#getServiceId() serviceId}
   *    .serviceAddress(String) // required {@link CatalogService#getServiceAddress() serviceAddress}
   *    .serviceEnableTagOverride(Boolean) // optional {@link CatalogService#getServiceEnableTagOverride() serviceEnableTagOverride}
   *    .servicePort(int) // required {@link CatalogService#getServicePort() servicePort}
   *    .addServiceTags|addAllServiceTags(String) // {@link CatalogService#getServiceTags() serviceTags} elements
   *    .putServiceMeta|putAllServiceMeta(String =&gt; String) // {@link CatalogService#getServiceMeta() serviceMeta} mappings
   *    .serviceWeights(org.kiwiproject.consul.model.catalog.ServiceWeights) // optional {@link CatalogService#getServiceWeights() serviceWeights}
   *    .putNodeMeta|putAllNodeMeta(String =&gt; String) // {@link CatalogService#getNodeMeta() nodeMeta} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableCatalogService builder
   */
  public static ImmutableCatalogService.Builder builder() {
    return new ImmutableCatalogService.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCatalogService ImmutableCatalogService}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CatalogService", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private static final long INIT_BIT_ADDRESS = 0x2L;
    private static final long INIT_BIT_SERVICE_NAME = 0x4L;
    private static final long INIT_BIT_SERVICE_ID = 0x8L;
    private static final long INIT_BIT_SERVICE_ADDRESS = 0x10L;
    private static final long INIT_BIT_SERVICE_PORT = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable String node;
    private @Nullable String address;
    private @Nullable String datacenter;
    private @Nullable String serviceName;
    private @Nullable String serviceId;
    private @Nullable String serviceAddress;
    private @Nullable Boolean serviceEnableTagOverride;
    private int servicePort;
    private ImmutableList.Builder<String> serviceTags = ImmutableList.builder();
    private ImmutableMap.Builder<String, String> serviceMeta = ImmutableMap.builder();
    private @Nullable ServiceWeights serviceWeights;
    private ImmutableMap.Builder<String, String> nodeMeta = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CatalogService} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CatalogService instance) {
      Objects.requireNonNull(instance, "instance");
      this.node(instance.getNode());
      this.address(instance.getAddress());
      Optional<String> datacenterOptional = instance.getDatacenter();
      if (datacenterOptional.isPresent()) {
        datacenter(datacenterOptional);
      }
      this.serviceName(instance.getServiceName());
      this.serviceId(instance.getServiceId());
      this.serviceAddress(instance.getServiceAddress());
      Optional<Boolean> serviceEnableTagOverrideOptional = instance.getServiceEnableTagOverride();
      if (serviceEnableTagOverrideOptional.isPresent()) {
        serviceEnableTagOverride(serviceEnableTagOverrideOptional);
      }
      this.servicePort(instance.getServicePort());
      addAllServiceTags(instance.getServiceTags());
      putAllServiceMeta(instance.getServiceMeta());
      Optional<ServiceWeights> serviceWeightsOptional = instance.getServiceWeights();
      if (serviceWeightsOptional.isPresent()) {
        serviceWeights(serviceWeightsOptional);
      }
      putAllNodeMeta(instance.getNodeMeta());
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogService#getNode() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Node")
    public final Builder node(String node) {
      this.node = Objects.requireNonNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogService#getAddress() address} attribute.
     * @param address The value for address 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Address")
    public final Builder address(String address) {
      this.address = Objects.requireNonNull(address, "address");
      initBits &= ~INIT_BIT_ADDRESS;
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datacenter(String datacenter) {
      this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Datacenter")
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = datacenter.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogService#getServiceName() serviceName} attribute.
     * @param serviceName The value for serviceName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceName")
    public final Builder serviceName(String serviceName) {
      this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
      initBits &= ~INIT_BIT_SERVICE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogService#getServiceId() serviceId} attribute.
     * @param serviceId The value for serviceId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceID")
    public final Builder serviceId(String serviceId) {
      this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
      initBits &= ~INIT_BIT_SERVICE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogService#getServiceAddress() serviceAddress} attribute.
     * @param serviceAddress The value for serviceAddress 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceAddress")
    public final Builder serviceAddress(String serviceAddress) {
      this.serviceAddress = Objects.requireNonNull(serviceAddress, "serviceAddress");
      initBits &= ~INIT_BIT_SERVICE_ADDRESS;
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getServiceEnableTagOverride() serviceEnableTagOverride} to serviceEnableTagOverride.
     * @param serviceEnableTagOverride The value for serviceEnableTagOverride
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serviceEnableTagOverride(boolean serviceEnableTagOverride) {
      this.serviceEnableTagOverride = serviceEnableTagOverride;
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getServiceEnableTagOverride() serviceEnableTagOverride} to serviceEnableTagOverride.
     * @param serviceEnableTagOverride The value for serviceEnableTagOverride
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceEnableTagOverride")
    public final Builder serviceEnableTagOverride(Optional<Boolean> serviceEnableTagOverride) {
      this.serviceEnableTagOverride = serviceEnableTagOverride.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogService#getServicePort() servicePort} attribute.
     * @param servicePort The value for servicePort 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServicePort")
    public final Builder servicePort(int servicePort) {
      this.servicePort = servicePort;
      initBits &= ~INIT_BIT_SERVICE_PORT;
      return this;
    }

    /**
     * Adds one element to {@link CatalogService#getServiceTags() serviceTags} list.
     * @param element A serviceTags element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addServiceTags(String element) {
      this.serviceTags.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CatalogService#getServiceTags() serviceTags} list.
     * @param elements An array of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addServiceTags(String... elements) {
      this.serviceTags.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CatalogService#getServiceTags() serviceTags} list.
     * @param elements An iterable of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceTags")
    public final Builder serviceTags(Iterable<String> elements) {
      this.serviceTags = ImmutableList.builder();
      return addAllServiceTags(elements);
    }

    /**
     * Adds elements to {@link CatalogService#getServiceTags() serviceTags} list.
     * @param elements An iterable of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllServiceTags(Iterable<String> elements) {
      this.serviceTags.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link CatalogService#getServiceMeta() serviceMeta} map.
     * @param key The key in the serviceMeta map
     * @param value The associated value in the serviceMeta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putServiceMeta(String key, String value) {
      this.serviceMeta.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CatalogService#getServiceMeta() serviceMeta} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putServiceMeta(Map.Entry<String, ? extends String> entry) {
      this.serviceMeta.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CatalogService#getServiceMeta() serviceMeta} map. Nulls are not permitted
     * @param entries The entries that will be added to the serviceMeta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceMeta")
    public final Builder serviceMeta(Map<String, ? extends String> entries) {
      this.serviceMeta = ImmutableMap.builder();
      return putAllServiceMeta(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CatalogService#getServiceMeta() serviceMeta} map. Nulls are not permitted
     * @param entries The entries that will be added to the serviceMeta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllServiceMeta(Map<String, ? extends String> entries) {
      this.serviceMeta.putAll(entries);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getServiceWeights() serviceWeights} to serviceWeights.
     * @param serviceWeights The value for serviceWeights
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serviceWeights(ServiceWeights serviceWeights) {
      this.serviceWeights = Objects.requireNonNull(serviceWeights, "serviceWeights");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getServiceWeights() serviceWeights} to serviceWeights.
     * @param serviceWeights The value for serviceWeights
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceWeights")
    public final Builder serviceWeights(Optional<? extends ServiceWeights> serviceWeights) {
      this.serviceWeights = serviceWeights.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link CatalogService#getNodeMeta() nodeMeta} map.
     * @param key The key in the nodeMeta map
     * @param value The associated value in the nodeMeta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putNodeMeta(String key, String value) {
      this.nodeMeta.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CatalogService#getNodeMeta() nodeMeta} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putNodeMeta(Map.Entry<String, ? extends String> entry) {
      this.nodeMeta.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CatalogService#getNodeMeta() nodeMeta} map. Nulls are not permitted
     * @param entries The entries that will be added to the nodeMeta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("NodeMeta")
    public final Builder nodeMeta(Map<String, ? extends String> entries) {
      this.nodeMeta = ImmutableMap.builder();
      return putAllNodeMeta(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CatalogService#getNodeMeta() nodeMeta} map. Nulls are not permitted
     * @param entries The entries that will be added to the nodeMeta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllNodeMeta(Map<String, ? extends String> entries) {
      this.nodeMeta.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCatalogService ImmutableCatalogService}.
     * @return An immutable instance of CatalogService
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCatalogService build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCatalogService(
          node,
          address,
          datacenter,
          serviceName,
          serviceId,
          serviceAddress,
          serviceEnableTagOverride,
          servicePort,
          serviceTags.build(),
          serviceMeta.build(),
          serviceWeights,
          nodeMeta.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_ADDRESS) != 0) attributes.add("address");
      if ((initBits & INIT_BIT_SERVICE_NAME) != 0) attributes.add("serviceName");
      if ((initBits & INIT_BIT_SERVICE_ID) != 0) attributes.add("serviceId");
      if ((initBits & INIT_BIT_SERVICE_ADDRESS) != 0) attributes.add("serviceAddress");
      if ((initBits & INIT_BIT_SERVICE_PORT) != 0) attributes.add("servicePort");
      return "Cannot build CatalogService, some of required attributes are not set " + attributes;
    }
  }
}
