package org.kiwiproject.consul.model.health;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.catalog.TaggedAddresses;

/**
 * Immutable implementation of {@link Node}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNode.builder()}.
 */
@Generated(from = "Node", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableNode extends Node {
  private final String node;
  private final String address;
  private final @Nullable String datacenter;
  private final @Nullable TaggedAddresses taggedAddresses;
  private final @Nullable Map<String, String> nodeMeta;

  private ImmutableNode(
      String node,
      String address,
      @Nullable String datacenter,
      @Nullable TaggedAddresses taggedAddresses,
      @Nullable Map<String, String> nodeMeta) {
    this.node = node;
    this.address = address;
    this.datacenter = datacenter;
    this.taggedAddresses = taggedAddresses;
    this.nodeMeta = nodeMeta;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public String getNode() {
    return node;
  }

  /**
   * @return The value of the {@code address} attribute
   */
  @JsonProperty("Address")
  @Override
  public String getAddress() {
    return address;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @JsonProperty("Datacenter")
  @Override
  public Optional<String> getDatacenter() {
    return Optional.ofNullable(datacenter);
  }

  /**
   * @return The value of the {@code taggedAddresses} attribute
   */
  @JsonProperty("TaggedAddresses")
  @Override
  public Optional<TaggedAddresses> getTaggedAddresses() {
    return Optional.ofNullable(taggedAddresses);
  }

  /**
   * @return The value of the {@code nodeMeta} attribute
   */
  @JsonProperty("Meta")
  @Override
  public Optional<Map<String, String>> getNodeMeta() {
    return Optional.ofNullable(nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Node#getNode() node} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNode withNode(String value) {
    String newValue = Objects.requireNonNull(value, "node");
    if (this.node.equals(newValue)) return this;
    return new ImmutableNode(newValue, this.address, this.datacenter, this.taggedAddresses, this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Node#getAddress() address} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for address
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNode withAddress(String value) {
    String newValue = Objects.requireNonNull(value, "address");
    if (this.address.equals(newValue)) return this;
    return new ImmutableNode(this.node, newValue, this.datacenter, this.taggedAddresses, this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Node#getDatacenter() datacenter} attribute.
   * @param value The value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNode withDatacenter(String value) {
    String newValue = Objects.requireNonNull(value, "datacenter");
    if (Objects.equals(this.datacenter, newValue)) return this;
    return new ImmutableNode(this.node, this.address, newValue, this.taggedAddresses, this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Node#getDatacenter() datacenter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNode withDatacenter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.datacenter, value)) return this;
    return new ImmutableNode(this.node, this.address, value, this.taggedAddresses, this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Node#getTaggedAddresses() taggedAddresses} attribute.
   * @param value The value for taggedAddresses
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNode withTaggedAddresses(TaggedAddresses value) {
    TaggedAddresses newValue = Objects.requireNonNull(value, "taggedAddresses");
    if (this.taggedAddresses == newValue) return this;
    return new ImmutableNode(this.node, this.address, this.datacenter, newValue, this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Node#getTaggedAddresses() taggedAddresses} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for taggedAddresses
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableNode withTaggedAddresses(Optional<? extends TaggedAddresses> optional) {
    @Nullable TaggedAddresses value = optional.orElse(null);
    if (this.taggedAddresses == value) return this;
    return new ImmutableNode(this.node, this.address, this.datacenter, value, this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Node#getNodeMeta() nodeMeta} attribute.
   * @param value The value for nodeMeta
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNode withNodeMeta(Map<String, String> value) {
    Map<String, String> newValue = Objects.requireNonNull(value, "nodeMeta");
    if (this.nodeMeta == newValue) return this;
    return new ImmutableNode(this.node, this.address, this.datacenter, this.taggedAddresses, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Node#getNodeMeta() nodeMeta} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for nodeMeta
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableNode withNodeMeta(Optional<? extends Map<String, String>> optional) {
    @Nullable Map<String, String> value = optional.orElse(null);
    if (this.nodeMeta == value) return this;
    return new ImmutableNode(this.node, this.address, this.datacenter, this.taggedAddresses, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNode} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNode
        && equalTo(0, (ImmutableNode) another);
  }

  private boolean equalTo(int synthetic, ImmutableNode another) {
    return node.equals(another.node)
        && address.equals(another.address)
        && Objects.equals(datacenter, another.datacenter)
        && Objects.equals(taggedAddresses, another.taggedAddresses)
        && Objects.equals(nodeMeta, another.nodeMeta);
  }

  /**
   * Computes a hash code from attributes: {@code node}, {@code address}, {@code datacenter}, {@code taggedAddresses}, {@code nodeMeta}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + node.hashCode();
    h += (h << 5) + address.hashCode();
    h += (h << 5) + Objects.hashCode(datacenter);
    h += (h << 5) + Objects.hashCode(taggedAddresses);
    h += (h << 5) + Objects.hashCode(nodeMeta);
    return h;
  }

  /**
   * Prints the immutable value {@code Node} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Node")
        .omitNullValues()
        .add("node", node)
        .add("address", address)
        .add("datacenter", datacenter)
        .add("taggedAddresses", taggedAddresses)
        .add("nodeMeta", nodeMeta)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Node", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Node {
    @Nullable String node;
    @Nullable String address;
    @Nullable Optional<String> datacenter = Optional.empty();
    @Nullable Optional<TaggedAddresses> taggedAddresses = Optional.empty();
    @Nullable Optional<Map<String, String>> nodeMeta = Optional.empty();
    @JsonProperty("Node")
    public void setNode(String node) {
      this.node = node;
    }
    @JsonProperty("Address")
    public void setAddress(String address) {
      this.address = address;
    }
    @JsonProperty("Datacenter")
    public void setDatacenter(Optional<String> datacenter) {
      this.datacenter = datacenter;
    }
    @JsonProperty("TaggedAddresses")
    public void setTaggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
      this.taggedAddresses = taggedAddresses;
    }
    @JsonProperty("Meta")
    public void setNodeMeta(Optional<Map<String, String>> nodeMeta) {
      this.nodeMeta = nodeMeta;
    }
    @Override
    public String getNode() { throw new UnsupportedOperationException(); }
    @Override
    public String getAddress() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getDatacenter() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<TaggedAddresses> getTaggedAddresses() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Map<String, String>> getNodeMeta() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableNode fromJson(Json json) {
    ImmutableNode.Builder builder = ImmutableNode.builder();
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.address != null) {
      builder.address(json.address);
    }
    if (json.datacenter != null) {
      builder.datacenter(json.datacenter);
    }
    if (json.taggedAddresses != null) {
      builder.taggedAddresses(json.taggedAddresses);
    }
    if (json.nodeMeta != null) {
      builder.nodeMeta(json.nodeMeta);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Node} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Node instance
   */
  public static ImmutableNode copyOf(Node instance) {
    if (instance instanceof ImmutableNode) {
      return (ImmutableNode) instance;
    }
    return ImmutableNode.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNode ImmutableNode}.
   * <pre>
   * ImmutableNode.builder()
   *    .node(String) // required {@link Node#getNode() node}
   *    .address(String) // required {@link Node#getAddress() address}
   *    .datacenter(String) // optional {@link Node#getDatacenter() datacenter}
   *    .taggedAddresses(org.kiwiproject.consul.model.catalog.TaggedAddresses) // optional {@link Node#getTaggedAddresses() taggedAddresses}
   *    .nodeMeta(Map&amp;lt;String, String&amp;gt;) // optional {@link Node#getNodeMeta() nodeMeta}
   *    .build();
   * </pre>
   * @return A new ImmutableNode builder
   */
  public static ImmutableNode.Builder builder() {
    return new ImmutableNode.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNode ImmutableNode}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Node", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private static final long INIT_BIT_ADDRESS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String node;
    private @Nullable String address;
    private @Nullable String datacenter;
    private @Nullable TaggedAddresses taggedAddresses;
    private @Nullable Map<String, String> nodeMeta;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Node} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Node instance) {
      Objects.requireNonNull(instance, "instance");
      this.node(instance.getNode());
      this.address(instance.getAddress());
      Optional<String> datacenterOptional = instance.getDatacenter();
      if (datacenterOptional.isPresent()) {
        datacenter(datacenterOptional);
      }
      Optional<TaggedAddresses> taggedAddressesOptional = instance.getTaggedAddresses();
      if (taggedAddressesOptional.isPresent()) {
        taggedAddresses(taggedAddressesOptional);
      }
      Optional<Map<String, String>> nodeMetaOptional = instance.getNodeMeta();
      if (nodeMetaOptional.isPresent()) {
        nodeMeta(nodeMetaOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Node#getNode() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Node")
    public final Builder node(String node) {
      this.node = Objects.requireNonNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link Node#getAddress() address} attribute.
     * @param address The value for address 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Address")
    public final Builder address(String address) {
      this.address = Objects.requireNonNull(address, "address");
      initBits &= ~INIT_BIT_ADDRESS;
      return this;
    }

    /**
     * Initializes the optional value {@link Node#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datacenter(String datacenter) {
      this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
      return this;
    }

    /**
     * Initializes the optional value {@link Node#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Datacenter")
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = datacenter.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Node#getTaggedAddresses() taggedAddresses} to taggedAddresses.
     * @param taggedAddresses The value for taggedAddresses
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder taggedAddresses(TaggedAddresses taggedAddresses) {
      this.taggedAddresses = Objects.requireNonNull(taggedAddresses, "taggedAddresses");
      return this;
    }

    /**
     * Initializes the optional value {@link Node#getTaggedAddresses() taggedAddresses} to taggedAddresses.
     * @param taggedAddresses The value for taggedAddresses
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("TaggedAddresses")
    public final Builder taggedAddresses(Optional<? extends TaggedAddresses> taggedAddresses) {
      this.taggedAddresses = taggedAddresses.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Node#getNodeMeta() nodeMeta} to nodeMeta.
     * @param nodeMeta The value for nodeMeta
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nodeMeta(Map<String, String> nodeMeta) {
      this.nodeMeta = Objects.requireNonNull(nodeMeta, "nodeMeta");
      return this;
    }

    /**
     * Initializes the optional value {@link Node#getNodeMeta() nodeMeta} to nodeMeta.
     * @param nodeMeta The value for nodeMeta
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Meta")
    public final Builder nodeMeta(Optional<? extends Map<String, String>> nodeMeta) {
      this.nodeMeta = nodeMeta.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableNode ImmutableNode}.
     * @return An immutable instance of Node
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNode build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNode(node, address, datacenter, taggedAddresses, nodeMeta);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_ADDRESS) != 0) attributes.add("address");
      return "Cannot build Node, some of required attributes are not set " + attributes;
    }
  }
}
