package org.kiwiproject.consul.model.health;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.catalog.ServiceWeights;

/**
 * Immutable implementation of {@link Service}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableService.builder()}.
 */
@Generated(from = "Service", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableService extends Service {
  private final String id;
  private final String service;
  private final @Nullable Boolean enableTagOverride;
  private final ImmutableList<String> tags;
  private final String address;
  private final ImmutableMap<String, String> meta;
  private final int port;
  private final @Nullable ServiceWeights weights;

  private ImmutableService(
      String id,
      String service,
      @Nullable Boolean enableTagOverride,
      ImmutableList<String> tags,
      String address,
      ImmutableMap<String, String> meta,
      int port,
      @Nullable ServiceWeights weights) {
    this.id = id;
    this.service = service;
    this.enableTagOverride = enableTagOverride;
    this.tags = tags;
    this.address = address;
    this.meta = meta;
    this.port = port;
    this.weights = weights;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty("Service")
  @Override
  public String getService() {
    return service;
  }

  /**
   * @return The value of the {@code enableTagOverride} attribute
   */
  @JsonProperty("EnableTagOverride")
  @Override
  public Optional<Boolean> getEnableTagOverride() {
    return Optional.ofNullable(enableTagOverride);
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty("Tags")
  @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
  @Override
  public ImmutableList<String> getTags() {
    return tags;
  }

  /**
   * @return The value of the {@code address} attribute
   */
  @JsonProperty("Address")
  @Override
  public String getAddress() {
    return address;
  }

  /**
   * @return The value of the {@code meta} attribute
   */
  @JsonProperty("Meta")
  @Override
  public ImmutableMap<String, String> getMeta() {
    return meta;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @JsonProperty("Port")
  @Override
  public int getPort() {
    return port;
  }

  /**
   * @return The value of the {@code weights} attribute
   */
  @JsonProperty("Weights")
  @Override
  public Optional<ServiceWeights> getWeights() {
    return Optional.ofNullable(weights);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableService withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableService(
        newValue,
        this.service,
        this.enableTagOverride,
        this.tags,
        this.address,
        this.meta,
        this.port,
        this.weights);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#getService() service} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for service
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableService withService(String value) {
    String newValue = Objects.requireNonNull(value, "service");
    if (this.service.equals(newValue)) return this;
    return new ImmutableService(
        this.id,
        newValue,
        this.enableTagOverride,
        this.tags,
        this.address,
        this.meta,
        this.port,
        this.weights);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Service#getEnableTagOverride() enableTagOverride} attribute.
   * @param value The value for enableTagOverride
   * @return A modified copy of {@code this} object
   */
  public final ImmutableService withEnableTagOverride(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.enableTagOverride, newValue)) return this;
    return new ImmutableService(this.id, this.service, newValue, this.tags, this.address, this.meta, this.port, this.weights);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Service#getEnableTagOverride() enableTagOverride} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for enableTagOverride
   * @return A modified copy of {@code this} object
   */
  public final ImmutableService withEnableTagOverride(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.enableTagOverride, value)) return this;
    return new ImmutableService(this.id, this.service, value, this.tags, this.address, this.meta, this.port, this.weights);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Service#getTags() tags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableService withTags(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        newValue,
        this.address,
        this.meta,
        this.port,
        this.weights);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Service#getTags() tags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableService withTags(Iterable<String> elements) {
    if (this.tags == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        newValue,
        this.address,
        this.meta,
        this.port,
        this.weights);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#getAddress() address} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for address
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableService withAddress(String value) {
    String newValue = Objects.requireNonNull(value, "address");
    if (this.address.equals(newValue)) return this;
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        this.tags,
        newValue,
        this.meta,
        this.port,
        this.weights);
  }

  /**
   * Copy the current immutable object by replacing the {@link Service#getMeta() meta} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the meta map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableService withMeta(Map<String, ? extends String> entries) {
    if (this.meta == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        this.tags,
        this.address,
        newValue,
        this.port,
        this.weights);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#getPort() port} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableService withPort(int value) {
    if (this.port == value) return this;
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        this.tags,
        this.address,
        this.meta,
        value,
        this.weights);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Service#getWeights() weights} attribute.
   * @param value The value for weights
   * @return A modified copy of {@code this} object
   */
  public final ImmutableService withWeights(ServiceWeights value) {
    ServiceWeights newValue = Objects.requireNonNull(value, "weights");
    if (this.weights == newValue) return this;
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        this.tags,
        this.address,
        this.meta,
        this.port,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Service#getWeights() weights} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for weights
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableService withWeights(Optional<? extends ServiceWeights> optional) {
    @Nullable ServiceWeights value = optional.orElse(null);
    if (this.weights == value) return this;
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        this.tags,
        this.address,
        this.meta,
        this.port,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableService} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableService
        && equalTo(0, (ImmutableService) another);
  }

  private boolean equalTo(int synthetic, ImmutableService another) {
    return id.equals(another.id)
        && service.equals(another.service)
        && Objects.equals(enableTagOverride, another.enableTagOverride)
        && tags.equals(another.tags)
        && address.equals(another.address)
        && meta.equals(another.meta)
        && port == another.port
        && Objects.equals(weights, another.weights);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code service}, {@code enableTagOverride}, {@code tags}, {@code address}, {@code meta}, {@code port}, {@code weights}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + service.hashCode();
    h += (h << 5) + Objects.hashCode(enableTagOverride);
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + address.hashCode();
    h += (h << 5) + meta.hashCode();
    h += (h << 5) + port;
    h += (h << 5) + Objects.hashCode(weights);
    return h;
  }

  /**
   * Prints the immutable value {@code Service} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Service")
        .omitNullValues()
        .add("id", id)
        .add("service", service)
        .add("enableTagOverride", enableTagOverride)
        .add("tags", tags)
        .add("address", address)
        .add("meta", meta)
        .add("port", port)
        .add("weights", weights)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Service", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Service {
    @Nullable String id;
    @Nullable String service;
    @Nullable Optional<Boolean> enableTagOverride = Optional.empty();
    @Nullable List<String> tags = ImmutableList.of();
    @Nullable String address;
    @Nullable Map<String, String> meta = ImmutableMap.of();
    int port;
    boolean portIsSet;
    @Nullable Optional<ServiceWeights> weights = Optional.empty();
    @JsonProperty("ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("Service")
    public void setService(String service) {
      this.service = service;
    }
    @JsonProperty("EnableTagOverride")
    public void setEnableTagOverride(Optional<Boolean> enableTagOverride) {
      this.enableTagOverride = enableTagOverride;
    }
    @JsonProperty("Tags")
    @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
    public void setTags(List<String> tags) {
      this.tags = tags;
    }
    @JsonProperty("Address")
    public void setAddress(String address) {
      this.address = address;
    }
    @JsonProperty("Meta")
    public void setMeta(Map<String, String> meta) {
      this.meta = meta;
    }
    @JsonProperty("Port")
    public void setPort(int port) {
      this.port = port;
      this.portIsSet = true;
    }
    @JsonProperty("Weights")
    public void setWeights(Optional<ServiceWeights> weights) {
      this.weights = weights;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getService() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getEnableTagOverride() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public String getAddress() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public int getPort() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ServiceWeights> getWeights() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableService fromJson(Json json) {
    ImmutableService.Builder builder = ImmutableService.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.enableTagOverride != null) {
      builder.enableTagOverride(json.enableTagOverride);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    if (json.address != null) {
      builder.address(json.address);
    }
    if (json.meta != null) {
      builder.putAllMeta(json.meta);
    }
    if (json.portIsSet) {
      builder.port(json.port);
    }
    if (json.weights != null) {
      builder.weights(json.weights);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Service} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Service instance
   */
  public static ImmutableService copyOf(Service instance) {
    if (instance instanceof ImmutableService) {
      return (ImmutableService) instance;
    }
    return ImmutableService.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableService ImmutableService}.
   * <pre>
   * ImmutableService.builder()
   *    .id(String) // required {@link Service#getId() id}
   *    .service(String) // required {@link Service#getService() service}
   *    .enableTagOverride(Boolean) // optional {@link Service#getEnableTagOverride() enableTagOverride}
   *    .addTags|addAllTags(String) // {@link Service#getTags() tags} elements
   *    .address(String) // required {@link Service#getAddress() address}
   *    .putMeta|putAllMeta(String =&gt; String) // {@link Service#getMeta() meta} mappings
   *    .port(int) // required {@link Service#getPort() port}
   *    .weights(org.kiwiproject.consul.model.catalog.ServiceWeights) // optional {@link Service#getWeights() weights}
   *    .build();
   * </pre>
   * @return A new ImmutableService builder
   */
  public static ImmutableService.Builder builder() {
    return new ImmutableService.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableService ImmutableService}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Service", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_SERVICE = 0x2L;
    private static final long INIT_BIT_ADDRESS = 0x4L;
    private static final long INIT_BIT_PORT = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String service;
    private @Nullable Boolean enableTagOverride;
    private ImmutableList.Builder<String> tags = ImmutableList.builder();
    private @Nullable String address;
    private ImmutableMap.Builder<String, String> meta = ImmutableMap.builder();
    private int port;
    private @Nullable ServiceWeights weights;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Service} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Service instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.service(instance.getService());
      Optional<Boolean> enableTagOverrideOptional = instance.getEnableTagOverride();
      if (enableTagOverrideOptional.isPresent()) {
        enableTagOverride(enableTagOverrideOptional);
      }
      addAllTags(instance.getTags());
      this.address(instance.getAddress());
      putAllMeta(instance.getMeta());
      this.port(instance.getPort());
      Optional<ServiceWeights> weightsOptional = instance.getWeights();
      if (weightsOptional.isPresent()) {
        weights(weightsOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Service#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Service#getService() service} attribute.
     * @param service The value for service 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Service")
    public final Builder service(String service) {
      this.service = Objects.requireNonNull(service, "service");
      initBits &= ~INIT_BIT_SERVICE;
      return this;
    }

    /**
     * Initializes the optional value {@link Service#getEnableTagOverride() enableTagOverride} to enableTagOverride.
     * @param enableTagOverride The value for enableTagOverride
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder enableTagOverride(boolean enableTagOverride) {
      this.enableTagOverride = enableTagOverride;
      return this;
    }

    /**
     * Initializes the optional value {@link Service#getEnableTagOverride() enableTagOverride} to enableTagOverride.
     * @param enableTagOverride The value for enableTagOverride
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("EnableTagOverride")
    public final Builder enableTagOverride(Optional<Boolean> enableTagOverride) {
      this.enableTagOverride = enableTagOverride.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link Service#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(String element) {
      this.tags.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Service#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(String... elements) {
      this.tags.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Service#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Tags")
    @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
    public final Builder tags(Iterable<String> elements) {
      this.tags = ImmutableList.builder();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link Service#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTags(Iterable<String> elements) {
      this.tags.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Service#getAddress() address} attribute.
     * @param address The value for address 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Address")
    public final Builder address(String address) {
      this.address = Objects.requireNonNull(address, "address");
      initBits &= ~INIT_BIT_ADDRESS;
      return this;
    }

    /**
     * Put one entry to the {@link Service#getMeta() meta} map.
     * @param key The key in the meta map
     * @param value The associated value in the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMeta(String key, String value) {
      this.meta.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Service#getMeta() meta} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMeta(Map.Entry<String, ? extends String> entry) {
      this.meta.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Service#getMeta() meta} map. Nulls are not permitted
     * @param entries The entries that will be added to the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Meta")
    public final Builder meta(Map<String, ? extends String> entries) {
      this.meta = ImmutableMap.builder();
      return putAllMeta(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Service#getMeta() meta} map. Nulls are not permitted
     * @param entries The entries that will be added to the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMeta(Map<String, ? extends String> entries) {
      this.meta.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link Service#getPort() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Port")
    public final Builder port(int port) {
      this.port = port;
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Initializes the optional value {@link Service#getWeights() weights} to weights.
     * @param weights The value for weights
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder weights(ServiceWeights weights) {
      this.weights = Objects.requireNonNull(weights, "weights");
      return this;
    }

    /**
     * Initializes the optional value {@link Service#getWeights() weights} to weights.
     * @param weights The value for weights
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Weights")
    public final Builder weights(Optional<? extends ServiceWeights> weights) {
      this.weights = weights.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableService ImmutableService}.
     * @return An immutable instance of Service
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableService build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableService(id, service, enableTagOverride, tags.build(), address, meta.build(), port, weights);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_SERVICE) != 0) attributes.add("service");
      if ((initBits & INIT_BIT_ADDRESS) != 0) attributes.add("address");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      return "Cannot build Service, some of required attributes are not set " + attributes;
    }
  }
}
