package org.kiwiproject.consul.model.health;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ServiceCheck}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableServiceCheck.builder()}.
 */
@Generated(from = "ServiceCheck", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableServiceCheck extends ServiceCheck {
  private final Node node;
  private final Service service;
  private final ImmutableList<HealthCheck> checks;

  private ImmutableServiceCheck(
      Node node,
      Service service,
      ImmutableList<HealthCheck> checks) {
    this.node = node;
    this.service = service;
    this.checks = checks;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public Node getNode() {
    return node;
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty("Service")
  @Override
  public Service getService() {
    return service;
  }

  /**
   * @return The value of the {@code checks} attribute
   */
  @JsonProperty("Checks")
  @JsonDeserialize(as = ImmutableList.class, contentAs = HealthCheck.class)
  @Override
  public ImmutableList<HealthCheck> getChecks() {
    return checks;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceCheck#getNode() node} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceCheck withNode(Node value) {
    if (this.node == value) return this;
    Node newValue = Objects.requireNonNull(value, "node");
    return new ImmutableServiceCheck(newValue, this.service, this.checks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceCheck#getService() service} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for service
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceCheck withService(Service value) {
    if (this.service == value) return this;
    Service newValue = Objects.requireNonNull(value, "service");
    return new ImmutableServiceCheck(this.node, newValue, this.checks);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ServiceCheck#getChecks() checks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceCheck withChecks(HealthCheck... elements) {
    ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
    return new ImmutableServiceCheck(this.node, this.service, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ServiceCheck#getChecks() checks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of checks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceCheck withChecks(Iterable<? extends HealthCheck> elements) {
    if (this.checks == elements) return this;
    ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
    return new ImmutableServiceCheck(this.node, this.service, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableServiceCheck} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableServiceCheck
        && equalTo(0, (ImmutableServiceCheck) another);
  }

  private boolean equalTo(int synthetic, ImmutableServiceCheck another) {
    return node.equals(another.node)
        && service.equals(another.service)
        && checks.equals(another.checks);
  }

  /**
   * Computes a hash code from attributes: {@code node}, {@code service}, {@code checks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + node.hashCode();
    h += (h << 5) + service.hashCode();
    h += (h << 5) + checks.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceCheck} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ServiceCheck")
        .omitNullValues()
        .add("node", node)
        .add("service", service)
        .add("checks", checks)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ServiceCheck", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends ServiceCheck {
    @Nullable Node node;
    @Nullable Service service;
    @Nullable List<HealthCheck> checks = ImmutableList.of();
    @JsonProperty("Node")
    public void setNode(Node node) {
      this.node = node;
    }
    @JsonProperty("Service")
    public void setService(Service service) {
      this.service = service;
    }
    @JsonProperty("Checks")
    @JsonDeserialize(as = ImmutableList.class, contentAs = HealthCheck.class)
    public void setChecks(List<HealthCheck> checks) {
      this.checks = checks;
    }
    @Override
    public Node getNode() { throw new UnsupportedOperationException(); }
    @Override
    public Service getService() { throw new UnsupportedOperationException(); }
    @Override
    public List<HealthCheck> getChecks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableServiceCheck fromJson(Json json) {
    ImmutableServiceCheck.Builder builder = ImmutableServiceCheck.builder();
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.checks != null) {
      builder.addAllChecks(json.checks);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ServiceCheck} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ServiceCheck instance
   */
  public static ImmutableServiceCheck copyOf(ServiceCheck instance) {
    if (instance instanceof ImmutableServiceCheck) {
      return (ImmutableServiceCheck) instance;
    }
    return ImmutableServiceCheck.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableServiceCheck ImmutableServiceCheck}.
   * <pre>
   * ImmutableServiceCheck.builder()
   *    .node(org.kiwiproject.consul.model.health.Node) // required {@link ServiceCheck#getNode() node}
   *    .service(org.kiwiproject.consul.model.health.Service) // required {@link ServiceCheck#getService() service}
   *    .addChecks|addAllChecks(org.kiwiproject.consul.model.health.HealthCheck) // {@link ServiceCheck#getChecks() checks} elements
   *    .build();
   * </pre>
   * @return A new ImmutableServiceCheck builder
   */
  public static ImmutableServiceCheck.Builder builder() {
    return new ImmutableServiceCheck.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableServiceCheck ImmutableServiceCheck}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ServiceCheck", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private static final long INIT_BIT_SERVICE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Node node;
    private @Nullable Service service;
    private ImmutableList.Builder<HealthCheck> checks = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceCheck} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ServiceCheck instance) {
      Objects.requireNonNull(instance, "instance");
      this.node(instance.getNode());
      this.service(instance.getService());
      addAllChecks(instance.getChecks());
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceCheck#getNode() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Node")
    public final Builder node(Node node) {
      this.node = Objects.requireNonNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceCheck#getService() service} attribute.
     * @param service The value for service 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Service")
    public final Builder service(Service service) {
      this.service = Objects.requireNonNull(service, "service");
      initBits &= ~INIT_BIT_SERVICE;
      return this;
    }

    /**
     * Adds one element to {@link ServiceCheck#getChecks() checks} list.
     * @param element A checks element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addChecks(HealthCheck element) {
      this.checks.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ServiceCheck#getChecks() checks} list.
     * @param elements An array of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addChecks(HealthCheck... elements) {
      this.checks.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ServiceCheck#getChecks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Checks")
    @JsonDeserialize(as = ImmutableList.class, contentAs = HealthCheck.class)
    public final Builder checks(Iterable<? extends HealthCheck> elements) {
      this.checks = ImmutableList.builder();
      return addAllChecks(elements);
    }

    /**
     * Adds elements to {@link ServiceCheck#getChecks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllChecks(Iterable<? extends HealthCheck> elements) {
      this.checks.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableServiceCheck ImmutableServiceCheck}.
     * @return An immutable instance of ServiceCheck
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableServiceCheck build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableServiceCheck(node, service, checks.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_SERVICE) != 0) attributes.add("service");
      return "Cannot build ServiceCheck, some of required attributes are not set " + attributes;
    }
  }
}
