package org.kiwiproject.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.util.Base64EncodingDeserializer;
import org.kiwiproject.consul.util.Base64EncodingSerializer;

/**
 * Immutable implementation of {@link Operation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOperation.builder()}.
 */
@Generated(from = "Operation", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableOperation extends Operation {
  private final String verb;
  private final @Nullable String key;
  private final @Nullable String value;
  private final @Nullable Long flags;
  private final @Nullable BigInteger index;
  private final @Nullable String session;

  private ImmutableOperation(
      String verb,
      @Nullable String key,
      @Nullable String value,
      @Nullable Long flags,
      @Nullable BigInteger index,
      @Nullable String session) {
    this.verb = verb;
    this.key = key;
    this.value = value;
    this.flags = flags;
    this.index = index;
    this.session = session;
  }

  /**
   * @return The value of the {@code verb} attribute
   */
  @JsonProperty("Verb")
  @Override
  public String verb() {
    return verb;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty("Key")
  @Override
  public Optional<String> key() {
    return Optional.ofNullable(key);
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("Value")
  @JsonSerialize(using = Base64EncodingSerializer.class)
  @JsonDeserialize(using = Base64EncodingDeserializer.class)
  @Override
  public Optional<String> value() {
    return Optional.ofNullable(value);
  }

  /**
   * @return The value of the {@code flags} attribute
   */
  @JsonProperty("Flags")
  @Override
  public Optional<Long> flags() {
    return Optional.ofNullable(flags);
  }

  /**
   * @return The value of the {@code index} attribute
   */
  @JsonProperty("Index")
  @Override
  public Optional<BigInteger> index() {
    return Optional.ofNullable(index);
  }

  /**
   * @return The value of the {@code session} attribute
   */
  @JsonProperty("Session")
  @Override
  public Optional<String> session() {
    return Optional.ofNullable(session);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Operation#verb() verb} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verb
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOperation withVerb(String value) {
    String newValue = Objects.requireNonNull(value, "verb");
    if (this.verb.equals(newValue)) return this;
    return new ImmutableOperation(newValue, this.key, this.value, this.flags, this.index, this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Operation#key() key} attribute.
   * @param value The value for key
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withKey(String value) {
    String newValue = Objects.requireNonNull(value, "key");
    if (Objects.equals(this.key, newValue)) return this;
    return new ImmutableOperation(this.verb, newValue, this.value, this.flags, this.index, this.session);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Operation#key() key} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for key
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withKey(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.key, value)) return this;
    return new ImmutableOperation(this.verb, value, this.value, this.flags, this.index, this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Operation#value() value} attribute.
   * @param value The value for value
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (Objects.equals(this.value, newValue)) return this;
    return new ImmutableOperation(this.verb, this.key, newValue, this.flags, this.index, this.session);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Operation#value() value} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for value
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withValue(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.value, value)) return this;
    return new ImmutableOperation(this.verb, this.key, value, this.flags, this.index, this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Operation#flags() flags} attribute.
   * @param value The value for flags
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withFlags(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.flags, newValue)) return this;
    return new ImmutableOperation(this.verb, this.key, this.value, newValue, this.index, this.session);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Operation#flags() flags} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for flags
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withFlags(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.flags, value)) return this;
    return new ImmutableOperation(this.verb, this.key, this.value, value, this.index, this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Operation#index() index} attribute.
   * @param value The value for index
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withIndex(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "index");
    if (Objects.equals(this.index, newValue)) return this;
    return new ImmutableOperation(this.verb, this.key, this.value, this.flags, newValue, this.session);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Operation#index() index} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for index
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableOperation withIndex(Optional<? extends BigInteger> optional) {
    @Nullable BigInteger value = optional.orElse(null);
    if (Objects.equals(this.index, value)) return this;
    return new ImmutableOperation(this.verb, this.key, this.value, this.flags, value, this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Operation#session() session} attribute.
   * @param value The value for session
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withSession(String value) {
    String newValue = Objects.requireNonNull(value, "session");
    if (Objects.equals(this.session, newValue)) return this;
    return new ImmutableOperation(this.verb, this.key, this.value, this.flags, this.index, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Operation#session() session} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for session
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperation withSession(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.session, value)) return this;
    return new ImmutableOperation(this.verb, this.key, this.value, this.flags, this.index, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOperation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOperation
        && equalTo(0, (ImmutableOperation) another);
  }

  private boolean equalTo(int synthetic, ImmutableOperation another) {
    return verb.equals(another.verb)
        && Objects.equals(key, another.key)
        && Objects.equals(value, another.value)
        && Objects.equals(flags, another.flags)
        && Objects.equals(index, another.index)
        && Objects.equals(session, another.session);
  }

  /**
   * Computes a hash code from attributes: {@code verb}, {@code key}, {@code value}, {@code flags}, {@code index}, {@code session}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + verb.hashCode();
    h += (h << 5) + Objects.hashCode(key);
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Objects.hashCode(flags);
    h += (h << 5) + Objects.hashCode(index);
    h += (h << 5) + Objects.hashCode(session);
    return h;
  }

  /**
   * Prints the immutable value {@code Operation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Operation")
        .omitNullValues()
        .add("verb", verb)
        .add("key", key)
        .add("value", value)
        .add("flags", flags)
        .add("index", index)
        .add("session", session)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Operation", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Operation {
    @Nullable String verb;
    @Nullable Optional<String> key = Optional.empty();
    @Nullable Optional<String> value = Optional.empty();
    @Nullable Optional<Long> flags = Optional.empty();
    @Nullable Optional<BigInteger> index = Optional.empty();
    @Nullable Optional<String> session = Optional.empty();
    @JsonProperty("Verb")
    public void setVerb(String verb) {
      this.verb = verb;
    }
    @JsonProperty("Key")
    public void setKey(Optional<String> key) {
      this.key = key;
    }
    @JsonProperty("Value")
    @JsonSerialize(using = Base64EncodingSerializer.class)
    @JsonDeserialize(using = Base64EncodingDeserializer.class)
    public void setValue(Optional<String> value) {
      this.value = value;
    }
    @JsonProperty("Flags")
    public void setFlags(Optional<Long> flags) {
      this.flags = flags;
    }
    @JsonProperty("Index")
    public void setIndex(Optional<BigInteger> index) {
      this.index = index;
    }
    @JsonProperty("Session")
    public void setSession(Optional<String> session) {
      this.session = session;
    }
    @Override
    public String verb() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> key() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> value() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Long> flags() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<BigInteger> index() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> session() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableOperation fromJson(Json json) {
    ImmutableOperation.Builder builder = ImmutableOperation.builder();
    if (json.verb != null) {
      builder.verb(json.verb);
    }
    if (json.key != null) {
      builder.key(json.key);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.flags != null) {
      builder.flags(json.flags);
    }
    if (json.index != null) {
      builder.index(json.index);
    }
    if (json.session != null) {
      builder.session(json.session);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Operation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Operation instance
   */
  public static ImmutableOperation copyOf(Operation instance) {
    if (instance instanceof ImmutableOperation) {
      return (ImmutableOperation) instance;
    }
    return ImmutableOperation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOperation ImmutableOperation}.
   * <pre>
   * ImmutableOperation.builder()
   *    .verb(String) // required {@link Operation#verb() verb}
   *    .key(String) // optional {@link Operation#key() key}
   *    .value(String) // optional {@link Operation#value() value}
   *    .flags(Long) // optional {@link Operation#flags() flags}
   *    .index(java.math.BigInteger) // optional {@link Operation#index() index}
   *    .session(String) // optional {@link Operation#session() session}
   *    .build();
   * </pre>
   * @return A new ImmutableOperation builder
   */
  public static ImmutableOperation.Builder builder() {
    return new ImmutableOperation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOperation ImmutableOperation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Operation", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_VERB = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String verb;
    private @Nullable String key;
    private @Nullable String value;
    private @Nullable Long flags;
    private @Nullable BigInteger index;
    private @Nullable String session;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Operation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Operation instance) {
      Objects.requireNonNull(instance, "instance");
      this.verb(instance.verb());
      Optional<String> keyOptional = instance.key();
      if (keyOptional.isPresent()) {
        key(keyOptional);
      }
      Optional<String> valueOptional = instance.value();
      if (valueOptional.isPresent()) {
        value(valueOptional);
      }
      Optional<Long> flagsOptional = instance.flags();
      if (flagsOptional.isPresent()) {
        flags(flagsOptional);
      }
      Optional<BigInteger> indexOptional = instance.index();
      if (indexOptional.isPresent()) {
        index(indexOptional);
      }
      Optional<String> sessionOptional = instance.session();
      if (sessionOptional.isPresent()) {
        session(sessionOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Operation#verb() verb} attribute.
     * @param verb The value for verb 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Verb")
    public final Builder verb(String verb) {
      this.verb = Objects.requireNonNull(verb, "verb");
      initBits &= ~INIT_BIT_VERB;
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#key() key} to key.
     * @param key The value for key
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#key() key} to key.
     * @param key The value for key
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Key")
    public final Builder key(Optional<String> key) {
      this.key = key.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#value() value} to value.
     * @param value The value for value
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#value() value} to value.
     * @param value The value for value
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Value")
    @JsonSerialize(using = Base64EncodingSerializer.class)
    @JsonDeserialize(using = Base64EncodingDeserializer.class)
    public final Builder value(Optional<String> value) {
      this.value = value.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#flags() flags} to flags.
     * @param flags The value for flags
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder flags(long flags) {
      this.flags = flags;
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#flags() flags} to flags.
     * @param flags The value for flags
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Flags")
    public final Builder flags(Optional<Long> flags) {
      this.flags = flags.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#index() index} to index.
     * @param index The value for index
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder index(BigInteger index) {
      this.index = Objects.requireNonNull(index, "index");
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#index() index} to index.
     * @param index The value for index
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Index")
    public final Builder index(Optional<? extends BigInteger> index) {
      this.index = index.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#session() session} to session.
     * @param session The value for session
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder session(String session) {
      this.session = Objects.requireNonNull(session, "session");
      return this;
    }

    /**
     * Initializes the optional value {@link Operation#session() session} to session.
     * @param session The value for session
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Session")
    public final Builder session(Optional<String> session) {
      this.session = session.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableOperation ImmutableOperation}.
     * @return An immutable instance of Operation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOperation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOperation(verb, key, value, flags, index, session);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERB) != 0) attributes.add("verb");
      return "Cannot build Operation, some of required attributes are not set " + attributes;
    }
  }
}
