package org.kiwiproject.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.util.UnsignedLongDeserializer;

/**
 * Immutable implementation of {@link Value}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValue.builder()}.
 */
@Generated(from = "Value", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableValue extends Value {
  private final long createIndex;
  private final long modifyIndex;
  private final long lockIndex;
  private final String key;
  private final long flags;
  private final @Nullable String value;
  private final @Nullable String session;

  private ImmutableValue(
      long createIndex,
      long modifyIndex,
      long lockIndex,
      String key,
      long flags,
      @Nullable String value,
      @Nullable String session) {
    this.createIndex = createIndex;
    this.modifyIndex = modifyIndex;
    this.lockIndex = lockIndex;
    this.key = key;
    this.flags = flags;
    this.value = value;
    this.session = session;
  }

  /**
   * @return The value of the {@code createIndex} attribute
   */
  @JsonProperty("CreateIndex")
  @Override
  public long getCreateIndex() {
    return createIndex;
  }

  /**
   * @return The value of the {@code modifyIndex} attribute
   */
  @JsonProperty("ModifyIndex")
  @Override
  public long getModifyIndex() {
    return modifyIndex;
  }

  /**
   * @return The value of the {@code lockIndex} attribute
   */
  @JsonProperty("LockIndex")
  @Override
  public long getLockIndex() {
    return lockIndex;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty("Key")
  @Override
  public String getKey() {
    return key;
  }

  /**
   * @return The value of the {@code flags} attribute
   */
  @JsonProperty("Flags")
  @JsonDeserialize(using = UnsignedLongDeserializer.class)
  @Override
  public long getFlags() {
    return flags;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("Value")
  @Override
  public Optional<String> getValue() {
    return Optional.ofNullable(value);
  }

  /**
   * @return The value of the {@code session} attribute
   */
  @JsonProperty("Session")
  @Override
  public Optional<String> getSession() {
    return Optional.ofNullable(session);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value#getCreateIndex() createIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValue withCreateIndex(long value) {
    if (this.createIndex == value) return this;
    return new ImmutableValue(value, this.modifyIndex, this.lockIndex, this.key, this.flags, this.value, this.session);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value#getModifyIndex() modifyIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modifyIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValue withModifyIndex(long value) {
    if (this.modifyIndex == value) return this;
    return new ImmutableValue(this.createIndex, value, this.lockIndex, this.key, this.flags, this.value, this.session);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value#getLockIndex() lockIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lockIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValue withLockIndex(long value) {
    if (this.lockIndex == value) return this;
    return new ImmutableValue(this.createIndex, this.modifyIndex, value, this.key, this.flags, this.value, this.session);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value#getKey() key} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValue withKey(String value) {
    String newValue = Objects.requireNonNull(value, "key");
    if (this.key.equals(newValue)) return this;
    return new ImmutableValue(
        this.createIndex,
        this.modifyIndex,
        this.lockIndex,
        newValue,
        this.flags,
        this.value,
        this.session);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value#getFlags() flags} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for flags
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValue withFlags(long value) {
    if (this.flags == value) return this;
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, value, this.value, this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Value#getValue() value} attribute.
   * @param value The value for value
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValue withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (Objects.equals(this.value, newValue)) return this;
    return new ImmutableValue(
        this.createIndex,
        this.modifyIndex,
        this.lockIndex,
        this.key,
        this.flags,
        newValue,
        this.session);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Value#getValue() value} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for value
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValue withValue(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.value, value)) return this;
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, value, this.session);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Value#getSession() session} attribute.
   * @param value The value for session
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValue withSession(String value) {
    String newValue = Objects.requireNonNull(value, "session");
    if (Objects.equals(this.session, newValue)) return this;
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, this.value, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Value#getSession() session} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for session
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValue withSession(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.session, value)) return this;
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, this.value, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValue
        && equalTo(0, (ImmutableValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableValue another) {
    return createIndex == another.createIndex
        && modifyIndex == another.modifyIndex
        && lockIndex == another.lockIndex
        && key.equals(another.key)
        && flags == another.flags
        && Objects.equals(value, another.value)
        && Objects.equals(session, another.session);
  }

  /**
   * Computes a hash code from attributes: {@code createIndex}, {@code modifyIndex}, {@code lockIndex}, {@code key}, {@code flags}, {@code value}, {@code session}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Longs.hashCode(createIndex);
    h += (h << 5) + Longs.hashCode(modifyIndex);
    h += (h << 5) + Longs.hashCode(lockIndex);
    h += (h << 5) + key.hashCode();
    h += (h << 5) + Longs.hashCode(flags);
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Objects.hashCode(session);
    return h;
  }

  /**
   * Prints the immutable value {@code Value} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Value")
        .omitNullValues()
        .add("createIndex", createIndex)
        .add("modifyIndex", modifyIndex)
        .add("lockIndex", lockIndex)
        .add("key", key)
        .add("flags", flags)
        .add("value", value)
        .add("session", session)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Value", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Value {
    long createIndex;
    boolean createIndexIsSet;
    long modifyIndex;
    boolean modifyIndexIsSet;
    long lockIndex;
    boolean lockIndexIsSet;
    @Nullable String key;
    long flags;
    boolean flagsIsSet;
    @Nullable Optional<String> value = Optional.empty();
    @Nullable Optional<String> session = Optional.empty();
    @JsonProperty("CreateIndex")
    public void setCreateIndex(long createIndex) {
      this.createIndex = createIndex;
      this.createIndexIsSet = true;
    }
    @JsonProperty("ModifyIndex")
    public void setModifyIndex(long modifyIndex) {
      this.modifyIndex = modifyIndex;
      this.modifyIndexIsSet = true;
    }
    @JsonProperty("LockIndex")
    public void setLockIndex(long lockIndex) {
      this.lockIndex = lockIndex;
      this.lockIndexIsSet = true;
    }
    @JsonProperty("Key")
    public void setKey(String key) {
      this.key = key;
    }
    @JsonProperty("Flags")
    @JsonDeserialize(using = UnsignedLongDeserializer.class)
    public void setFlags(long flags) {
      this.flags = flags;
      this.flagsIsSet = true;
    }
    @JsonProperty("Value")
    public void setValue(Optional<String> value) {
      this.value = value;
    }
    @JsonProperty("Session")
    public void setSession(Optional<String> session) {
      this.session = session;
    }
    @Override
    public long getCreateIndex() { throw new UnsupportedOperationException(); }
    @Override
    public long getModifyIndex() { throw new UnsupportedOperationException(); }
    @Override
    public long getLockIndex() { throw new UnsupportedOperationException(); }
    @Override
    public String getKey() { throw new UnsupportedOperationException(); }
    @Override
    public long getFlags() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getValue() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getSession() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getValueAsString() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<byte[]> getValueAsBytes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableValue fromJson(Json json) {
    ImmutableValue.Builder builder = ImmutableValue.builder();
    if (json.createIndexIsSet) {
      builder.createIndex(json.createIndex);
    }
    if (json.modifyIndexIsSet) {
      builder.modifyIndex(json.modifyIndex);
    }
    if (json.lockIndexIsSet) {
      builder.lockIndex(json.lockIndex);
    }
    if (json.key != null) {
      builder.key(json.key);
    }
    if (json.flagsIsSet) {
      builder.flags(json.flags);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.session != null) {
      builder.session(json.session);
    }
    return builder.build();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long VALUE_AS_STRING_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Optional<String> valueAsString;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Value#getValueAsString() valueAsString} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code valueAsString} attribute
   */
  @Override
  public Optional<String> getValueAsString() {
    if ((lazyInitBitmap & VALUE_AS_STRING_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & VALUE_AS_STRING_LAZY_INIT_BIT) == 0) {
          this.valueAsString = Objects.requireNonNull(super.getValueAsString(), "valueAsString");
          lazyInitBitmap |= VALUE_AS_STRING_LAZY_INIT_BIT;
        }
      }
    }
    return valueAsString;
  }

  private static final long VALUE_AS_BYTES_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient Optional<byte[]> valueAsBytes;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Value#getValueAsBytes() valueAsBytes} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code valueAsBytes} attribute
   */
  @Override
  public Optional<byte[]> getValueAsBytes() {
    if ((lazyInitBitmap & VALUE_AS_BYTES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & VALUE_AS_BYTES_LAZY_INIT_BIT) == 0) {
          this.valueAsBytes = Objects.requireNonNull(super.getValueAsBytes(), "valueAsBytes");
          lazyInitBitmap |= VALUE_AS_BYTES_LAZY_INIT_BIT;
        }
      }
    }
    return valueAsBytes;
  }

  /**
   * Creates an immutable copy of a {@link Value} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Value instance
   */
  public static ImmutableValue copyOf(Value instance) {
    if (instance instanceof ImmutableValue) {
      return (ImmutableValue) instance;
    }
    return ImmutableValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValue ImmutableValue}.
   * <pre>
   * ImmutableValue.builder()
   *    .createIndex(long) // required {@link Value#getCreateIndex() createIndex}
   *    .modifyIndex(long) // required {@link Value#getModifyIndex() modifyIndex}
   *    .lockIndex(long) // required {@link Value#getLockIndex() lockIndex}
   *    .key(String) // required {@link Value#getKey() key}
   *    .flags(long) // required {@link Value#getFlags() flags}
   *    .value(String) // optional {@link Value#getValue() value}
   *    .session(String) // optional {@link Value#getSession() session}
   *    .build();
   * </pre>
   * @return A new ImmutableValue builder
   */
  public static ImmutableValue.Builder builder() {
    return new ImmutableValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValue ImmutableValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Value", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATE_INDEX = 0x1L;
    private static final long INIT_BIT_MODIFY_INDEX = 0x2L;
    private static final long INIT_BIT_LOCK_INDEX = 0x4L;
    private static final long INIT_BIT_KEY = 0x8L;
    private static final long INIT_BIT_FLAGS = 0x10L;
    private long initBits = 0x1fL;

    private long createIndex;
    private long modifyIndex;
    private long lockIndex;
    private @Nullable String key;
    private long flags;
    private @Nullable String value;
    private @Nullable String session;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Value} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Value instance) {
      Objects.requireNonNull(instance, "instance");
      this.createIndex(instance.getCreateIndex());
      this.modifyIndex(instance.getModifyIndex());
      this.lockIndex(instance.getLockIndex());
      this.key(instance.getKey());
      this.flags(instance.getFlags());
      Optional<String> valueOptional = instance.getValue();
      if (valueOptional.isPresent()) {
        value(valueOptional);
      }
      Optional<String> sessionOptional = instance.getSession();
      if (sessionOptional.isPresent()) {
        session(sessionOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Value#getCreateIndex() createIndex} attribute.
     * @param createIndex The value for createIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("CreateIndex")
    public final Builder createIndex(long createIndex) {
      this.createIndex = createIndex;
      initBits &= ~INIT_BIT_CREATE_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link Value#getModifyIndex() modifyIndex} attribute.
     * @param modifyIndex The value for modifyIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ModifyIndex")
    public final Builder modifyIndex(long modifyIndex) {
      this.modifyIndex = modifyIndex;
      initBits &= ~INIT_BIT_MODIFY_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link Value#getLockIndex() lockIndex} attribute.
     * @param lockIndex The value for lockIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("LockIndex")
    public final Builder lockIndex(long lockIndex) {
      this.lockIndex = lockIndex;
      initBits &= ~INIT_BIT_LOCK_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link Value#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Key")
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link Value#getFlags() flags} attribute.
     * @param flags The value for flags 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Flags")
    @JsonDeserialize(using = UnsignedLongDeserializer.class)
    public final Builder flags(long flags) {
      this.flags = flags;
      initBits &= ~INIT_BIT_FLAGS;
      return this;
    }

    /**
     * Initializes the optional value {@link Value#getValue() value} to value.
     * @param value The value for value
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      return this;
    }

    /**
     * Initializes the optional value {@link Value#getValue() value} to value.
     * @param value The value for value
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Value")
    public final Builder value(Optional<String> value) {
      this.value = value.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Value#getSession() session} to session.
     * @param session The value for session
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder session(String session) {
      this.session = Objects.requireNonNull(session, "session");
      return this;
    }

    /**
     * Initializes the optional value {@link Value#getSession() session} to session.
     * @param session The value for session
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Session")
    public final Builder session(Optional<String> session) {
      this.session = session.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableValue ImmutableValue}.
     * @return An immutable instance of Value
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValue(createIndex, modifyIndex, lockIndex, key, flags, value, session);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATE_INDEX) != 0) attributes.add("createIndex");
      if ((initBits & INIT_BIT_MODIFY_INDEX) != 0) attributes.add("modifyIndex");
      if ((initBits & INIT_BIT_LOCK_INDEX) != 0) attributes.add("lockIndex");
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_FLAGS) != 0) attributes.add("flags");
      return "Cannot build Value, some of required attributes are not set " + attributes;
    }
  }
}
