package org.kiwiproject.consul.model.query;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ServiceQuery}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableServiceQuery.builder()}.
 */
@Generated(from = "ServiceQuery", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableServiceQuery extends ServiceQuery {
  private final String service;
  private final @Nullable Boolean onlyPassing;
  private final @Nullable List<String> tags;
  private final @Nullable Failover failover;

  private ImmutableServiceQuery(
      String service,
      @Nullable Boolean onlyPassing,
      @Nullable List<String> tags,
      @Nullable Failover failover) {
    this.service = service;
    this.onlyPassing = onlyPassing;
    this.tags = tags;
    this.failover = failover;
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty("Service")
  @Override
  public String getService() {
    return service;
  }

  /**
   * @return The value of the {@code onlyPassing} attribute
   */
  @JsonProperty("OnlyPassing")
  @Override
  public Optional<Boolean> getOnlyPassing() {
    return Optional.ofNullable(onlyPassing);
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty("Tags")
  @Override
  public Optional<List<String>> getTags() {
    return Optional.ofNullable(tags);
  }

  /**
   * @return The value of the {@code failover} attribute
   */
  @JsonProperty("Failover")
  @Override
  public Optional<Failover> getFailover() {
    return Optional.ofNullable(failover);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceQuery#getService() service} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for service
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceQuery withService(String value) {
    String newValue = Objects.requireNonNull(value, "service");
    if (this.service.equals(newValue)) return this;
    return new ImmutableServiceQuery(newValue, this.onlyPassing, this.tags, this.failover);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ServiceQuery#getOnlyPassing() onlyPassing} attribute.
   * @param value The value for onlyPassing
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceQuery withOnlyPassing(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.onlyPassing, newValue)) return this;
    return new ImmutableServiceQuery(this.service, newValue, this.tags, this.failover);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ServiceQuery#getOnlyPassing() onlyPassing} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for onlyPassing
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceQuery withOnlyPassing(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.onlyPassing, value)) return this;
    return new ImmutableServiceQuery(this.service, value, this.tags, this.failover);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ServiceQuery#getTags() tags} attribute.
   * @param value The value for tags
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceQuery withTags(List<String> value) {
    List<String> newValue = Objects.requireNonNull(value, "tags");
    if (this.tags == newValue) return this;
    return new ImmutableServiceQuery(this.service, this.onlyPassing, newValue, this.failover);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ServiceQuery#getTags() tags} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tags
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableServiceQuery withTags(Optional<? extends List<String>> optional) {
    @Nullable List<String> value = optional.orElse(null);
    if (this.tags == value) return this;
    return new ImmutableServiceQuery(this.service, this.onlyPassing, value, this.failover);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ServiceQuery#getFailover() failover} attribute.
   * @param value The value for failover
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceQuery withFailover(Failover value) {
    Failover newValue = Objects.requireNonNull(value, "failover");
    if (this.failover == newValue) return this;
    return new ImmutableServiceQuery(this.service, this.onlyPassing, this.tags, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ServiceQuery#getFailover() failover} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for failover
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableServiceQuery withFailover(Optional<? extends Failover> optional) {
    @Nullable Failover value = optional.orElse(null);
    if (this.failover == value) return this;
    return new ImmutableServiceQuery(this.service, this.onlyPassing, this.tags, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableServiceQuery} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableServiceQuery
        && equalTo(0, (ImmutableServiceQuery) another);
  }

  private boolean equalTo(int synthetic, ImmutableServiceQuery another) {
    return service.equals(another.service)
        && Objects.equals(onlyPassing, another.onlyPassing)
        && Objects.equals(tags, another.tags)
        && Objects.equals(failover, another.failover);
  }

  /**
   * Computes a hash code from attributes: {@code service}, {@code onlyPassing}, {@code tags}, {@code failover}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + service.hashCode();
    h += (h << 5) + Objects.hashCode(onlyPassing);
    h += (h << 5) + Objects.hashCode(tags);
    h += (h << 5) + Objects.hashCode(failover);
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceQuery} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ServiceQuery")
        .omitNullValues()
        .add("service", service)
        .add("onlyPassing", onlyPassing)
        .add("tags", tags)
        .add("failover", failover)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ServiceQuery", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends ServiceQuery {
    @Nullable String service;
    @Nullable Optional<Boolean> onlyPassing = Optional.empty();
    @Nullable Optional<List<String>> tags = Optional.empty();
    @Nullable Optional<Failover> failover = Optional.empty();
    @JsonProperty("Service")
    public void setService(String service) {
      this.service = service;
    }
    @JsonProperty("OnlyPassing")
    public void setOnlyPassing(Optional<Boolean> onlyPassing) {
      this.onlyPassing = onlyPassing;
    }
    @JsonProperty("Tags")
    public void setTags(Optional<List<String>> tags) {
      this.tags = tags;
    }
    @JsonProperty("Failover")
    public void setFailover(Optional<Failover> failover) {
      this.failover = failover;
    }
    @Override
    public String getService() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getOnlyPassing() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<List<String>> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Failover> getFailover() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableServiceQuery fromJson(Json json) {
    ImmutableServiceQuery.Builder builder = ImmutableServiceQuery.builder();
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.onlyPassing != null) {
      builder.onlyPassing(json.onlyPassing);
    }
    if (json.tags != null) {
      builder.tags(json.tags);
    }
    if (json.failover != null) {
      builder.failover(json.failover);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ServiceQuery} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ServiceQuery instance
   */
  public static ImmutableServiceQuery copyOf(ServiceQuery instance) {
    if (instance instanceof ImmutableServiceQuery) {
      return (ImmutableServiceQuery) instance;
    }
    return ImmutableServiceQuery.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableServiceQuery ImmutableServiceQuery}.
   * <pre>
   * ImmutableServiceQuery.builder()
   *    .service(String) // required {@link ServiceQuery#getService() service}
   *    .onlyPassing(Boolean) // optional {@link ServiceQuery#getOnlyPassing() onlyPassing}
   *    .tags(List&amp;lt;String&amp;gt;) // optional {@link ServiceQuery#getTags() tags}
   *    .failover(org.kiwiproject.consul.model.query.Failover) // optional {@link ServiceQuery#getFailover() failover}
   *    .build();
   * </pre>
   * @return A new ImmutableServiceQuery builder
   */
  public static ImmutableServiceQuery.Builder builder() {
    return new ImmutableServiceQuery.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableServiceQuery ImmutableServiceQuery}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ServiceQuery", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String service;
    private @Nullable Boolean onlyPassing;
    private @Nullable List<String> tags;
    private @Nullable Failover failover;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceQuery} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ServiceQuery instance) {
      Objects.requireNonNull(instance, "instance");
      this.service(instance.getService());
      Optional<Boolean> onlyPassingOptional = instance.getOnlyPassing();
      if (onlyPassingOptional.isPresent()) {
        onlyPassing(onlyPassingOptional);
      }
      Optional<List<String>> tagsOptional = instance.getTags();
      if (tagsOptional.isPresent()) {
        tags(tagsOptional);
      }
      Optional<Failover> failoverOptional = instance.getFailover();
      if (failoverOptional.isPresent()) {
        failover(failoverOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceQuery#getService() service} attribute.
     * @param service The value for service 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Service")
    public final Builder service(String service) {
      this.service = Objects.requireNonNull(service, "service");
      initBits &= ~INIT_BIT_SERVICE;
      return this;
    }

    /**
     * Initializes the optional value {@link ServiceQuery#getOnlyPassing() onlyPassing} to onlyPassing.
     * @param onlyPassing The value for onlyPassing
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder onlyPassing(boolean onlyPassing) {
      this.onlyPassing = onlyPassing;
      return this;
    }

    /**
     * Initializes the optional value {@link ServiceQuery#getOnlyPassing() onlyPassing} to onlyPassing.
     * @param onlyPassing The value for onlyPassing
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("OnlyPassing")
    public final Builder onlyPassing(Optional<Boolean> onlyPassing) {
      this.onlyPassing = onlyPassing.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ServiceQuery#getTags() tags} to tags.
     * @param tags The value for tags
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tags(List<String> tags) {
      this.tags = Objects.requireNonNull(tags, "tags");
      return this;
    }

    /**
     * Initializes the optional value {@link ServiceQuery#getTags() tags} to tags.
     * @param tags The value for tags
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Tags")
    public final Builder tags(Optional<? extends List<String>> tags) {
      this.tags = tags.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ServiceQuery#getFailover() failover} to failover.
     * @param failover The value for failover
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder failover(Failover failover) {
      this.failover = Objects.requireNonNull(failover, "failover");
      return this;
    }

    /**
     * Initializes the optional value {@link ServiceQuery#getFailover() failover} to failover.
     * @param failover The value for failover
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Failover")
    public final Builder failover(Optional<? extends Failover> failover) {
      this.failover = failover.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableServiceQuery ImmutableServiceQuery}.
     * @return An immutable instance of ServiceQuery
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableServiceQuery build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableServiceQuery(service, onlyPassing, tags, failover);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE) != 0) attributes.add("service");
      return "Cannot build ServiceQuery, some of required attributes are not set " + attributes;
    }
  }
}
