/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.kiwiproject.consul.config.CacheConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutInterceptor
implements Interceptor {
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutInterceptor.class);
    private final CacheConfig config;

    public TimeoutInterceptor(CacheConfig config) {
        this.config = config;
    }

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        String waitQuery;
        Duration waitDuration;
        Request request = chain.request();
        int readTimeout = chain.readTimeoutMillis();
        if (request.url().encodedPath().contains("snapshot")) {
            readTimeout = (int)Duration.ofHours(1L).toMillis();
        } else if (this.config.isTimeoutAutoAdjustmentEnabled() && Objects.nonNull(waitDuration = TimeoutInterceptor.parseWaitQuery(waitQuery = request.url().queryParameter("wait")))) {
            int waitDurationMs = (int)waitDuration.toMillis();
            int readTimeoutConfigMargin = (int)this.config.getTimeoutAutoAdjustmentMargin().toMillis();
            int readTimeoutRequiredMargin = (int)Math.ceil((double)waitDurationMs / 16.0);
            readTimeout = waitDurationMs + readTimeoutRequiredMargin + readTimeoutConfigMargin;
        }
        return chain.withReadTimeout(readTimeout, TimeUnit.MILLISECONDS).proceed(request);
    }

    @VisibleForTesting
    static @Nullable Duration parseWaitQuery(String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return null;
        }
        Duration wait = null;
        try {
            if (query.contains("m")) {
                wait = Duration.ofMinutes(Long.parseLong(query.replace("m", "")));
            } else if (query.contains("s")) {
                wait = Duration.ofSeconds(Long.parseLong(query.replace("s", "")));
            }
        }
        catch (Exception e) {
            LOG.warn("Error while extracting wait duration from query parameters: {}", (Object)query);
        }
        return wait;
    }
}

