/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.kiwiproject.consul.model.acl.ImmutableRole;
import org.kiwiproject.consul.model.acl.ImmutableRoleNodeIdentity;
import org.kiwiproject.consul.model.acl.ImmutableRolePolicyLink;
import org.kiwiproject.consul.model.acl.ImmutableRoleServiceIdentity;

@JsonSerialize(as=ImmutableRole.class)
@JsonDeserialize(as=ImmutableRole.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
@Value.Style(jakarta=true)
public abstract class Role {
    @JsonProperty(value="Name")
    public abstract String name();

    @JsonProperty(value="ID")
    public abstract Optional<String> id();

    @JsonProperty(value="Description")
    public abstract Optional<String> description();

    @JsonProperty(value="Policies")
    @JsonDeserialize(as=ImmutableList.class, contentAs=RolePolicyLink.class)
    public abstract List<RolePolicyLink> policies();

    @JsonProperty(value="ServiceIdentities")
    @JsonDeserialize(as=ImmutableList.class, contentAs=RoleServiceIdentity.class)
    public abstract List<RoleServiceIdentity> serviceIdentities();

    @JsonProperty(value="NodeIdentities")
    @JsonDeserialize(as=ImmutableList.class, contentAs=RoleNodeIdentity.class)
    public abstract List<RoleNodeIdentity> nodeIdentities();

    @JsonProperty(value="Namespace")
    public abstract Optional<String> namespace();

    @JsonSerialize(as=ImmutableRoleNodeIdentity.class)
    @JsonDeserialize(as=ImmutableRoleNodeIdentity.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Value.Immutable
    public static abstract class RoleNodeIdentity {
        @JsonProperty(value="NodeName")
        public abstract String name();

        @JsonProperty(value="Datacenter")
        public abstract String datacenter();
    }

    @JsonSerialize(as=ImmutableRoleServiceIdentity.class)
    @JsonDeserialize(as=ImmutableRoleServiceIdentity.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Value.Immutable
    public static abstract class RoleServiceIdentity {
        @JsonProperty(value="ServiceName")
        public abstract String name();

        @JsonProperty(value="Datacenters")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public abstract List<String> datacenters();
    }

    @JsonSerialize(as=ImmutableRolePolicyLink.class)
    @JsonDeserialize(as=ImmutableRolePolicyLink.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Value.Immutable
    public static abstract class RolePolicyLink {
        @JsonProperty(value="ID")
        public abstract Optional<String> id();

        @JsonProperty(value="Name")
        public abstract Optional<String> name();
    }
}

