/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.option;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.immutables.value.Value;
import org.kiwiproject.consul.option.ConsistencyMode;
import org.kiwiproject.consul.option.ImmutableTransactionOptions;
import org.kiwiproject.consul.option.Options;
import org.kiwiproject.consul.option.ParamAdder;

@Value.Immutable
@Value.Style(jakarta=true)
public abstract class TransactionOptions
implements ParamAdder {
    @Deprecated(since="1.3.3", forRemoval=true)
    public static final TransactionOptions BLANK = ImmutableTransactionOptions.builder().build();

    public abstract Optional<String> getDatacenter();

    @Value.Default
    public ConsistencyMode getConsistencyMode() {
        return ConsistencyMode.DEFAULT;
    }

    @Override
    public Map<String, Object> toQuery() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Optional<String> consistencyMode = this.getConsistencyMode().toParam();
        consistencyMode.ifPresent(s -> result.put((String)s, "true"));
        Options.optionallyAdd(result, "dc", this.getDatacenter());
        return result;
    }

    @Override
    public Map<String, String> toHeaders() {
        ConsistencyMode consistencyMode = this.getConsistencyMode();
        return new HashMap<String, String>(consistencyMode.getAdditionalHeaders());
    }
}

