/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul;

import java.util.List;
import java.util.Map;
import org.kiwiproject.consul.BaseClient;
import org.kiwiproject.consul.config.ClientConfig;
import org.kiwiproject.consul.monitoring.ClientEventCallback;
import org.kiwiproject.consul.option.Options;
import org.kiwiproject.consul.option.QueryOptions;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.QueryMap;

public class StatusClient
extends BaseClient {
    private static final String CLIENT_NAME = "status";
    private final Api api;

    StatusClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = (Api)retrofit.create(Api.class);
    }

    public String getLeader() {
        return this.getLeader(Options.BLANK_QUERY_OPTIONS);
    }

    public String getLeader(QueryOptions queryOptions) {
        return this.http.extract(this.api.getLeader(queryOptions.toQuery()), new Integer[0]).replace("\"", "").trim();
    }

    public List<String> getPeers() {
        return this.getPeers(Options.BLANK_QUERY_OPTIONS);
    }

    public List<String> getPeers(QueryOptions queryOptions) {
        return this.http.extract(this.api.getPeers(queryOptions.toQuery()), new Integer[0]);
    }

    static interface Api {
        @GET(value="status/leader")
        public Call<String> getLeader(@QueryMap Map<String, Object> var1);

        @GET(value="status/peers")
        public Call<List<String>> getPeers(@QueryMap Map<String, Object> var1);
    }
}

