/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.kiwiproject.consul.config.CacheConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutInterceptor
implements Interceptor {
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutInterceptor.class);
    private final CacheConfig config;

    public TimeoutInterceptor(CacheConfig config) {
        this.config = config;
    }

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        String waitQuery;
        Duration waitDuration;
        Request request = chain.request();
        int readTimeout = chain.readTimeoutMillis();
        if (request.url().encodedPath().contains("snapshot")) {
            readTimeout = (int)Duration.ofHours(1L).toMillis();
        } else if (this.config.isTimeoutAutoAdjustmentEnabled() && Objects.nonNull(waitDuration = TimeoutInterceptor.parseWaitQuery(waitQuery = request.url().queryParameter("wait")))) {
            int waitDurationMs = (int)waitDuration.toMillis();
            int readTimeoutConfigMargin = (int)this.config.getTimeoutAutoAdjustmentMargin().toMillis();
            int readTimeoutRequiredMargin = (int)Math.ceil((double)waitDurationMs / 16.0);
            readTimeout = waitDurationMs + readTimeoutRequiredMargin + readTimeoutConfigMargin;
        }
        return chain.withReadTimeout(readTimeout, TimeUnit.MILLISECONDS).proceed(request);
    }

    @VisibleForTesting
    static @Nullable Duration parseWaitQuery(String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return null;
        }
        try {
            if (query.endsWith("m")) {
                return Duration.ofMinutes(TimeoutInterceptor.numberFrom(query));
            }
            if (query.endsWith("s")) {
                return Duration.ofSeconds(TimeoutInterceptor.numberFrom(query));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOG.warn("Invalid wait query '{}'. Expected a number plus 's' or 'm' ('10s' for seconds, '5m' for minutes).", (Object)query);
        return null;
    }

    private static long numberFrom(String query) {
        return Long.parseLong(query.substring(0, query.length() - 1));
    }
}

