/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.catalog.CatalogNode;
import org.kiwiproject.consul.model.health.Node;
import org.kiwiproject.consul.model.health.Service;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="CatalogNode", generator="Immutables")
public final class ImmutableCatalogNode
extends CatalogNode {
    private final Node node;
    private final ImmutableMap<String, Service> services;

    private ImmutableCatalogNode(Node node, ImmutableMap<String, Service> services) {
        this.node = node;
        this.services = services;
    }

    @Override
    @JsonProperty(value="Node")
    public Node getNode() {
        return this.node;
    }

    @JsonProperty(value="Services")
    public ImmutableMap<String, Service> getServices() {
        return this.services;
    }

    public final ImmutableCatalogNode withNode(Node value) {
        if (this.node == value) {
            return this;
        }
        Node newValue = Objects.requireNonNull(value, "node");
        return new ImmutableCatalogNode(newValue, this.services);
    }

    public final ImmutableCatalogNode withServices(Map<String, ? extends Service> entries) {
        if (this.services == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCatalogNode(this.node, (ImmutableMap<String, Service>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogNode && this.equalTo(0, (ImmutableCatalogNode)another);
    }

    private boolean equalTo(int synthetic, ImmutableCatalogNode another) {
        return this.node.equals(another.node) && this.services.equals(another.services);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.node.hashCode();
        h += (h << 5) + this.services.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CatalogNode").omitNullValues().add("node", (Object)this.node).add("services", this.services).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCatalogNode fromJson(Json json) {
        Builder builder = ImmutableCatalogNode.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.services != null) {
            builder.putAllServices(json.services);
        }
        return builder.build();
    }

    public static ImmutableCatalogNode copyOf(CatalogNode instance) {
        if (instance instanceof ImmutableCatalogNode) {
            return (ImmutableCatalogNode)instance;
        }
        return ImmutableCatalogNode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CatalogNode", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private long initBits = 1L;
        @Nullable
        private Node node;
        private ImmutableMap.Builder<String, Service> services = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogNode instance) {
            Objects.requireNonNull(instance, "instance");
            this.node(instance.getNode());
            this.putAllServices(instance.getServices());
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder node(Node node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putServices(String key, Service value) {
            this.services.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putServices(Map.Entry<String, ? extends Service> entry) {
            this.services.put(entry);
            return this;
        }

        @JsonProperty(value="Services")
        @CanIgnoreReturnValue
        public final Builder services(Map<String, ? extends Service> entries) {
            this.services = ImmutableMap.builder();
            return this.putAllServices(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllServices(Map<String, ? extends Service> entries) {
            this.services.putAll(entries);
            return this;
        }

        public ImmutableCatalogNode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCatalogNode(this.node, (ImmutableMap<String, Service>)this.services.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            return "Cannot build CatalogNode, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CatalogNode", generator="Immutables")
    static final class Json
    extends CatalogNode {
        @Nullable
        Node node;
        @Nullable
        Map<String, Service> services = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(Node node) {
            this.node = node;
        }

        @JsonProperty(value="Services")
        public void setServices(Map<String, Service> services) {
            this.services = services;
        }

        @Override
        public Node getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Service> getServices() {
            throw new UnsupportedOperationException();
        }
    }
}

