/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.catalog.CatalogService;
import org.kiwiproject.consul.model.catalog.ServiceWeights;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="CatalogService", generator="Immutables")
public final class ImmutableCatalogService
extends CatalogService {
    private final String node;
    private final String address;
    @Nullable
    private final String datacenter;
    private final String serviceName;
    private final String serviceId;
    private final String serviceAddress;
    @Nullable
    private final Boolean serviceEnableTagOverride;
    private final int servicePort;
    private final ImmutableList<String> serviceTags;
    private final ImmutableMap<String, String> serviceMeta;
    @Nullable
    private final ServiceWeights serviceWeights;
    private final ImmutableMap<String, String> nodeMeta;

    private ImmutableCatalogService(String node, String address, @Nullable String datacenter, String serviceName, String serviceId, String serviceAddress, @Nullable Boolean serviceEnableTagOverride, int servicePort, ImmutableList<String> serviceTags, ImmutableMap<String, String> serviceMeta, @Nullable ServiceWeights serviceWeights, ImmutableMap<String, String> nodeMeta) {
        this.node = node;
        this.address = address;
        this.datacenter = datacenter;
        this.serviceName = serviceName;
        this.serviceId = serviceId;
        this.serviceAddress = serviceAddress;
        this.serviceEnableTagOverride = serviceEnableTagOverride;
        this.servicePort = servicePort;
        this.serviceTags = serviceTags;
        this.serviceMeta = serviceMeta;
        this.serviceWeights = serviceWeights;
        this.nodeMeta = nodeMeta;
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Address")
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    @JsonProperty(value="ServiceName")
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    @JsonProperty(value="ServiceID")
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    @JsonProperty(value="ServiceAddress")
    public String getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    @JsonProperty(value="ServiceEnableTagOverride")
    public Optional<Boolean> getServiceEnableTagOverride() {
        return Optional.ofNullable(this.serviceEnableTagOverride);
    }

    @Override
    @JsonProperty(value="ServicePort")
    public int getServicePort() {
        return this.servicePort;
    }

    @JsonProperty(value="ServiceTags")
    public ImmutableList<String> getServiceTags() {
        return this.serviceTags;
    }

    @JsonProperty(value="ServiceMeta")
    public ImmutableMap<String, String> getServiceMeta() {
        return this.serviceMeta;
    }

    @Override
    @JsonProperty(value="ServiceWeights")
    public Optional<ServiceWeights> getServiceWeights() {
        return Optional.ofNullable(this.serviceWeights);
    }

    @JsonProperty(value="NodeMeta")
    public ImmutableMap<String, String> getNodeMeta() {
        return this.nodeMeta;
    }

    public final ImmutableCatalogService withNode(String value) {
        String newValue = Objects.requireNonNull(value, "node");
        if (this.node.equals(newValue)) {
            return this;
        }
        return new ImmutableCatalogService(newValue, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta);
    }

    public final ImmutableCatalogService withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, newValue, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta);
    }

    public final ImmutableCatalogService withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, newValue, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta);
    }

    public final ImmutableCatalogService withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, value, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceName(String value) {
        String newValue = Objects.requireNonNull(value, "serviceName");
        if (this.serviceName.equals(newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, newValue, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceId(String value) {
        String newValue = Objects.requireNonNull(value, "serviceId");
        if (this.serviceId.equals(newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, newValue, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceAddress(String value) {
        String newValue = Objects.requireNonNull(value, "serviceAddress");
        if (this.serviceAddress.equals(newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, newValue, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceEnableTagOverride(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.serviceEnableTagOverride, newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, newValue, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceEnableTagOverride(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.serviceEnableTagOverride, value)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, value, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta);
    }

    public final ImmutableCatalogService withServicePort(int value) {
        if (this.servicePort == value) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, value, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, (ImmutableList<String>)newValue, this.serviceMeta, this.serviceWeights, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceTags(Iterable<String> elements) {
        if (this.serviceTags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, (ImmutableList<String>)newValue, this.serviceMeta, this.serviceWeights, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceMeta(Map<String, ? extends String> entries) {
        if (this.serviceMeta == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, (ImmutableMap<String, String>)newValue, this.serviceWeights, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceWeights(ServiceWeights value) {
        ServiceWeights newValue = Objects.requireNonNull(value, "serviceWeights");
        if (this.serviceWeights == newValue) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, newValue, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceWeights(Optional<? extends ServiceWeights> optional) {
        ServiceWeights value = optional.orElse(null);
        if (this.serviceWeights == value) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, value, this.nodeMeta);
    }

    public final ImmutableCatalogService withNodeMeta(Map<String, ? extends String> entries) {
        if (this.nodeMeta == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogService && this.equalTo(0, (ImmutableCatalogService)another);
    }

    private boolean equalTo(int synthetic, ImmutableCatalogService another) {
        return this.node.equals(another.node) && this.address.equals(another.address) && Objects.equals(this.datacenter, another.datacenter) && this.serviceName.equals(another.serviceName) && this.serviceId.equals(another.serviceId) && this.serviceAddress.equals(another.serviceAddress) && Objects.equals(this.serviceEnableTagOverride, another.serviceEnableTagOverride) && this.servicePort == another.servicePort && this.serviceTags.equals(another.serviceTags) && this.serviceMeta.equals(another.serviceMeta) && Objects.equals(this.serviceWeights, another.serviceWeights) && this.nodeMeta.equals(another.nodeMeta);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.node.hashCode();
        h += (h << 5) + this.address.hashCode();
        h += (h << 5) + Objects.hashCode(this.datacenter);
        h += (h << 5) + this.serviceName.hashCode();
        h += (h << 5) + this.serviceId.hashCode();
        h += (h << 5) + this.serviceAddress.hashCode();
        h += (h << 5) + Objects.hashCode(this.serviceEnableTagOverride);
        h += (h << 5) + this.servicePort;
        h += (h << 5) + this.serviceTags.hashCode();
        h += (h << 5) + this.serviceMeta.hashCode();
        h += (h << 5) + Objects.hashCode(this.serviceWeights);
        h += (h << 5) + this.nodeMeta.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CatalogService").omitNullValues().add("node", (Object)this.node).add("address", (Object)this.address).add("datacenter", (Object)this.datacenter).add("serviceName", (Object)this.serviceName).add("serviceId", (Object)this.serviceId).add("serviceAddress", (Object)this.serviceAddress).add("serviceEnableTagOverride", (Object)this.serviceEnableTagOverride).add("servicePort", this.servicePort).add("serviceTags", this.serviceTags).add("serviceMeta", this.serviceMeta).add("serviceWeights", (Object)this.serviceWeights).add("nodeMeta", this.nodeMeta).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCatalogService fromJson(Json json) {
        Builder builder = ImmutableCatalogService.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.datacenter != null) {
            builder.datacenter(json.datacenter);
        }
        if (json.serviceName != null) {
            builder.serviceName(json.serviceName);
        }
        if (json.serviceId != null) {
            builder.serviceId(json.serviceId);
        }
        if (json.serviceAddress != null) {
            builder.serviceAddress(json.serviceAddress);
        }
        if (json.serviceEnableTagOverride != null) {
            builder.serviceEnableTagOverride(json.serviceEnableTagOverride);
        }
        if (json.servicePortIsSet) {
            builder.servicePort(json.servicePort);
        }
        if (json.serviceTags != null) {
            builder.addAllServiceTags(json.serviceTags);
        }
        if (json.serviceMeta != null) {
            builder.putAllServiceMeta(json.serviceMeta);
        }
        if (json.serviceWeights != null) {
            builder.serviceWeights(json.serviceWeights);
        }
        if (json.nodeMeta != null) {
            builder.putAllNodeMeta(json.nodeMeta);
        }
        return builder.build();
    }

    public static ImmutableCatalogService copyOf(CatalogService instance) {
        if (instance instanceof ImmutableCatalogService) {
            return (ImmutableCatalogService)instance;
        }
        return ImmutableCatalogService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CatalogService", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_ADDRESS = 2L;
        private static final long INIT_BIT_SERVICE_NAME = 4L;
        private static final long INIT_BIT_SERVICE_ID = 8L;
        private static final long INIT_BIT_SERVICE_ADDRESS = 16L;
        private static final long INIT_BIT_SERVICE_PORT = 32L;
        private long initBits = 63L;
        @Nullable
        private String node;
        @Nullable
        private String address;
        @Nullable
        private String datacenter;
        @Nullable
        private String serviceName;
        @Nullable
        private String serviceId;
        @Nullable
        private String serviceAddress;
        @Nullable
        private Boolean serviceEnableTagOverride;
        private int servicePort;
        private ImmutableList.Builder<String> serviceTags = ImmutableList.builder();
        private ImmutableMap.Builder<String, String> serviceMeta = ImmutableMap.builder();
        @Nullable
        private ServiceWeights serviceWeights;
        private ImmutableMap.Builder<String, String> nodeMeta = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogService instance) {
            Objects.requireNonNull(instance, "instance");
            this.node(instance.getNode());
            this.address(instance.getAddress());
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            this.serviceName(instance.getServiceName());
            this.serviceId(instance.getServiceId());
            this.serviceAddress(instance.getServiceAddress());
            Optional<Boolean> serviceEnableTagOverrideOptional = instance.getServiceEnableTagOverride();
            if (serviceEnableTagOverrideOptional.isPresent()) {
                this.serviceEnableTagOverride(serviceEnableTagOverrideOptional);
            }
            this.servicePort(instance.getServicePort());
            this.addAllServiceTags(instance.getServiceTags());
            this.putAllServiceMeta(instance.getServiceMeta());
            Optional<ServiceWeights> serviceWeightsOptional = instance.getServiceWeights();
            if (serviceWeightsOptional.isPresent()) {
                this.serviceWeights(serviceWeightsOptional);
            }
            this.putAllNodeMeta(instance.getNodeMeta());
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder node(String node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Address")
        @CanIgnoreReturnValue
        public final Builder address(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            return this;
        }

        @JsonProperty(value="Datacenter")
        @CanIgnoreReturnValue
        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        @JsonProperty(value="ServiceName")
        @CanIgnoreReturnValue
        public final Builder serviceName(String serviceName) {
            this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="ServiceID")
        @CanIgnoreReturnValue
        public final Builder serviceId(String serviceId) {
            this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="ServiceAddress")
        @CanIgnoreReturnValue
        public final Builder serviceAddress(String serviceAddress) {
            this.serviceAddress = Objects.requireNonNull(serviceAddress, "serviceAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceEnableTagOverride(boolean serviceEnableTagOverride) {
            this.serviceEnableTagOverride = serviceEnableTagOverride;
            return this;
        }

        @JsonProperty(value="ServiceEnableTagOverride")
        @CanIgnoreReturnValue
        public final Builder serviceEnableTagOverride(Optional<Boolean> serviceEnableTagOverride) {
            this.serviceEnableTagOverride = serviceEnableTagOverride.orElse(null);
            return this;
        }

        @JsonProperty(value="ServicePort")
        @CanIgnoreReturnValue
        public final Builder servicePort(int servicePort) {
            this.servicePort = servicePort;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceTags(String element) {
            this.serviceTags.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceTags(String ... elements) {
            this.serviceTags.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="ServiceTags")
        @CanIgnoreReturnValue
        public final Builder serviceTags(Iterable<String> elements) {
            this.serviceTags = ImmutableList.builder();
            return this.addAllServiceTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllServiceTags(Iterable<String> elements) {
            this.serviceTags.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putServiceMeta(String key, String value) {
            this.serviceMeta.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putServiceMeta(Map.Entry<String, ? extends String> entry) {
            this.serviceMeta.put(entry);
            return this;
        }

        @JsonProperty(value="ServiceMeta")
        @CanIgnoreReturnValue
        public final Builder serviceMeta(Map<String, ? extends String> entries) {
            this.serviceMeta = ImmutableMap.builder();
            return this.putAllServiceMeta(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllServiceMeta(Map<String, ? extends String> entries) {
            this.serviceMeta.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceWeights(ServiceWeights serviceWeights) {
            this.serviceWeights = Objects.requireNonNull(serviceWeights, "serviceWeights");
            return this;
        }

        @JsonProperty(value="ServiceWeights")
        @CanIgnoreReturnValue
        public final Builder serviceWeights(Optional<? extends ServiceWeights> serviceWeights) {
            this.serviceWeights = serviceWeights.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNodeMeta(String key, String value) {
            this.nodeMeta.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNodeMeta(Map.Entry<String, ? extends String> entry) {
            this.nodeMeta.put(entry);
            return this;
        }

        @JsonProperty(value="NodeMeta")
        @CanIgnoreReturnValue
        public final Builder nodeMeta(Map<String, ? extends String> entries) {
            this.nodeMeta = ImmutableMap.builder();
            return this.putAllNodeMeta(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllNodeMeta(Map<String, ? extends String> entries) {
            this.nodeMeta.putAll(entries);
            return this;
        }

        public ImmutableCatalogService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, (ImmutableList<String>)this.serviceTags.build(), (ImmutableMap<String, String>)this.serviceMeta.build(), this.serviceWeights, (ImmutableMap<String, String>)this.nodeMeta.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("serviceName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("serviceId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("serviceAddress");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("servicePort");
            }
            return "Cannot build CatalogService, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CatalogService", generator="Immutables")
    static final class Json
    extends CatalogService {
        @Nullable
        String node;
        @Nullable
        String address;
        @Nullable
        Optional<String> datacenter = Optional.empty();
        @Nullable
        String serviceName;
        @Nullable
        String serviceId;
        @Nullable
        String serviceAddress;
        @Nullable
        Optional<Boolean> serviceEnableTagOverride = Optional.empty();
        int servicePort;
        boolean servicePortIsSet;
        @Nullable
        List<String> serviceTags = ImmutableList.of();
        @Nullable
        Map<String, String> serviceMeta = ImmutableMap.of();
        @Nullable
        Optional<ServiceWeights> serviceWeights = Optional.empty();
        @Nullable
        Map<String, String> nodeMeta = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="ServiceName")
        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="ServiceAddress")
        public void setServiceAddress(String serviceAddress) {
            this.serviceAddress = serviceAddress;
        }

        @JsonProperty(value="ServiceEnableTagOverride")
        public void setServiceEnableTagOverride(Optional<Boolean> serviceEnableTagOverride) {
            this.serviceEnableTagOverride = serviceEnableTagOverride;
        }

        @JsonProperty(value="ServicePort")
        public void setServicePort(int servicePort) {
            this.servicePort = servicePort;
            this.servicePortIsSet = true;
        }

        @JsonProperty(value="ServiceTags")
        public void setServiceTags(List<String> serviceTags) {
            this.serviceTags = serviceTags;
        }

        @JsonProperty(value="ServiceMeta")
        public void setServiceMeta(Map<String, String> serviceMeta) {
            this.serviceMeta = serviceMeta;
        }

        @JsonProperty(value="ServiceWeights")
        public void setServiceWeights(Optional<ServiceWeights> serviceWeights) {
            this.serviceWeights = serviceWeights;
        }

        @JsonProperty(value="NodeMeta")
        public void setNodeMeta(Map<String, String> nodeMeta) {
            this.nodeMeta = nodeMeta;
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDatacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getServiceEnableTagOverride() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getServicePort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getServiceTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getServiceMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServiceWeights> getServiceWeights() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getNodeMeta() {
            throw new UnsupportedOperationException();
        }
    }
}

