/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.health;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.health.HealthCheck;
import org.kiwiproject.consul.model.health.Node;
import org.kiwiproject.consul.model.health.Service;
import org.kiwiproject.consul.model.health.ServiceCheck;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="ServiceCheck", generator="Immutables")
public final class ImmutableServiceCheck
extends ServiceCheck {
    private final Node node;
    private final Service service;
    private final ImmutableList<HealthCheck> checks;

    private ImmutableServiceCheck(Node node, Service service, ImmutableList<HealthCheck> checks) {
        this.node = node;
        this.service = service;
        this.checks = checks;
    }

    @Override
    @JsonProperty(value="Node")
    public Node getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Service")
    public Service getService() {
        return this.service;
    }

    @JsonProperty(value="Checks")
    @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
    public ImmutableList<HealthCheck> getChecks() {
        return this.checks;
    }

    public final ImmutableServiceCheck withNode(Node value) {
        if (this.node == value) {
            return this;
        }
        Node newValue = Objects.requireNonNull(value, "node");
        return new ImmutableServiceCheck(newValue, this.service, this.checks);
    }

    public final ImmutableServiceCheck withService(Service value) {
        if (this.service == value) {
            return this;
        }
        Service newValue = Objects.requireNonNull(value, "service");
        return new ImmutableServiceCheck(this.node, newValue, this.checks);
    }

    public final ImmutableServiceCheck withChecks(HealthCheck ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableServiceCheck(this.node, this.service, (ImmutableList<HealthCheck>)newValue);
    }

    public final ImmutableServiceCheck withChecks(Iterable<? extends HealthCheck> elements) {
        if (this.checks == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableServiceCheck(this.node, this.service, (ImmutableList<HealthCheck>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceCheck && this.equalTo(0, (ImmutableServiceCheck)another);
    }

    private boolean equalTo(int synthetic, ImmutableServiceCheck another) {
        return this.node.equals(another.node) && this.service.equals(another.service) && this.checks.equals(another.checks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.node.hashCode();
        h += (h << 5) + this.service.hashCode();
        h += (h << 5) + this.checks.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServiceCheck").omitNullValues().add("node", (Object)this.node).add("service", (Object)this.service).add("checks", this.checks).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServiceCheck fromJson(Json json) {
        Builder builder = ImmutableServiceCheck.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.checks != null) {
            builder.addAllChecks(json.checks);
        }
        return builder.build();
    }

    public static ImmutableServiceCheck copyOf(ServiceCheck instance) {
        if (instance instanceof ImmutableServiceCheck) {
            return (ImmutableServiceCheck)instance;
        }
        return ImmutableServiceCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServiceCheck", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private long initBits = 3L;
        @Nullable
        private Node node;
        @Nullable
        private Service service;
        private ImmutableList.Builder<HealthCheck> checks = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServiceCheck instance) {
            Objects.requireNonNull(instance, "instance");
            this.node(instance.getNode());
            this.service(instance.getService());
            this.addAllChecks(instance.getChecks());
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder node(Node node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Service")
        @CanIgnoreReturnValue
        public final Builder service(Service service) {
            this.service = Objects.requireNonNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChecks(HealthCheck element) {
            this.checks.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChecks(HealthCheck ... elements) {
            this.checks.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Checks")
        @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
        @CanIgnoreReturnValue
        public final Builder checks(Iterable<? extends HealthCheck> elements) {
            this.checks = ImmutableList.builder();
            return this.addAllChecks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllChecks(Iterable<? extends HealthCheck> elements) {
            this.checks.addAll(elements);
            return this;
        }

        public ImmutableServiceCheck build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceCheck(this.node, this.service, (ImmutableList<HealthCheck>)this.checks.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build ServiceCheck, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ServiceCheck", generator="Immutables")
    static final class Json
    extends ServiceCheck {
        @Nullable
        Node node;
        @Nullable
        Service service;
        @Nullable
        List<HealthCheck> checks = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(Node node) {
            this.node = node;
        }

        @JsonProperty(value="Service")
        public void setService(Service service) {
            this.service = service;
        }

        @JsonProperty(value="Checks")
        @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
        public void setChecks(List<HealthCheck> checks) {
            this.checks = checks;
        }

        @Override
        public Node getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Service getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<HealthCheck> getChecks() {
            throw new UnsupportedOperationException();
        }
    }
}

