/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.util.failover;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.util.Collection;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kiwiproject.consul.ConsulException;
import org.kiwiproject.consul.util.failover.MaxFailoverAttemptsExceededException;
import org.kiwiproject.consul.util.failover.strategy.BlacklistingConsulFailoverStrategy;
import org.kiwiproject.consul.util.failover.strategy.ConsulFailoverStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulFailoverInterceptor
implements Interceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ConsulFailoverInterceptor.class);
    private static final int DEFAULT_MAX_FAILOVER_ATTEMPTS = 10;
    private final ConsulFailoverStrategy strategy;
    private int maxFailoverAttempts = 10;

    public ConsulFailoverInterceptor(Collection<HostAndPort> targets, long timeout) {
        this(new BlacklistingConsulFailoverStrategy(targets, timeout));
    }

    public ConsulFailoverInterceptor(ConsulFailoverStrategy strategy) {
        this.strategy = strategy;
    }

    public ConsulFailoverInterceptor withMaxFailoverAttempts(int maxFailoverAttempts) {
        Preconditions.checkArgument((maxFailoverAttempts > 0 ? 1 : 0) != 0, (Object)"maxFailoverAttempts must be positive");
        this.maxFailoverAttempts = maxFailoverAttempts;
        return this;
    }

    public int maxFailoverAttempts() {
        return this.maxFailoverAttempts;
    }

    public @NonNull Response intercept(Interceptor.Chain chain) {
        try {
            Request originalRequest = chain.request();
            if (this.strategy.isRequestViable(originalRequest)) {
                Optional<Request> maybeNextRequest;
                Request previousRequest = originalRequest;
                int currentAttempt = 1;
                while ((maybeNextRequest = this.strategy.computeNextStage(previousRequest)).isPresent()) {
                    Request nextRequest = maybeNextRequest.orElseThrow(IllegalStateException::new);
                    try {
                        previousRequest = nextRequest;
                        Response response = chain.proceed(nextRequest);
                        return response;
                    }
                    catch (Exception ex) {
                        ConsulFailoverInterceptor.logExceptionThrownOnRequest(LOG, ex, nextRequest);
                        this.strategy.markRequestFailed(nextRequest);
                        Exception exception = ex;
                        if (++currentAttempt <= this.maxFailoverAttempts) continue;
                        throw new MaxFailoverAttemptsExceededException(String.format("Reached max failover attempts (%d). Giving up.", this.maxFailoverAttempts), exception);
                    }
                }
                throw new ConsulException("Unable to successfully determine a viable host for communication.");
            }
            throw new ConsulException("Consul failover strategy has determined that there are no viable hosts remaining.");
        }
        finally {
            this.strategy.reset();
        }
    }

    @VisibleForTesting
    static void logExceptionThrownOnRequest(@NonNull Logger logger, @NonNull Exception ex, @NonNull Request request) {
        HttpUrl url = request.url();
        if (logger.isDebugEnabled()) {
            logger.debug("Got error when connecting to {}", (Object)url, (Object)ex);
        } else {
            logger.warn("Got '{}:{}' when connecting to {} (enable DEBUG level to see stack trace)", new Object[]{ex.getClass().getName(), ex.getMessage(), url});
        }
    }
}

