/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kiwiproject.consul.BaseClient;
import org.kiwiproject.consul.ConsulClients;
import org.kiwiproject.consul.config.ClientConfig;
import org.kiwiproject.consul.model.session.Session;
import org.kiwiproject.consul.model.session.SessionCreatedResponse;
import org.kiwiproject.consul.model.session.SessionInfo;
import org.kiwiproject.consul.monitoring.ClientEventCallback;
import org.kiwiproject.consul.util.Lists;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public class SessionClient
extends BaseClient {
    private static final String CLIENT_NAME = "session";
    private final Api api;

    SessionClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = (Api)retrofit.create(Api.class);
    }

    public SessionCreatedResponse createSession(Session value) {
        return this.createSession(value, null);
    }

    public SessionCreatedResponse createSession(Session value, String dc) {
        return this.http.extract(this.api.createSession(value, ConsulClients.dcQuery(dc)), new Integer[0]);
    }

    public Optional<SessionInfo> renewSession(String sessionId) {
        return this.renewSession(null, sessionId);
    }

    public Optional<SessionInfo> renewSession(String dc, String sessionId) {
        List<SessionInfo> sessionInfo = this.http.extract(this.api.renewSession(sessionId, Map.of(), ConsulClients.dcQuery(dc)), new Integer[0]);
        return Lists.firstValueOrEmpty(sessionInfo);
    }

    public void destroySession(String sessionId) {
        this.destroySession(sessionId, null);
    }

    public void destroySession(String sessionId, String dc) {
        this.http.handle(this.api.destroySession(sessionId, ConsulClients.dcQuery(dc)), new Integer[0]);
    }

    public Optional<SessionInfo> getSessionInfo(String sessionId) {
        return this.getSessionInfo(sessionId, null);
    }

    public Optional<SessionInfo> getSessionInfo(String sessionId, String dc) {
        List<SessionInfo> sessionInfo = this.http.extract(this.api.getSessionInfo(sessionId, ConsulClients.dcQuery(dc)), new Integer[0]);
        return Lists.firstValueOrEmpty(sessionInfo);
    }

    public List<SessionInfo> listSessions(String dc) {
        return this.http.extract(this.api.listSessions(ConsulClients.dcQuery(dc)), new Integer[0]);
    }

    public List<SessionInfo> listSessions() {
        return this.listSessions(null);
    }

    static interface Api {
        @PUT(value="session/create")
        public Call<SessionCreatedResponse> createSession(@Body Session var1, @QueryMap Map<String, String> var2);

        @PUT(value="session/renew/{sessionId}")
        public Call<List<SessionInfo>> renewSession(@Path(value="sessionId") String var1, @Body Map<String, String> var2, @QueryMap Map<String, String> var3);

        @PUT(value="session/destroy/{sessionId}")
        public Call<Void> destroySession(@Path(value="sessionId") String var1, @QueryMap Map<String, String> var2);

        @GET(value="session/info/{sessionId}")
        public Call<List<SessionInfo>> getSessionInfo(@Path(value="sessionId") String var1, @QueryMap Map<String, String> var2);

        @GET(value="session/list")
        public Call<List<SessionInfo>> listSessions(@QueryMap Map<String, String> var1);
    }
}

