/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.cache;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.cache.ServiceHealthKey;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="ServiceHealthKey", generator="Immutables")
public final class ImmutableServiceHealthKey
extends ServiceHealthKey {
    private final String serviceId;
    private final String host;
    private final Integer port;

    private ImmutableServiceHealthKey(String serviceId, String host, Integer port) {
        this.serviceId = serviceId;
        this.host = host;
        this.port = port;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    public final ImmutableServiceHealthKey withServiceId(String value) {
        String newValue = Objects.requireNonNull(value, "serviceId");
        if (this.serviceId.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceHealthKey(newValue, this.host, this.port);
    }

    public final ImmutableServiceHealthKey withHost(String value) {
        String newValue = Objects.requireNonNull(value, "host");
        if (this.host.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceHealthKey(this.serviceId, newValue, this.port);
    }

    public final ImmutableServiceHealthKey withPort(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "port");
        if (this.port.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceHealthKey(this.serviceId, this.host, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceHealthKey && this.equalsByValue((ImmutableServiceHealthKey)another);
    }

    private boolean equalsByValue(ImmutableServiceHealthKey another) {
        return this.serviceId.equals(another.serviceId) && this.host.equals(another.host) && this.port.equals(another.port);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.serviceId.hashCode();
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + this.port.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServiceHealthKey").omitNullValues().add("serviceId", (Object)this.serviceId).add("host", (Object)this.host).add("port", (Object)this.port).toString();
    }

    public static ImmutableServiceHealthKey copyOf(ServiceHealthKey instance) {
        if (instance instanceof ImmutableServiceHealthKey) {
            return (ImmutableServiceHealthKey)instance;
        }
        return ImmutableServiceHealthKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServiceHealthKey", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SERVICE_ID = 1L;
        private static final long INIT_BIT_HOST = 2L;
        private static final long INIT_BIT_PORT = 4L;
        private long initBits = 7L;
        @Nullable
        private String serviceId;
        @Nullable
        private String host;
        @Nullable
        private Integer port;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServiceHealthKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.serviceId(instance.getServiceId());
            this.host(instance.getHost());
            this.port(instance.getPort());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceId(String serviceId) {
            this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder port(Integer port) {
            this.port = Objects.requireNonNull(port, "port");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableServiceHealthKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceHealthKey(this.serviceId, this.host, this.port);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build ServiceHealthKey, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

